// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mfobject.cpp,v 3.3 2000/05/13 16:29:03 kudou Exp $
// class MetaFileObject
// ^t@C̈\NXBFrameObject pꂽNX
// ŁAMetafileObject NX̎QƂ

#include "pword.h"
#include "mfobject.h"
#include "metafile.h"
#include "objectid.h"
#include "unknowno.h"

// constructor
MetafileObject::MetafileObject(CrossPoint* cp, Metafile* mf)
  : FrameObject(cp)
{
  MetafileObject::mf = mf;
}

// constructor
MetafileObject::MetafileObject(CrossPoint* cp, MetafileObject* mfo)
  : FrameObject(cp)
{
  MetafileObject::mf = new Metafile(mfo->mf);
}

// destructor
MetafileObject::~MetafileObject()
{
  delete mf;
}

// display right slant line object
void
MetafileObject::DisplayObject(VDisplay* vdsp)
{
  Rect rect = GetInternalRect();
  mf->Redisplay(vdsp, rect);
}

// get object id
uword 
MetafileObject::GetObjectID()
{
  return IDMetafileObject;
}

// duplicator
FrameObject* 
MetafileObject::Duplicator(CrossPoint* cp)
{
  MetafileObject* mo = new MetafileObject(cp, this);
  if (!mo->mf->IsValid()) 
  {
    delete mo;
    return new UnknownObject(cp, True);
  }
  return mo;
}

// copy to clipboard
void 
MetafileObject::CopyToClipboard()
{
  mf->CopyToClipboard();
}
