// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: misc.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// misc

#include "pword.h"
#include <errno.h>
#include <math.h>
#include <stdlib.h>
#include "sjis.h"

int
gcd(int a, int b)
{
  for (;;)
  {
    assert(0 < a);
    assert(0 < b);
    
    if (a < b)
    {
      int tmp = a;
      a = b;
      b = tmp;
    }

    a -= ((a / b) * b);
    if (a == 0)
    {
      return(b);
    }
  }
}

int
ceil_log2(int a)
{
  int result = 0;
  unsigned int u = (unsigned int) a;
  if (1 < u)
  {
    --u;
    do
    {
      ++result;
      u >>= 1;
    } while (u != 0);
  }
  return(result);
}

// ------------------------------------------------------------
// string operations

char* 
dup_string(char* s)
{
  return(strcpy((char*) xmalloc(strlen(s) + 1), s));
}

// `size' is buffer size
char* 
copy_string(char* dest, char* src, int size)
{
  assert(0 < size);
  unsigned char* d = (unsigned char*) dest;
  if (0 < --size)
  {
    unsigned char* s = (unsigned char*) src;
    if (s == NULL)
    {
      s = (unsigned char*) "";
    }
    do
    {
      int c = *s++;
      if (iskanji(c))
      {
	*d = c;
	if (--size == 0 || (c = *s++, !iskanji2(c)))
	{
	  break;
	}
	++d;
      }
      if ((*d++ = c) == '\0')
      {
	break;
      }
    } while (--size != 0);
  }
  *d = '\0';
  return(dest);
}

// Returns length of sjis string J.  J is a zero terminated string.
int
jislen(sjis* j)
{
  sjis* s = j;
  while (*s++ != 0)
  {
  }
  return((int) (s - j - 1));
}

// jis_spread "spreads" CHARS into sjis zero-terminated string -- that is,
// it makes one-byte characters into two-byte goodies.  Return value of
// this function nust be free by caller.  This function returns result
// string length into *LEN_RET if LEN_RET is nonzero, that is not
// includeing zero-terminater.
sjis* 
jis_spread(char* chars, int num_chars, int* len_ret)
{
  sjis* result;
  
  // 1 for zero-terminater.
  int length = 1;
  {
    int i;
    for (i = 0; i < num_chars; ++i)
    {
      int ch = (unsigned char) chars[i];
      if (iskanji(ch))
      {
	++i;
	if (i < num_chars)
	{
	  int ch2 = (unsigned char) chars[i];
	  if (iskanji2(ch2))
	  {
	    ++length;
	  }
	}
      }
      else if (ch && ch != '\r')
      {
	++length;
      }
    }
  }
  
  // Special check for memory limit.
  if (length < 0 || MAX_NEW_SIZE < sizeof(sjis) * length)
  {
    length = (int) (MAX_NEW_SIZE / sizeof(sjis));
  }
  
  result = new sjis[length];
  --length;
  result[length] = 0;
  
  if (len_ret)
  {
    *len_ret = length;
  }

  {
    int i;
    for (i = 0; i != length;)
    {
      int ch = (unsigned char) *chars++;
      if (iskanji(ch))
      {
	int ch2 = (unsigned char) *chars++;
	if (iskanji2(ch2))
	{
	  result[i++] = MakeKanjiChar(ch, ch2);
	}
      }
      else if (iskana(ch))
      {
	result[i++] = MakeKanaChar(ch);
      }
      else if (ch && ch != '\r')
      {
	result[i++] = MakeAnsiChar(ch);
      }
    }
  }
  return(result);
}

// jisz_spread -- spread a null-terminated character string into sjis The
// caller OWNS the return string.
sjis* 
jisz_spread(char* chars, int* len_ret)
{
  return(jis_spread(chars, strlen(chars) + 1, len_ret));
}

// jis_squeeze "squeeze" CHARS into char zero-terminated string -- that is,
// it makes two-byte characters into one-byte goodies.  Return value of
// this function nust be free by caller.  This function returns result
// string length into *LEN_RET if LEN_RET is nonzero, that is not
// includeing zero-terminater.
char* 
jis_squeeze(sjis* chars, int num_chars, int* len_ret)
{
  char* result;
  
  // 1 for zero-terminater, and 1 for newline special.
  int length = 2;
  {
    int i;
    for (i = 0; i < num_chars; ++i)
    {
      sjis ch = chars[i];
      switch (GET_CHAR_TYPE(ch))
      {
       case CharType_ANSI:
	if (ch == NLC)
	{
	  ++length;
	}
	// fall through
	
       case CharType_KANA:
	++length;
	break;
	
       case CharType_KANJI:
	length += 2;
	break;
      }
    }
  }
  
  // Special check for memory limit.
  if (length < 0 || MAX_NEW_SIZE < sizeof(char) * length)
  {
    length = (int) (MAX_NEW_SIZE / sizeof(char));
  }

  result = new char[length];
  length -= 2;
  result[length] = 0;
  result[length + 1] = 0;
  
  if (len_ret)
  {
    *len_ret = length;
  }
  
  {
    int i;
    for (i = 0; i < length;)
    {
      sjis ch = *chars++;
      switch (GET_CHAR_TYPE(ch))
      {
       case CharType_ANSI:
       case CharType_KANA:
	if (ch == NLC)
	{
	  result[i++] = '\r';
	}
	result[i++] = (char) ch;
	break;
	
       case CharType_KANJI:
	result[i++] = (char) (ch >> 8);
	result[i++] = (char) ch;
	break;
      }
    }
  }
  return(result);
}

// ------------------------------------------------------------
// convert number <--> string

static sjis sjis_ascii_table[128] =
{
  0x0000,			// 00 NUL
  0x0000,			// 01 SOH
  0x0000,			// 02 STX
  0x0000,			// 03 ETX
  0x0000,			// 04 EOT
  0x0000,			// 05 ENQ
  0x0000,			// 06 ACK
  0x0000,			// 07 BEL
  0x0000,			// 08 BS 
  0x0000,			// 09 HT 
  0x0000,			// 0A NL 
  0x0000,			// 0B VT 
  0x0000,			// 0C NP 
  0x0000,			// 0D CR 
  0x0000,			// 0E SO 
  0x0000,			// 0F SI 
  0x0000,			// 10 DLE
  0x0000,			// 11 DC1
  0x0000,			// 12 DC2
  0x0000,			// 13 DC3
  0x0000,			// 14 DC4
  0x0000,			// 15 NAK
  0x0000,			// 16 SYN
  0x0000,			// 17 ETB
  0x0000,			// 18 CAN
  0x0000,			// 19 EM 
  0x0000,			// 1A SUB
  0x0000,			// 1B ESC
  0x0000,			// 1C FS 
  0x0000,			// 1D GS 
  0x0000,			// 1E RS 
  0x0000,			// 1F US 
  0x8140,			// 20 SP 
  0x8149,			// 21  ! 
  0x8168,			// 22  " 
  0x8194,			// 23  # 
  0x8190,			// 24  $ 
  0x8193,			// 25  % 
  0x8195,			// 26  & 
  0x8166,			// 27  ' 
  0x8169,			// 28(
  0x816a,			// 29) 
  0x8196,			// 2A  * 
  0x817b,			// 2B  + 
  0x8143,			// 2C  , 
  0x817c,			// 2D  - 
  0x8144,			// 2E  . 
  0x815e,			// 2F  / 
  0x824f,			// 30  0 
  0x8250,			// 31  1 
  0x8251,			// 32  2 
  0x8252,			// 33  3 
  0x8253,			// 34  4 
  0x8254,			// 35  5 
  0x8255,			// 36  6 
  0x8256,			// 37  7 
  0x8257,			// 38  8 
  0x8258,			// 39  9 
  0x8146,			// 3A  : 
  0x8147,			// 3B  ; 
  0x8183,			// 3C  < 
  0x8181,			// 3D  = 
  0x8184,			// 3E  > 
  0x8148,			// 3F  ? 
  0x8197,			// 40  @ 
  0x8260,			// 41  A 
  0x8261,			// 42  B 
  0x8262,			// 43  C 
  0x8263,			// 44  D 
  0x8264,			// 45  E 
  0x8265,			// 46  F 
  0x8266,			// 47  G 
  0x8267,			// 48  H 
  0x8268,			// 49  I 
  0x8269,			// 4A  J 
  0x826a,			// 4B  K 
  0x826b,			// 4C  L 
  0x826c,			// 4D  M 
  0x826d,			// 4E  N 
  0x826e,			// 4F  O 
  0x826f,			// 50  P 
  0x8270,			// 51  Q 
  0x8271,			// 52  R 
  0x8272,			// 53  S 
  0x8273,			// 54  T 
  0x8274,			// 55  U 
  0x8275,			// 56  V 
  0x8276,			// 57  W 
  0x8277,			// 58  X 
  0x8278,			// 59  Y 
  0x8279,			// 5A  Z 
  0x816d,			// 5B  [ 
  0x815f,			// 5C  \ 
  0x816e,			// 5D  ] 
  0x814f,			// 5E  ^ 
  0x8151,			// 5F  _ 
  0x8165,			// 60  ` 
  0x8281,			// 61  a 
  0x8282,			// 62  b 
  0x8283,			// 63  c 
  0x8284,			// 64  d 
  0x8285,			// 65  e 
  0x8286,			// 66  f 
  0x8287,			// 67  g 
  0x8288,			// 68  h 
  0x8289,			// 69  i 
  0x828a,			// 6A  j 
  0x828b,			// 6B  k 
  0x828c,			// 6C  l 
  0x828d,			// 6D  m 
  0x828e,			// 6E  n 
  0x828f,			// 6F  o 
  0x8290,			// 70  p 
  0x8291,			// 71  q 
  0x8292,			// 72  r 
  0x8293,			// 73  s 
  0x8294,			// 74  t 
  0x8295,			// 75  u 
  0x8296,			// 76  v 
  0x8297,			// 77  w 
  0x8298,			// 78  x 
  0x8299,			// 79  y 
  0x829a,			// 7A  z 
  0x816f,			// 7B  { 
  0x8162,			// 7C  | 
  0x8170,			// 7D  } 
  0x8150,			// 7E  ~ 
  0x0000,			// 7F DEL
};

// Currently, this function is very slow.
static char* NEAR
dup_to_ascii_string(char* s)
{
  unsigned char* dest = new unsigned char[strlen(s) + 1];
  unsigned char* d = dest;
  unsigned char* u = (unsigned char*) s;
  for (;;)
  {
    int ch = *u++;
    if (ch == '\0')
    {
      *d = '\0';
      return((char *) dest);
    }
    if (iskanji(ch))
    {
      int ch2 = *u++;
      if (!iskanji2(ch))
      {
	break;
      }
      unsigned int code = (ch << 8) + ch2;
      for (ch = 0; ch != NUMBER_OF(sjis_ascii_table); ++ch)
      {
	if (sjis_ascii_table[ch] == code)
	{
	  break;
	}
      }
      if (ch == NUMBER_OF(sjis_ascii_table))
      {
	break;
      }
    }
    *d++ = ch;
  }
  delete dest;
  return(NULL);
}

static int NEAR
valid_float_string_p(char* s)
{
  int ch = *s++;
  while (ch == ' ')
  {
    ch = *s++;
  }
  switch (ch)
  {
    case '+':
    case '-':
    ch = *s++;
    break;
  }
  int num_digits = 0;
  while ('0' <= ch && ch <= '9')
  {
    ++num_digits;
    ch = *s++;
  }
  if (ch == '.')
  {
    ch = *s++;
    int n = 0;
    while ('0' <= ch && ch <= '9')
    {
      ++n;
      ch = *s++;
    }
    if (n == 0)
    {
      return(False);
    }
    num_digits += n;
  }
  if (num_digits == 0)
  {
    return(False);
  }
  switch (ch)
  {
   case 'D':
   case 'E':
   case 'd':
   case 'e':
    ch = *s++;
    switch (ch)
    {
     case '+':
     case '-':
      ch = *s++;
      break;
    }
    num_digits = 0;
    while ('0' <= ch && ch <= '9')
    {
      ++num_digits;
      ch = *s++;
    }
    if (num_digits == 0)
    {
      return(False);
    }
    break;
  }
  while (ch == ' ')
  {
    ch = *s++;
  }
  return(ch == '\0');
}

static int NEAR
string_to_float(char* s, double* float_ret)
{
  int result = False;
  double d = 0;
  char* ascii_s = dup_to_ascii_string(s);
  if (ascii_s != NULL)
  {
    if (valid_float_string_p(ascii_s))
    {
      errno = 0;
      char* foo;
      d = strtod(ascii_s, &foo);
      if (errno == 0)
      {
	result = True;
      }
      else
      {
	d = 0;
      }
    }
    delete ascii_s;
  }
  *float_ret = d;
  return(result);
}

int
string_to_int(char* s, int* i_ret)
{
  int result = False;
  int i = 0;
  char* ascii_s = dup_to_ascii_string(s);
  if (ascii_s != NULL)
  {
    result = True;
    int value = 0;
    int num_digits = 0;
    int sign = 1;
    char* as = ascii_s;
    int ch = *as++;
    while (ch == ' ')
    {
      ch = *as++;
    }
    switch (ch)
    {
     case '-':
      sign = -1;
      // fall through
      
     case '+':
      ch = *as++;
      break;
    }
    while ('0' <= ch && ch <= '9')
    {
      ++num_digits;
      value = value * 10 + (ch - '0');
      if (value < 0)
      {
	result = False;
      }
      ch = *as++;
    }
    if (num_digits == 0)
    {
      result = False;
    }
    else
    {
      while (ch == ' ')
      {
	ch = *as++;
      }
      if (ch != '\0')
      {
	result = False;
      }
    }
    delete ascii_s;
    if (result)
    {
      i = value * sign;
    }
  }
  *i_ret = i;
  return(result);
}

// Convert string to integer by MM0 sementic.  If success, returns True,
// otherwise returns False.
int
string_to_mm0(char* s, int* mm0_ret)
{
  double d;
  if (string_to_float(s, &d))
  {
    d = floor(d * 10 + 0.5);
    int mm0 = (int) d;
    if ((double) mm0 == d)
    {
      *mm0_ret = mm0;
      return(True);
    }
  }
  *mm0_ret = 0;
  return(False);
}

char* 
int_to_string(int i)
{
  char* s = new char[10];
  wsprintf(s, "%d", i);
  return(s);
}

// Return new string.
char* 
mm0_to_string(int mm0)
{
  char* result = new char[10];
  char* s = result;
  // -(-32768) == -32768 on 16 bit integer method.
  long a = mm0;
  if (mm0 < 0)
  {
    *s++ = '-';
    a = -a;
  }
  wsprintf(s, "%ld.%d", a / 10, (int) (a % 10));
  return(result);
}

// ------------------------------------------------------------
// Windows related

#define STRING_LENGTH 256

int
get_item_int(HWND dialog, int item_id, int* int_ret)
{
  char buffer[STRING_LENGTH + 1];
  ::GetDlgItemText(dialog, item_id, buffer, STRING_LENGTH);
  return(string_to_int(buffer, int_ret));
}

void
set_item_int(HWND dialog, int item_id, int i)
{
  char* s = int_to_string(i);
  ::SetDlgItemText(dialog, item_id, s);
  delete s;
}

int
get_item_mm0(HWND dialog, int item_id, int* mm0_ret)
{
  char buffer[STRING_LENGTH + 1];
  ::GetDlgItemText(dialog, item_id, buffer, STRING_LENGTH);
  return(string_to_mm0(buffer, mm0_ret));
}

void
set_item_mm0(HWND dialog, int item_id, int mm0)
{
  char* s = mm0_to_string(mm0);
  ::SetDlgItemText(dialog, item_id, s);
  delete s;
}

int
get_item_int_or_mm0(HWND dialog, int item_id, int* i_ret, int mm0)
{
  return(mm0 ? get_item_mm0(dialog, item_id, i_ret)
	  : get_item_int(dialog, item_id, i_ret));
}

void
set_item_int_or_mm0(HWND dialog, int item_id, int i, int mm0)
{
  if (mm0)
  {
    set_item_mm0(dialog, item_id, i);
  }
  else
  {
    set_item_int(dialog, item_id, i);
  }
}

int
get_item_button_unit(HWND dialog, int item_id, int* i_ret)
{
  char buffer[STRING_LENGTH + 1];
  ::GetDlgItemText(dialog, item_id, buffer, STRING_LENGTH);

  double d;
  if (string_to_float(buffer, &d))
  {
    d = floor(d * 4 + 0.5);
    int i = (int) d;
    if ((double) i == d)
    {
      *i_ret = i;
      return(True);
    }
  }
  *i_ret = 0;
  return(False);
}

void
set_item_button_unit(HWND dialog, int item_id, int i)
{
  char buffer[STRING_LENGTH + 1];
  wsprintf(buffer, "%d.%02d", i / 4, 25 * (i % 4));
  ::SetDlgItemText(dialog, item_id, buffer);
}
