// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: moveline.cpp,v 3.5 2000/05/13 16:29:03 kudou Exp $
// class EditFrame
// t[GfB^̐ړҏW[h

#include "pword.h"
#include "editfram.h"
#include "docconte.h"
#include "document.h"
#include "docwindo.h"
#include "fission.h"
#include "frameown.h"
#include "layoutin.h"
#include "layoutte.h"
#include "linesele.h"
#include "mcursor.h"
#include "pagesize.h"
#include "panel.h"
#include "pmenus.h"
#include "pwordpre.h"
#include "table.h"
#include "tablepnl.h"
#include "vdisplay.h"
#include "xstr.h"

// set grab cursor
void 
EditFrame::SetGrabCursor(Fission* f)
{
  if (f->GetDir() == Fission::Vertical) 
  {
    MouseCursor::GrabH();
  }
  else 
  {          // Fission::Horizontal
    MouseCursor::Grab();
  }
}

inline Iunit 
abs_x(Iunit i)
{
  return(i > 0) ? i : - i;
}

enum table_op 
{
  resize,
  start_scale,
  end_scale,
};

static table_op 
check_table_operation(Vector& pos, 
		       Vector& start, 
		       Vector& end,
		       Iunit err)
{
  const Iunit diag_err_factor = 2;
  err *= diag_err_factor;
  err *= err;
  Iunit s_diff_x = abs_x(start.x - pos.x);
  Iunit s_diff_y = abs_x(start.y - pos.y);
  Iunit e_diff_x = abs_x(end.x - pos.x);
  Iunit e_diff_y = abs_x(end.y - pos.y);
  udword s_diff = (udword)s_diff_x * (udword)s_diff_x 
  + (udword)s_diff_y * (udword)s_diff_y;
  udword e_diff = (udword)e_diff_x * (udword)e_diff_x 
  + (udword)e_diff_y * (udword)e_diff_y;
  if (s_diff <= (udword) err)
  {
    // scale table
    return start_scale;
  }
  else if (e_diff <= (udword) err)
  {
    // scale table
    return end_scale;
  }
  else 
  {
    // resize
    return resize;
  }
}

// set grab cursor for idle
void 
EditFrame::SetGrabCursor(Fission* f, VectW& mpos)
{
  // table resize check
  if (GetEditLT()->IsTable() &&
      IsRimFission(f)) 
  { 
    // this fission is table rim.
    Vector pos = WtoIv(mpos);
    Vector start = f->GetStartPoint();
    Vector end = f->GetEndPoint();
    table_op op = check_table_operation(pos, start, end, 
					 GetMouseErrorLength());
    if (op == start_scale) 
    {
      // scale table
      MouseCursor::GrabDiag();
      return;
    }
    else if (op == end_scale) 
    {
      // scale table
      MouseCursor::GrabDiag();
      return;
    }
  }
  if (f->GetDir() == Fission::Vertical) 
  {
    MouseCursor::GrabH();
  }
  else 
  {          // Fission::Horizontal
    MouseCursor::Grab();
  }
}

// find move limit
void 
EditFrame::FindMoveLimit(Fission* f, 
			  Iunit& l_move_lim, Iunit& u_move_lim,
			  Iunit& l_lim, Iunit& u_lim)
{
  // set move limit
  GetEditFF()->FindMoveLimit(f, l_move_lim, u_move_lim);
  u_lim = u_move_lim;
  l_lim = l_move_lim;
  
  // check margin line limit
  if (IsMarginFission(f)) 
  {
    Fission* top;
    Fission* bottom;
    Fission* left;
    Fission* right;
    Iunit margin_lim = PageSize::GetMinRegularSize();
    GetMarginFission(&top, &bottom, &left, &right);
    if (f == top) 
    {
      if (u_move_lim == bottom->GetPoint()) 
      {
	u_move_lim -= margin_lim;
      }
    }
    else if (f == bottom) 
    {
      if (l_move_lim == top->GetPoint()) 
      {
	l_move_lim += margin_lim;
      }
    }
    else if (f == left) 
    {
      if (u_move_lim == right->GetPoint()) 
      {
	u_move_lim -= margin_lim;
      }
    }
    else if (f == right) 
    {
      if (l_move_lim == left->GetPoint()) 
      {
	l_move_lim += margin_lim;
      }
    }
  }
}

// move line lock layout
LayoutInstance* 
EditFrame::MoveLineLockLayout(VectW& v)
{
  LayoutInstance* li = LockLayout(v);
  if (li == 0) 
  {
    Iunit i_err = GetMouseErrorLength();
    Dunit w_err = window->ScaleDunitX(i_err);
    for (uword i = 0; i < 4; i++) 
    {
      VectW scan = v;
      switch (i) 
      {
       case 0:
	scan.y -= w_err;
	break;
	
       case 1:
	scan.y += w_err;
	break;
	
       case 2:
	scan.x -= w_err;
	break;
	
       case 3:
	scan.x += w_err;
	break;
      }
      if ((li = LockLayout(scan)) != 0) 
      {
	if (li->GetLayoutTemplate()->IsRegular()) 
	{
	  li = LockZeroPageLayout(li);
	}
	return li;
      }
    }
  }
  else if (GetEditLT()->IsRegular()) 
  {
    Vector pnt = WtoIv(v);
    FissionFrame::SetNearFissionError(GetMouseErrorLength());
    Fission* f = GetEditFF()->GetNearFission(pnt);
    if ((f != 0) &&
	((GetEditFF()->GetTop() == f) ||
	 (GetEditFF()->GetBottom() == f) ||
	 (GetEditFF()->GetLeft() == f) ||
	 (GetEditFF()->GetRight() == f))) 
    {
      li = LockZeroPageLayout(li);
    }
  }
  return li;
}

// idle

//void NEAR EditFrame::MoveLine_Idle_LDWN(LONG lParam);

void NEAR
EditFrame::MoveLine_Idle_MV(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((MoveLineLockLayout(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    MouseCursor::GrabOff();
    ClearPosition();
  }
  else 
  {
    SetGrabCursor(f, mpos);
    if (GetEditLT()->IsTable() && IsRimFission(f)) 
    {
      // table rim
      ShowResizeTableSize();
    }
    else 
    {
      // normal line
      Iunit lower, upper, scl_l_lim, scl_u_lim;
      FindMoveLimit(f, lower, upper, scl_l_lim, scl_u_lim);
      ShowMoveLinePos(f, f->GetPoint(), scl_l_lim, scl_u_lim);
    }
  }
}

//void NEAR EditFrame::MoveLine_Idle_LUP(LPARAM_T lParam);

// line select
void NEAR
EditFrame::MoveLine_SelLine_LDWN(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((FindLayoutW(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  move.StartSelLine(f, GetEditLI());
}

void NEAR
EditFrame::MoveLine_SelLine_MV(LPARAM_T lParam)
{
  MoveLine_Idle_MV(lParam);
}

void NEAR
EditFrame::MoveLine_SelLine_LUP(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((FindLayoutW(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0) ||
      (f != move.GetSelectedFission())) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  
  // find prev regiser line
  RedisplayMoveLine();		// vanish
  LineSelection* pre = FindLineSelection(f);
  if (pre != 0) 
  {
    // cancel selected line
    DeleteLineSelection(f);
  }
  else 
  {
    // add selected line
    AddLineSelection(f);
  }
  move.EndSelection();
}

// select line segment
void NEAR
EditFrame::MoveLine_SelSeg_LDWN(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((FindLayoutW(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  CrossPoint* start;
  CrossPoint* end;
  FindSegmentW(f, mpos, start, end);
  move.StartSelSegLine(f, start, end, GetEditLI());
}

void NEAR
EditFrame::MoveLine_SelSeg_MV(LPARAM_T lParam)
{
  MoveLine_Idle_MV(lParam);
}

void NEAR
EditFrame::MoveLine_SelSeg_LUP(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  CrossPoint* start = 0;
  CrossPoint* end = 0;
  if ((FindLayoutW(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0) ||
      (f != move.GetSelectedFission()) ||
      (FindSegmentW(f, mpos, start, end), 
       start != move.GetSegStart()) ||
      (end != move.GetSegEnd())) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  
  RedisplayMoveLine();		// vanish
  LineSelection* ls = FindLineSelection(f, start, end);
  if (ls != 0) 
  {
    // cancel selected line
    DeleteLineSelection(ls);
  }
  else 
  {
    // add selected line
    AddLineSelection(f, start, end);
  }
  move.EndSelection();
}

// move line
void NEAR
EditFrame::MoveLine_Move_LDWN(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((MoveLineLockLayout(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  ClearEffective();
  // table resize check
  
  if (GetEditLT()->IsTable() &&
      IsRimFission(f)) 
  { 
    // this fission is table rim.
    Vector pos = WtoIv(mpos);
    Vector start = f->GetStartPoint();
    Vector end = f->GetEndPoint();
    table_op op = check_table_operation(pos, start, end, 
					 GetMouseErrorLength());
    switch (op) 
    {
     case start_scale:
      // scale table
      move.StartScaleTable(f->GetStartCrossPoint(), start);
      SetMouseXOffset(mpos.x - ItoWx(start.x));
      SetMouseYOffset(mpos.y - ItoWy(start.y));
      ShowResizeTableSize(pos);
      MouseCursor::GrabDiag();
      break;
      
     case end_scale:
      // scale table
      move.StartScaleTable(f->GetEndCrossPoint(), end);
      SetMouseXOffset(mpos.x - ItoWx(end.x));
      SetMouseYOffset(mpos.y - ItoWy(end.y));
      ShowResizeTableSize(pos);
      MouseCursor::GrabDiag();
      break;
      
     case resize:
     default:
      // resize one direction table
      Iunit pos;
      if (f->GetDir() == Fission::Vertical) 
      {
	pos = ((VFission*)f)->X();
	SetMouseXOffset(mpos.x - ItoWx(pos));
      }
      else 
      {
	pos = ((HFission*)f)->Y();
	SetMouseYOffset(mpos.y - ItoWy(pos));
      }
      move.StartScaleOneDirTable(f, pos);
      ShowResizeTableSize(pos);
      break;
    }
  }
  else 
  {
    // normal line move
    Iunit lower, upper, scl_l_lim, scl_u_lim;
    FindMoveLimit(f, lower, upper, scl_l_lim, scl_u_lim);
    Iunit pos;
    if (f->GetDir() == Fission::Vertical) 
    {
      pos = ((VFission*)f)->X();
      SetMouseXOffset(mpos.x - ItoWx(pos));
    }
    else 
    {
      pos = ((HFission*)f)->Y();
      SetMouseYOffset(mpos.y - ItoWy(pos));
    }
    move.StartMoveLine(f, pos, lower, upper, scl_l_lim, scl_u_lim);
    ShowMoveLinePos();
  }
  RedisplayMoveLine();
}

// move alignment
void NEAR
EditFrame::MoveAlign(Vector& pnt, VectW& mpos)
{
  // It's so called 'oyayubi' function.
  Fission* f = 0;
  FissionFrame::SetNearFissionError(GetMouseErrorLength() * 2);
  if ((FindLayoutW(mpos) == GetEditLI()) &&
      ((f = FindMoveFissionW(mpos)) != 0) &&
      (f != move.GetMoveFission()) &&
      (f->GetDir() == move.GetMoveFission()->GetDir())) 
  {
    // find align fission!!
    if (f->GetDir() == Fission::Vertical) 
    {
      pnt.x = f->GetPoint();
      // 'oyayubi' cursor
      MouseCursor::GrabHA();
    }
    else 
    {
      pnt.y = f->GetPoint();
      // 'oyayubi' cursor
      MouseCursor::GrabA();
    }
  }
  else 
  {
    SetGrabCursor(move.GetMoveFission());
  }
  FissionFrame::SetNearFissionError(GetMouseErrorLength());
}

void NEAR
EditFrame::MoveLine_Move_MV(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  MoveAlign(pos, mpos);
  Iunit old_pos = move.GetMovePos();
  Iunit new_pos = move.GetMovePos();
  if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
  {
    if (pos.x < move.GetLowerLimit()) 
    {
      new_pos = move.GetLowerLimit();
    }
    else if (pos.x > move.GetUpperLimit()) 
    {
      new_pos = move.GetUpperLimit();
    }
    else 
    {
      new_pos = pos.x;
    }
  }
  else 
  {   // Fission::Horizontal
    if (pos.y < move.GetLowerLimit()) 
    {
      new_pos = move.GetLowerLimit();
    }
    else if (pos.y > move.GetUpperLimit()) 
    {
      new_pos = move.GetUpperLimit();
    }
    else 
    {
      new_pos = pos.y;
    }
  }
  if (old_pos != new_pos) 
  {
    RedisplayMoveLine();		// vanish
    move.ChangeLinePos(new_pos);
    RedisplayMoveLine();		// draw
    ShowMoveLinePos();
    SetEffective();
  }
}

void NEAR
EditFrame::MoveLine_Move_LUP(LPARAM_T lParam)
{
  if (!move.IsFixed() || !IsEffective()) 
  {
    CancelMoveLine();
    return;
  }
  RedisplayMoveLine();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  MoveAlign(pos, mpos);
  if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
  {
    if (pos.x < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (pos.x > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(pos.x);
    }
  }
  else 
  {   // Fission::Horizontal
    if (pos.y < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (pos.y > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(pos.y);
    }
  }
  GetEditFF()->Move(move.GetMoveFission(), move.GetMovePos());
  ShowMoveLinePos();
  if (IsMarginFission(move.GetMoveFission())) 
  {
    doc->GetDocumentContent()
    ->GetPageSize()
    ->ChangeMargin();
  }
  move.Reset();
  ClearMouseOffset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

// move line segment
void NEAR
EditFrame::MoveLine_SegMove_LDWN(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((MoveLineLockLayout(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
#if 0
  if (GetEditLT()->IsTable() && IsRimFission(f)) 
  {
    //
    // table stretch scaling mode.
    //
    Vector pos = WtoIv(mpos);
    Vector start = f->GetStartPoint();
    Vector end = f->GetEndPoint();
    table_op op = check_table_operation(pos, start, end, 
					 GetMouseErrorLength());
    switch (op) 
    {
     case start_scale:
      // stretch table
      move.StartStretchTable(f->GetStartCrossPoint(), start);
      SetMouseXOffset(mpos.x - ItoWx(start.x));
      SetMouseYOffset(mpos.y - ItoWy(start.y));
      ShowResizeTableSize(pos);
      MouseCursor::GrabDiag();
      break;
     case end_scale:
      // stretch table
      move.StartStretchTable(f->GetEndCrossPoint(), end);
      SetMouseXOffset(mpos.x - ItoWx(end.x));
      SetMouseYOffset(mpos.y - ItoWy(end.y));
      ShowResizeTableSize(pos);
      MouseCursor::GrabDiag();
      break;
     case resize:
     default:
      // stretch one direction table
      Iunit pos;
      if (f->GetDir() == Fission::Vertical) 
      {
	pos = ((VFission*)f)->X();
	SetMouseXOffset(mpos.x - ItoWx(pos));
      }
      else 
      {
	pos = ((HFission*)f)->Y();
	SetMouseYOffset(mpos.y - ItoWy(pos));
      }
      move.StartStretchOneDirTable(f, pos);
      ShowResizeTableSize(pos);
      break;
    }
    RedisplayMoveLine();
    return;
  }
#endif
  
  CrossPoint* start;
  CrossPoint* end;
  FindSegmentW(f, mpos, start, end);
  if (CanCutSegment(f, start, end) == False) 
  {
    PWordPresentation::StatusOut(S_CantMove);
    CancelMoveLine();
    return;
  }
  Iunit lower, upper, scl_l_lim, scl_u_lim;
  FindMoveLimit(f, lower, upper, scl_l_lim, scl_u_lim);
  Iunit pos;
  if (f->GetDir() == Fission::Vertical) 
  {
    pos = ((VFission*)f)->X();
    SetMouseXOffset(mpos.x - ItoWx(pos));
  }
  else 
  {
    pos = ((HFission*)f)->Y();
    SetMouseYOffset(mpos.y - ItoWy(pos));
  }
  move.StartSegMove(f, start, end, pos, 
		     lower, upper, scl_l_lim, scl_u_lim);
  ClearEffective();
  RedisplayMoveLine();
  ShowMoveLinePos();
}

void NEAR
EditFrame::MoveLine_SegMove_MV(LPARAM_T lParam)
{
  MoveLine_Move_MV(lParam);
}

void NEAR
EditFrame::MoveLine_SegMove_LUP(LPARAM_T lParam)
{
  if (!move.IsFixed() || !IsEffective()) 
  {
    CancelMoveLine();
    return;
  }
  RedisplayMoveLine();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  MoveAlign(pos, mpos);
  if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
  {
    if (pos.x < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (pos.x > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(pos.x);
    }
    GetEditFF()->SegMove(move.GetMoveFission(), 
			   move.GetSegStart()->GetHFission(),
			   move.GetSegEnd()->GetHFission(), 
			   move.GetMovePos());
    
  }
  else 
  {   // Fission::Horizontal
    if (pos.y < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (pos.y > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(pos.y);
    }
    GetEditFF()->SegMove(move.GetMoveFission(), 
			   move.GetSegStart()->GetVFission(),
			   move.GetSegEnd()->GetVFission(), 
			   move.GetMovePos());
  }
  ShowMoveLinePos();
  move.Reset();
  ClearMouseOffset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

// slale one dir table
//void NEAR EditFrame::MoveLine_ScaleOneDirTable_LDWN(LPARAM_T lParam);

void NEAR
EditFrame::MoveLine_ScaleOneDirTable_MV(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  Iunit old_pos = move.GetMovePos();
  Iunit new_pos = move.GetMovePos();
  if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
  {
    new_pos = pos.x;
  }
  else 
  {
    new_pos = pos.y;
  }
  if (new_pos != old_pos) 
  {
    RedisplayMoveLine();		// vanish
    move.ChangeLinePos(new_pos);
    ShowResizeTableSize(new_pos);
    RedisplayMoveLine();		// draw
    SetEffective();
  }
}

void NEAR
EditFrame::MoveLine_ScaleOneDirTable_LUP(LPARAM_T lParam)
{
  if (!move.IsFixed() && !IsEffective()) 
  {
    CancelMoveLine();
    return;
  }
  RedisplayMoveLine();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  Iunit new_pos = 0;
  if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
  {
    new_pos = pos.x;
  }
  else 
  {
    new_pos = pos.y;
  }
  
  // make new size
  Fission* f = move.GetMoveFission();
  Fission* top = GetEditFF()->GetTop();
  Fission* bottom = GetEditFF()->GetBottom();
  Fission* left = GetEditFF()->GetLeft();
  Fission* right = GetEditFF()->GetRight();
  Vector new_size = GetEditFF()->GetSize();
  if (f->GetDir() == Fission::Vertical) 
  {
    // change x direction
    if (f == left) 
    {
      new_size.x = right->GetPoint() - new_pos;
    }
    else if (f == right) 
    {
      new_size.x = new_pos;
    }
    if (new_size.x < 0) 
    {
      new_size.x = - new_size.x;
    }
  }
  else 
  {
    // change y direction
    if (f == top) 
    {
      new_size.y = bottom->GetPoint() - new_pos;
    }
    else if (f == bottom) 
    {
      new_size.y = new_pos;
    }
    if (new_size.y < 0) 
    {
      new_size.y = - new_size.y;
    }
  }
  // update table
  if ((new_size.x < TablePanel::GetMinTableSize()) || 
      (new_size.y < TablePanel::GetMinTableSize()) ||
      (new_size.x > TablePanel::GetMaxTableSize()) ||
      (new_size.y > TablePanel::GetMaxTableSize())) 
  {
    CancelMoveLine();
    return;
  }
  ClearMouseOffset();
  Table* tbl = (Table*)GetEditLI()->GetPageMap();
  if (move.GetMoveLineMode() == EMMoveLine::ScaleOneDirTable) 
  {
    move.Reset();
    tbl->GetPanel()->ChangeSize(new_size.x, new_size.y);
  }
  else 
  {
    move.Reset();
    Vector org_size = GetEditFF()->GetSize();
    if (f == top) 
    {
      tbl->GetPanel()
      ->StretchSize(new_size.y - org_size.y, 0, 0, 0);
    }
    else if (f == bottom) 
    {
      tbl->GetPanel()
      ->StretchSize(0, new_size.y - org_size.y, 0, 0);
    }
    else if (f == left) 
    {
      tbl->GetPanel()
      ->StretchSize(0, 0, new_size.x - org_size.x, 0);
    }
    else if (f == right) 
    {
      tbl->GetPanel()
      ->StretchSize(0, 0, 0, new_size.x - org_size.x);
    }
  }
  UnforceTouchCaret();
  ClearMouseOffset();
  SetDirty();
}

// stretch one dir table
//void NEAR EditFrame::MoveLine_StretchOneDirTable_LDWN(LPARAM_T lParam);

void NEAR
EditFrame::MoveLine_StretchOneDirTable_MV(LPARAM_T lParam)
{
  MoveLine_ScaleOneDirTable_MV(lParam);
}

void NEAR
EditFrame::MoveLine_StretchOneDirTable_LUP(LPARAM_T lParam)
{
  MoveLine_ScaleOneDirTable_LUP(lParam);
}

// scale table
//void NEAR EditFrame::MoveLine_ScaleTable_LDWN(LPARAM_T lParam);

void NEAR
EditFrame::MoveLine_ScaleTable_MV(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  Vector old = move.GetScalePos();
  if ((pos.x != old.x) ||
      (pos.y != old.y)) 
  {
    RedisplayMoveLine();		// vanish
    move.MoveScalePos(pos);
    ShowResizeTableSize(pos);
    RedisplayMoveLine();		// draw
    SetEffective();
  }
}

void NEAR
EditFrame::MoveLine_ScaleTable_LUP(LPARAM_T lParam)
{
  if (!move.IsFixed() || !IsEffective()) 
  {
    CancelMoveLine();
    return;
  }
  RedisplayMoveLine();		// vanish
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector pos = WtoIv(mpos);
  CrossPoint* cp = move.GetScaleCorner();
  Fission* top = GetEditFF()->GetTop();
  Fission* bottom = GetEditFF()->GetBottom();
  Vector new_size = bottom->GetEndPoint();
  if (cp == top->GetStartCrossPoint()) 
  {
    new_size -= pos;
  }
  else if (cp == top->GetEndCrossPoint()) 
  {
    new_size.x = pos.x;
    new_size.y -= pos.y;
  }
  else if (cp == bottom->GetStartCrossPoint()) 
  {
    new_size.x -= pos.x;
    new_size.y = pos.y;
  }
  else if (cp == bottom->GetEndCrossPoint()) 
  {
    new_size = pos;
  }
  if (new_size.x < 0) 
  {
    new_size.x = - new_size.x;
  }
  if (new_size.y < 0) 
  {
    new_size.y = - new_size.y;
  }
  
  // update table
  if ((new_size.x < TablePanel::GetMinTableSize()) || 
      (new_size.y < TablePanel::GetMinTableSize()) ||
      (new_size.x > TablePanel::GetMaxTableSize()) ||
      (new_size.y > TablePanel::GetMaxTableSize())) 
  {
    CancelMoveLine();
    return;
  }
  ClearMouseOffset();
  Table* tbl = (Table*)GetEditLI()->GetPageMap();
  if (move.GetMoveLineMode() == EMMoveLine::ScaleTable) 
  {
    move.Reset();
    tbl->GetPanel()->ChangeSize(new_size.x, new_size.y);
  }
  else 
  {
    move.Reset();
    Vector org_size = bottom->GetEndPoint();
    if (cp == top->GetStartCrossPoint()) 
    {
      tbl->GetPanel()
      ->StretchSize(new_size.y - org_size.y, 0,
		     new_size.x - org_size.x, 0);
    }
    else if (cp == top->GetEndCrossPoint()) 
    {
      tbl->GetPanel()
      ->StretchSize(new_size.y - org_size.y, 0,
		     0, new_size.x - org_size.x);
    }
    else if (cp == bottom->GetStartCrossPoint()) 
    {
      tbl->GetPanel()
      ->StretchSize(0, new_size.y - org_size.y,
		     new_size.x - org_size.x, 0);
    }
    else if (cp == bottom->GetEndCrossPoint()) 
    {
      tbl->GetPanel()
      ->StretchSize(0, new_size.y - org_size.y,
		     0, new_size.x - org_size.x);
    }
  }
  UnforceTouchCaret();
  ClearMouseOffset();
  SetDirty();
}

// stretch table
//void NEAR EditFrame::MoveLine_StretchTable_LDWN(LPARAM_T lParam);

void NEAR
EditFrame::MoveLine_StretchTable_MV(LPARAM_T lParam)
{
  MoveLine_ScaleTable_MV(lParam);
}

void NEAR
EditFrame::MoveLine_StretchTable_LUP(LPARAM_T lParam)
{
  MoveLine_ScaleTable_LUP(lParam);
}

// move line and table expansion
void NEAR
EditFrame::MoveLine_MoveExpansion_LDWN(LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  Fission* f = 0;
  if ((MoveLineLockLayout(mpos) == 0) ||
      ((f = FindMoveFissionW(mpos)) == 0)) 
  {
    CancelMoveLine();
    return;
  }
  else 
  {
    SetGrabCursor(f);
  }
  ClearEffective();
  
  // check table
  if (GetEditLT()->IsTable()) 
  {
    if (IsRimFission(f)) 
    {
      //
      // stretch table
      //
      Vector pos = WtoIv(mpos);
      Vector start = f->GetStartPoint();
      Vector end = f->GetEndPoint();
      table_op op = check_table_operation(pos, start, end, 
					   GetMouseErrorLength());
      switch (op) 
      {
       case start_scale:
	// stretch table
	move.StartStretchTable(f->GetStartCrossPoint(), start);
	SetMouseXOffset(mpos.x - ItoWx(start.x));
	SetMouseYOffset(mpos.y - ItoWy(start.y));
	ShowResizeTableSize(pos);
	MouseCursor::GrabDiag();
	break;
       case end_scale:
	// stretch table
	move.StartStretchTable(f->GetEndCrossPoint(), end);
	SetMouseXOffset(mpos.x - ItoWx(end.x));
	SetMouseYOffset(mpos.y - ItoWy(end.y));
	ShowResizeTableSize(pos);
	MouseCursor::GrabDiag();
	break;
       case resize:
       default:
	// stretch one direction table
	Iunit pos;
	if (f->GetDir() == Fission::Vertical) 
	{
	  pos = ((VFission*)f)->X();
	  SetMouseXOffset(mpos.x - ItoWx(pos));
	}
	else 
	{
	  pos = ((HFission*)f)->Y();
	  SetMouseYOffset(mpos.y - ItoWy(pos));
	}
	move.StartStretchOneDirTable(f, pos);
	ShowResizeTableSize(pos);
	break;
      }
      RedisplayMoveLine();
      return;
    }
    else if (IsRimFission(f->GetStartFission()) &&
	     IsRimFission(f->GetEndFission())) 
    {
      //
      // move expansion
      //
      Iunit lower, upper, scl_l_lim, scl_u_lim;
      FindMoveLimit(f, lower, upper, scl_l_lim, scl_u_lim);
      Iunit pos;
      if (f->GetDir() == Fission::Vertical) 
      {
	pos = ((VFission*)f)->X();
	SetMouseXOffset(mpos.x - ItoWx(pos));
      }
      else 
      {
	pos = ((HFission*)f)->Y();
	SetMouseYOffset(mpos.y - ItoWy(pos));
      }
      move.StartMoveExpansion(f, pos, lower, 
			       TablePanel::GetMaxTableSize(), 
			       scl_l_lim, scl_u_lim);
      ShowMoveLinePos();
      RedisplayMoveLine();
      return;
    }
  }
  CancelMoveLine();
  StatusOut("can not Move Line and Expand Table");
}

void NEAR
EditFrame::MoveLine_MoveExpansion_MV(LPARAM_T lParam)
{
  MoveLine_Move_MV(lParam);
}

void NEAR
EditFrame::MoveLine_MoveExpansion_LUP(LPARAM_T lParam)
{
  if (!move.IsFixed() || !IsEffective()) 
  {
    CancelMoveLine();
    return;
  }
  RedisplayMoveLine();		// vanish
  Fission* f = move.GetMoveFission();
  Iunit pos = f->GetPoint();
  bool vert_flag = (f->GetDir() == Fission::Vertical);
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  AdaptOffset(mpos);
  Vector m_pos = WtoIv(mpos);
  MoveAlign(m_pos, mpos);
  if (vert_flag) 
  {
    if (m_pos.x < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (m_pos.x > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(m_pos.x);
    }
  }
  else 
  {   // Fission::Horizontal
    if (m_pos.y < move.GetLowerLimit()) 
    {
      move.ChangeLinePos(move.GetLowerLimit());
    }
    else if (m_pos.y > move.GetUpperLimit()) 
    {
      move.ChangeLinePos(move.GetUpperLimit());
    }
    else 
    {
      move.ChangeLinePos(m_pos.y);
    }
  }
  ShowMoveLinePos();
  Vector org_size = GetEditFF()->GetSize();
  Iunit new_pos = move.GetMovePos();
  Table* tbl = (Table*)GetEditLI()->GetPageMap();
  Vector new_size = org_size;
  if (vert_flag) 
  {
    new_size.x += new_pos - pos;
    if (new_size.x < TablePanel::GetMinTableSize()) 
    {
      new_size.x = TablePanel::GetMinTableSize();
    }
    else if (new_size.x > TablePanel::GetMaxTableSize()) 
    {
      new_size.x = TablePanel::GetMaxTableSize();
    }
    tbl->GetPanel()
    ->StretchSize(0, 0, 0, new_size.x - org_size.x);
    GetEditFF()->ShiftXPosition(pos, new_pos - pos);
  }
  else 
  {
    new_size.y += new_pos - pos;
    if (new_size.y < TablePanel::GetMinTableSize()) 
    {
      new_size.y = TablePanel::GetMinTableSize();
    }
    else if (new_size.y > TablePanel::GetMaxTableSize()) 
    {
      new_size.y = TablePanel::GetMaxTableSize();
    }
    tbl->GetPanel()
    ->StretchSize(0, new_size.y - org_size.y, 0, 0);
    GetEditFF()->ShiftYPosition(pos, new_pos - pos);
  }
  move.Reset();
  ClearMouseOffset();
  UnforceTouchCaret();
  RedrawWindows();
  SetDirty();
}

// Shift  Ctrl   Alt    Action
// ___________________________________________________________
//                      Moveline and Scale Table
//               ---    Stretch Table and Move Expansion
//  ---                 Move Line Segment, alignment
//        ---           Add Selection
//  ---   ---           Add Segment Selection
// ___________________________________________________________

// move line window proc
void
EditFrame::WndProcMoveLine(DocumentWindow* window, 
			    MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    {
      //
      // fix move line mode
      //
      EMMoveLine::MoveLineMode mode = 
      (wParam & MK_SHIFT) ? 
      ((wParam & MK_CONTROL) ? 
       EMMoveLine::SelSeg :    // Shift + Ctrl + L : select line segment
       EMMoveLine::SegMove) :  //        Shift + L : move line segment
      ((wParam & MK_CONTROL) ? 
       EMMoveLine::SelLine :   //         Ctrl + L : select line
       EMMoveLine::Move);      //                L : move line
      
      if (move.GetMoveLineMode() != EMMoveLine::Idle && 
	  ((mode == EMMoveLine::Move) ||
	   (mode == EMMoveLine::SegMove))) 
      {
	move.SetMoveLineMode(EMMoveLine::SelLine);
	RedisplayMoveLine();		// clear
	ClearLineSelection();
      }
      
      move.SetMoveLineMode(mode);
      ClearMouseOffset();
      
      // ALT Key test
      if (GetAsyncKeyState(VK_MENU) & 0xf000) 
      {
//	 MessageBeep(0);
	move.SetMoveLineMode(EMMoveLine::MoveExpansion);
      }
      
      switch (move.GetMoveLineMode()) 
      {
       case EMMoveLine::Move:
	MoveLine_Move_LDWN(lParam);
	break;
       case EMMoveLine::SegMove:
	MoveLine_SegMove_LDWN(lParam);
	break;
       case EMMoveLine::SelLine:
	MoveLine_SelLine_LDWN(lParam);
	break;
       case EMMoveLine::SelSeg:
	MoveLine_SelSeg_LDWN(lParam);
	break;
       case EMMoveLine::MoveExpansion:
	MoveLine_MoveExpansion_LDWN(lParam);
	break;
      }
    }
    break;
    
   case WM_MOUSEMOVE:
    switch (move.GetMoveLineMode()) 
    {
     case EMMoveLine::Idle:
      MoveLine_Idle_MV(lParam);
      break;
     case EMMoveLine::SelLine:
      MoveLine_SelLine_MV(lParam);
      break;
     case EMMoveLine::SelSeg:
      MoveLine_SelSeg_MV(lParam);
      break;
     case EMMoveLine::Move:
      MoveLine_Move_MV(lParam);
      break;
     case EMMoveLine::SegMove:
      MoveLine_SegMove_MV(lParam);
      break;
     case EMMoveLine::ScaleOneDirTable:
      MoveLine_ScaleOneDirTable_MV(lParam);
      break;
     case EMMoveLine::StretchOneDirTable:
      MoveLine_StretchOneDirTable_MV(lParam);
      break;
     case EMMoveLine::ScaleTable:
      MoveLine_ScaleTable_MV(lParam);
      break;
     case EMMoveLine::StretchTable:
      MoveLine_StretchTable_MV(lParam);
      break;
     case EMMoveLine::MoveExpansion:
      MoveLine_MoveExpansion_MV(lParam);
      break;
    };
    break;
    
   case WM_LBUTTONUP:
    switch (move.GetMoveLineMode()) 
    {
     case EMMoveLine::Move:
      MoveLine_Move_LUP(lParam);
      break;
     case EMMoveLine::SegMove:
      MoveLine_SegMove_LUP(lParam);
      break;
     case EMMoveLine::SelLine:
      MoveLine_SelLine_LUP(lParam);
      break;
     case EMMoveLine::SelSeg:
      MoveLine_SelSeg_LUP(lParam);
      break;
     case EMMoveLine::ScaleOneDirTable:
      MoveLine_ScaleOneDirTable_LUP(lParam);
      break;
     case EMMoveLine::StretchOneDirTable:
      MoveLine_StretchOneDirTable_LUP(lParam);
      break;
     case EMMoveLine::ScaleTable:
      MoveLine_ScaleTable_LUP(lParam);
      break;
     case EMMoveLine::StretchTable:
      MoveLine_StretchTable_LUP(lParam);
      break;
     case EMMoveLine::MoveExpansion:
      MoveLine_MoveExpansion_LUP(lParam);
      break;
    }
    break;
    
   case WM_RBUTTONDOWN:
    CancelMoveLine(False);
    break;
  }
}

void 
EditFrame::CancelMoveLine(bool beep)
{
  switch (move.GetMoveLineMode()) 
  {
   case EMMoveLine::Idle:
   case EMMoveLine::SelLine:
   case EMMoveLine::SelSeg:
    break;
   case EMMoveLine::Move:
   case EMMoveLine::SegMove:
   case EMMoveLine::ScaleOneDirTable:
   case EMMoveLine::ScaleTable:
   case EMMoveLine::StretchTable:
   case EMMoveLine::StretchOneDirTable:
   case EMMoveLine::MoveExpansion:
    if (move.IsFixed()) 
    {
      RedisplayMoveLine();		// vanish
    }
    break;
  }
  MouseCursor::GrabOff();
  ClearPosition();
  move.Reset();
  ClearMouseOffset();
  if (beep) 
  {
    ::MessageBeep(0);
  }
}

// display move line
void 
EditFrame::RedisplayMoveLine()
{
  HWND hWnd = window->GetHandle();
  HDC hDC = GetDC(hWnd);
  RedisplayMoveLine(hDC);
  ReleaseDC(hWnd, hDC);
}

void 
EditFrame::RedisplayMoveLine(VDisplay* vdsp)
{
  RedisplayMoveLine(vdsp->GetDC());
}

void 
EditFrame::RedisplayMoveLine(HDC hDC)
{
  switch (move.GetMoveLineMode()) 
  {
   case EMMoveLine::MoveExpansion:
    {
      Fission* f = move.GetMoveFission();
      Fission* top = GetEditFF()->GetTop();
      Fission* bottom = GetEditFF()->GetBottom();
      Vector ul = top->GetStartPoint();
      Vector dr = bottom->GetEndPoint();
      if (f->GetDir() == Fission::Vertical) 
      {
	dr.x += move.GetMovePos() - f->GetPoint();
      }
      else 
      {
	dr.y += move.GetMovePos() - f->GetPoint();
      }
      // left
      VectW from_w = ItoWv(ul);
      VectW to_w = ItoWv(Vector(ul.x, dr.y));
      DisplaySelectedLine(hDC, from_w, to_w);
      // bottom
      from_w = ItoWv(Vector(ul.x, dr.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // right
      from_w = ItoWv(Vector(dr.x, ul.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // top
      from_w = ItoWv(ul);
      to_w = ItoWv(Vector(dr.x, ul.y));
      DisplaySelectedLine(hDC, from_w, to_w);
    }
    // go down
   case EMMoveLine::Move:
    {
      if (move.IsFixed() == False) 
      {
	break;
      }
      Vector from;
      Vector to;
      Fission* f = move.GetMoveFission();
      Vector st_pos = f->GetStartPoint();
      Vector ed_pos = f->GetEndPoint();
      if (f->GetDir() == Fission::Vertical) 
      {
	from.x = to.x = move.GetMovePos();
	from.y = st_pos.y;
	to.y = ed_pos.y;
      }
      else 
      {  // Fission::Horizontal
	from.y = to.y = move.GetMovePos();
	from.x = st_pos.x;
	to.x = ed_pos.x;
      }
      VectW from_w = ItoWv(from);
      VectW to_w = ItoWv(to);
      DisplaySelectedLine(hDC, from_w, to_w);
    }
    break;
   case EMMoveLine::SegMove:
    {
      //
      // segment move
      //
      if (move.IsFixed() == False) 
      {
	break;
      }
      Vector from;
      Vector to;
      if (move.GetMoveFission()->GetDir() == Fission::Vertical) 
      {
	from.x = to.x = move.GetMovePos();
	from.y = move.GetSegStart()->Y();
	to.y = move.GetSegEnd()->Y();
      }
      else 
      {  // Fission::Horizontal
	from.y = to.y = move.GetMovePos();
	from.x = move.GetSegStart()->X();
	to.x = move.GetSegEnd()->X();
      }
      VectW from_w = ItoWv(from);
      VectW to_w = ItoWv(to);
      DisplaySelectedLine(hDC, from_w, to_w);
    }
    break;
   case EMMoveLine::ScaleOneDirTable:
   case EMMoveLine::StretchOneDirTable:
    {
      if (move.IsFixed() == False) 
      {
	break;
      }
      Fission* f = move.GetMoveFission();
      Fission* top = GetEditFF()->GetTop();
      Fission* bottom = GetEditFF()->GetBottom();
      Fission* left = GetEditFF()->GetLeft();
      Fission* right = GetEditFF()->GetRight();
      Vector ul = top->GetStartPoint();
      Vector dr = bottom->GetEndPoint();
      if (f == top) 
      {
	ul.y = move.GetMovePos();
      }
      else if (f == bottom) 
      {
	dr.y = move.GetMovePos();
      }
      else if (f == left) 
      {
	ul.x = move.GetMovePos();
      }
      else if (f == right) 
      {
	dr.x = move.GetMovePos();
      }
      // left
      VectW from_w = ItoWv(ul);
      VectW to_w = ItoWv(Vector(ul.x, dr.y));
      DisplaySelectedLine(hDC, from_w, to_w);
      // bottom
      from_w = ItoWv(Vector(ul.x, dr.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // right
      from_w = ItoWv(Vector(dr.x, ul.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // top
      from_w = ItoWv(ul);
      to_w = ItoWv(Vector(dr.x, ul.y));
      DisplaySelectedLine(hDC, from_w, to_w);
    }
    break;
   case EMMoveLine::ScaleTable:
   case EMMoveLine::StretchTable:
    {
      CrossPoint* cp = move.GetScaleCorner();
      Vector pos = move.GetScalePos();
      Fission* top = GetEditFF()->GetTop();
      Fission* bottom = GetEditFF()->GetBottom();
      Vector ul = top->GetStartPoint();
      Vector dr = bottom->GetEndPoint();
      if (cp == top->GetStartCrossPoint()) 
      {
	ul = pos;
      }
      else if (cp == top->GetEndCrossPoint()) 
      {
	ul.y = pos.y;
	dr.x = pos.x;
      }
      else if (cp == bottom->GetStartCrossPoint()) 
      {
	ul.x = pos.x;
	dr.y = pos.y;
      }
      else if (cp == bottom->GetEndCrossPoint()) 
      {
	dr = pos;
      }
      // left
      VectW from_w = ItoWv(ul);
      VectW to_w = ItoWv(Vector(ul.x, dr.y));
      DisplaySelectedLine(hDC, from_w, to_w);
      // bottom
      from_w = ItoWv(Vector(ul.x, dr.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // right
      from_w = ItoWv(Vector(dr.x, ul.y));
      to_w = ItoWv(dr);
      DisplaySelectedLine(hDC, from_w, to_w);
      // top
      from_w = ItoWv(ul);
      to_w = ItoWv(Vector(dr.x, ul.y));
      DisplaySelectedLine(hDC, from_w, to_w);
    }
    break;
   case EMMoveLine::SelLine:
   case EMMoveLine::SelSeg:
   case EMMoveLine::Idle:
    break;
  }
}
