// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mstream.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Memory Stream class
// Xg[NXBfobNpɎg

#ifndef NDEBUG
#include "pword.h"
#include <stdarg.h>
#include <stdlib.h>
#include "mstream.h"

const uword InitialSize = 1 * Kilo;

MemStream::MemStream(size_t buf_size)
  : rm(InitialSize)
{
  stream_pos = 0;
  one_time_buf_size = buf_size;
}

MemStream::~MemStream()
{
}

void CDECL
MemStream::Printf(char* format, ...)
{
  char* buf = new char[one_time_buf_size];
  va_list va;
  va_start(va, format);
  wvsprintf(buf, format, (VA_LIST) va);
  va_end(va);
  size_t write_size = strlen(buf) + 1;
  if (write_size + stream_pos >= rm.GetSize())
  {
    if (write_size < rm.GetSize())
    {
      rm.EnlargeMemory((ubyte)2);
    }
    else
    {
      rm.EnlargeMemory(write_size * 2);
    }
  }
  memcpy(rm.GetPointer(stream_pos), buf, write_size);
  delete buf;
  stream_pos += write_size;
}
#endif /* not NDEBUG */
