// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: multisel.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class EditFrame
// t[GfB^̕IǗNX

#include "pword.h"
#include "lslist.h"
#include "uniqltl.h"
#include "linesele.h"
#include "editfram.h"
#include "vdisplay.h"
#include "fission.h"
#include "document.h"
#include "docconte.h"
#include "docwindo.h"

// initialize, call FissionList constructor
void 
EditFrame::InitLineSelection()
{
  lines = new LSList();
}

// call FissionList destructor
void 
EditFrame::EndLineSelection()
{
  delete lines;
  lines = 0;
}

// add multi line selection
LineSelection* 
EditFrame::AddLineSelection(Fission* f, 
			     CrossPoint* s, 
			     CrossPoint* e)
{
  if (s == 0) 
  {
    s = f->GetStartCrossPoint();
  }
  if (e == 0) 
  {
    e = f->GetEndCrossPoint();
  }
  LineSelection* ls = new LineSelection(GetEditLT(), f, s, e);
  lines->Push(ls);
  InvalidateLineSelection(ls);
  return ls;
}

// delete multi line selection
void 
EditFrame::DeleteLineSelection(LineSelection* ls)
{
  InvalidateLineSelection(ls);
  ls->ClearSelection();
  lines->Delete(ls);
  delete ls;
}

// delete multi line selection
void 
EditFrame::DeleteLineSelection(Fission* f)
{
  bool done_flag = True;
  do 
  {
    done_flag = False;
    LSListIterator lsi(lines);
    LineSelection* ls;
    while ((ls = lsi()) != 0) 
    {
      if (ls->GetFission() == f) 
      {
	lines->Delete(ls);
	InvalidateLineSelection(ls);
	ls->ClearSelection();
	delete ls;
	done_flag = True;
      }
    }
  } while (done_flag);
}

// clear multi line selection
void 
EditFrame::ClearLineSelection()
{
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    ls->ClearSelection();
    delete ls;
  }
  lines->Clear();
  InvalidateLineSelection();	// for the time being
}

// invisible line selection
void 
EditFrame::InvisibleLineSelection()
{
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    ls->ClearSelection();
  }
}

// visible line selection
void 
EditFrame::VisibleLineSelection()
{
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    ls->SetSelection();
  }
}

// clear line selection
// delete layout-template's selection, never invalidate
void 
EditFrame::ClearLineSelection(LayoutTemplate* lt)
{
  bool done_flag;
  do 
  {
    done_flag = False;
    LSListIterator lsi(lines);
    LineSelection* ls;
    while ((ls = lsi()) != 0) 
    {
      if (ls->GetLayoutTemplate() == lt) 
      {
	lines->Delete(ls);
	delete ls;
	done_flag = True;
	break;
      }
    }
  } while (done_flag);
}

// find line
LineSelection* 
EditFrame::FindLineSelection(Fission* f)
{
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    if (ls->GetFission() == f) 
    {
      return ls;
    }
  }
  return 0;
}

LineSelection* 
EditFrame::FindLineSelection(Fission* f, 
			      CrossPoint* st,
			      CrossPoint* ed)
{
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    if ((ls->GetFission() == f) &&
	(ls->GetStartCrossPoint() == st) &&
	(ls->GetEndCrossPoint() == ed)) 
    {
      return ls;
    }
  }
  return 0;
}

void 
EditFrame::InvalidateLineSelection()
{
#ifdef INVALIDATE_LINE_ONLY
  UniqLTList ultl;
  LSListIterator lsi(lines);
  LineSelection* ls;
  while ((ls = lsi()) != 0) 
  {
    ultl.Add(ls->GetLayoutTemplate());
  }
  
  if (Selected_Window != 0)
  {
    LTListIterator ltli(ultl.GetLTList());
    LayoutTemplate* lt;
    while ((lt = ltli()) != 0)
    {
      Selected_Window->InvalidateRequestedLine(lt);
    }
  }
#else
  // for the time being
  doc->GetDocumentContent()->Invalidate();
#endif
}

void 
EditFrame::InvalidateLineSelection(LineSelection* 
#ifdef INVALIDATE_LINE_ONLY
ls
#endif
)
{
#ifdef INVALIDATE_LINE_ONLY
  if (Selected_Window != 0)
  {
    Selected_Window->InvalidateRequestedLine(ls->GetLayoutTemplate());
  }
#else
  // for the time being
  doc->GetDocumentContent()->Invalidate();
#endif
}
				     
// check selection existence
bool 
EditFrame::ExistLineSelection()
{
  return(toolbox == MoveLine_MODE && lines->Number() != 0);
}

// get selection border line
uword 
EditFrame::GetLineSelectionBorderLine()
{
  if (ExistLineSelection() == False) 
  {
    // there aren't any selected lines.
    return 0;
  }
  return lines->Access(1)->GetBorderLineIndex();
}

// set border line
void 
EditFrame::SetLineSelectionBorderLine(uword new_index)
{
  LSListIterator lsl(lines);
  LineSelection* ls;
  while ((ls = lsl()) != 0) 
  {
    ls->SetBorderLineIndex(new_index);
  }
}
