// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: mwindow.h,v 3.5 2000/05/04 13:44:07 kudou Exp $
// class definition for mainwindow

#ifndef MWINDOW_H
#define MWINDOW_H

#include "window.h"

class MainWindow
  : public Window
{
private:
  static int size;
  static HANDLE hAccel;
  static char szClassName[14];
  static MDIClient* client_window;
  
  static struct HelpData
  {
    int ID;
    WORD command;
    char* string;
  } help_data [];
  
public:
  MainWindow();
  ~MainWindow();

private:
#ifdef BW3_DISPATCH
  LRESULT_T NEAR DispatchSystemCommand(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long NEAR DispatchSystemCommand(int command, long lParam);
#endif /* BW3_DISPATCH */
  
public:
  // constructor and destructor helpers
  void Make();	// called in common from constructors
  void Terminate();

  // accessors
  static MDIClient* GetMDIClient()
  {
    return client_window;
  }
  static HANDLE GetAccel() { return(hAccel); }
  
  // position the MDI client window properly
  void PositionWindows();
	
  // send pseudo-WM_COMMAND messages around to see what menu items
  // should be enabled
  void InitMenuPopup(HMENU hMenu);

  // Register -- register the MainWindow menu class with Windows
  static void	Register();
	
  // WndProc -- C++ style windows procedures for MainWindow
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

  // Dispatch -- handle WM_COMMAND type messages
#ifdef BW3_DISPATCH
  LRESULT_T Dispatch(WORD command, WORD notify_code, HWND hwnd);
#else /* BW3_DISPATCH */
  long Dispatch(int command, long lParam);
#endif /* BW3_DISPATCH */

  // need a special window proc -- we are an MDI "frame"
  LRESULT_T DefWindowProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
	
  // See if the currently active document window is maximized.  
  // This is necessary
  // sometimes because Windows eats excrement with mayonnaise.
  bool CurrentActiveDocumentWindowMaximized();
   
  int GetSize()
  {
    return size;
  }
};

#endif /* MWINDOW_H */
