// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pagemap.cpp,v 3.5 2000/05/03 12:18:34 kudou Exp $
// PageMap class
// CAEg̃ev[gƃCX^XƂ̑ΉsȂNX
// ܂ACAEg̃ev[g牽ł̃CX^X
// Ă邩Aۂ̃t[ƃev[g̃t[Q[g
// Ƃ̑ΉsȂ

#include "pword.h"
#include "tflist.h"
#include "pmlist.h"
#include "pagemap.h"
#include "layoutte.h"
#include "frametem.h"
#include "layoutin.h"
#include "frameins.h"
#include "uniqltl.h"
#include "table.h"
#include "pagesize.h"
#include "panel.h"
#include "docconte.h"
#include "document.h"
#include "textflow.h"
#include "bufnew.h"
#include "fission.h"
#include "pstreams.h"
#include "bitstrin.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

// constructor
PageMap::PageMap(DocumentContent* doc, LayoutTemplate* lt)
{
  PageMap::doc = doc;
  PageMap::lt = lt;
  lt->IncRefCount();
  map = new TFList();
  uword n = lt->GetGateSize();
  for (uword i = 0; i < n; i++) 
  {
    // set null text-flow for each gate
    map->Inject(0);
  }
  gate_size = n;
  page_num = 0;
  first_li = 0;
  last_li = 0;
  vzp_flags = 0;
}

// constructor, for file read
PageMap::PageMap()
{
  doc = 0;
  lt = 0;
  map = 0;
  gate_size = 0;
  page_num = 0;
  first_li = 0;
  last_li = 0;
  vzp_flags = 0;
}

// initialize, for file load
void 
PageMap::Initialize(DocumentContent* doc, LayoutTemplate* lt)
{
  PageMap::doc = doc;
  PageMap::lt = lt;
  lt->IncRefCount();
  map = new TFList();
  uword n = lt->GetGateSize();
  for (uword i = 0; i < n; i++) 
  {
    // set null text-flow for each gate
    map->Inject(0);
  }
  gate_size = n;
  page_num = 0;
  first_li = 0;
  last_li = 0;
  vzp_flags = 0;
}

// destructor
PageMap::~PageMap()
{
  RemoveInstance();
  LayoutTemplate* lt_ = lt;
  lt = 0;		// important!
  lt_->DecRefCount();
  delete map;
}

PageMap* 
PageMap::DuplicatePageMap(char* name)
{
  LayoutTemplate* new_lt = new LayoutTemplate(doc, lt, name);
  PageMap* pm = new PageMap(doc, new_lt);
  
  // copy gate info.
  TFListIterator tfli(map);
  TextFlow* tf;
  uword g = 1;
  while ((tf = tfli()) != 0) 
  {
    pm->Replace(g++, tf);
  }
  
  return pm;
}

PageMap* 
PageMap::MakeReplacePageMap(LayoutTemplate* lt)
{
  PageMap* pm = new PageMap(doc, lt);
  // copy gate info.
  uword g = 1;
  TextFlow* tf;
  if (pm->gate_size >= gate_size) 
  {
    TFListIterator tfli(map);
    while ((tf = tfli()) != 0) 
    {
      pm->Replace(g++, tf);
    }
  }
  
  if (pm->gate_size > gate_size) 
  {
    while (g <= pm->gate_size) 
    {
      tf = new TextFlow(doc);
      pm->Replace(g++, tf);
      tf->SeedParagraph();
    }
  }
  
  if (pm->gate_size < gate_size) 
  {
    g = 1;
    TFListIterator tfli(map);
    while ((tf = tfli()) != 0) 
    {
      if (!tf->IsEmpty()) 
      {
	pm->Replace(g++, tf);
	if (g > pm->gate_size) 
	{
	  break;
	}
      }
    }
    if (g <= pm->gate_size) 
    {
      TFListIterator tfli(map);
      while ((tf = tfli()) != 0) 
      {
	if (tf->IsEmpty()) 
	{
	  pm->Replace(g++, tf);
	  if (g > pm->gate_size) 
	  {
	    break;
	  }
	}
      }
    }
  }
  
  return pm;
}

// kill frame
// delete all frame-templates and frame-instances
void 
PageMap::KillAllFrames()
{
  lt->KillAllFrames();
}

// remove text-flow
void 
PageMap::RemoveTextFlow(TextFlow* tf, BufferPointer* bp)
{
  if (doc->GetShuttingDown()) 
  {
    delete bp;
    bp = 0;
  }
  else 
  {
    // find replace buffer pointer
    if (bp == 0) 
    {
      TFListIterator tfli(map);
      TextFlow* rep_tf = 0;
      while ((rep_tf = tfli()) != 0) 
      {
	if ((rep_tf != 0) &&
	    (tf != rep_tf) &&
	    (doc->GetFirstTextFlowFrame(rep_tf) != 0)) 
	{
	  bp = rep_tf->GetStartBufferPointer();
	  break;
	}
      }
    }
    
    if (bp == 0) 
    {
      for (TextFlow* t = doc->GetNonHeaderTextFlow();
	   t != 0; t = t->GetNext()) 
      {
	// find replace text-flow in nonheader text-flow
	if ((t != tf) &&
	    (!t->OnZeroPageP()) &&
	    (doc->GetFirstTextFlowFrame(t) != 0))
	{
	  bp = t->GetStartBufferPointer();
	  break;
	}
      }
    }
    
    if (bp == 0) 
    {
      for (TextFlow* t = doc->GetFirstTextFlow();
	   t != 0; t = t->GetNext()) 
      {
	// find hole text-flow
	if ((t != tf) &&
	    (doc->GetFirstTextFlowFrame(t) != 0))
	{
	  bp = t->GetStartBufferPointer();
	  break;
	}
      }
    }
  }
  
  tf->PrepareToDie(bp);
  delete bp;
  delete tf;
}

// remove instance
void 
PageMap::RemoveInstance()
{
  // report all frame
  for (LayoutInstance* li = first_li;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    for (FrameInstance* fi = li->GetFirstFrame();
	 fi != 0;
	 fi = fi->GetNextLFI()) 
    {
      fi->PrepareToChangeFlow();
    }
  }
  
  // delete layout-instance
  if (page_num != 0) 
  {
    VanishNPage(page_num);
  }
  
  // delete text-flow
  TFListIterator tfli(map);
  TextFlow* tf = 0;
  if (lt->IsTable()) 
  {
    // table
    BufferPointer* bp = ((Table*)this)->GetPanel()->GetRightBP();
    while ((tf = tfli()) != 0) 
    {
      if ((tf != 0) && (doc->GetFirstTextFlowFrame(tf) == 0)) 
      {
	BufferPointer* advise_bp = new BufferPointer(bp);
	RemoveTextFlow(tf, advise_bp);
      }
    }
  }
  else 
  {
    // normal pagemap
    while ((tf = tfli()) != 0) 
    {
      if ((tf != 0) && (doc->GetFirstTextFlowFrame(tf) == 0)) 
      {
	RemoveTextFlow(tf);
      }
    }
  }
  
  // clear map
  map->Clear();
}

// remove instance
void 
PageMap::RemoveInstance(FrameTemplate* ft)
{
  // remove frame-instance
  for (LayoutInstance* li = first_li;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    FrameInstance* fi = li->FindFIByFT(ft);
    delete fi;
  }
  
  // remove text-flow
  TextFlow* tf;
  uword gate;
  GetGateInfo(ft, &tf, &gate);
  if ((tf != 0) && (doc->GetFirstTextFlowFrame(tf) == 0)) 
  {
    RemoveTextFlow(tf);
  }
  
  // remove page-map gate
  if ((gate != 0) &&
      (ft->GetNextTFFT() == 0)) 
  {
    Remove(gate);
  }
}


// gate interface

// get gate text-flow
TextFlow* 
PageMap::GetGateTF(uword gate_number)
{
  return map->Access(gate_number);
}

// get gate text-flow
TextFlow* 
PageMap::GetGateTF(FrameTemplate* ft)
{
  uword n = lt->GetGateNumber(ft);
  if (n != 0) 
  {
    return map->Access(n);
  }
  return 0;
}

// get gate info
void 
PageMap::GetGateInfo(FrameTemplate* gate_ft, TextFlow** tf, uword* gate)
{
  uword n = lt->GetGateNumber(gate_ft);
  if (n != 0) 
  {
    *tf = map->Access(n);
  }
  else 
  {
    *tf = 0;
  }
  *gate = n;
}

// get gate frame-template
FrameTemplate* 
PageMap::GetGateFT(uword gate_number)
{
  return lt->GetGateFT(gate_number);
}

// get gate frame-template
FrameTemplate* 
PageMap::GetGateFT(TextFlow* tf)
{
  uword n = map->Search(tf);
  if (n != 0) 
  {
    return lt->GetGateFT(n);
  }
  return 0;
}

// get gate number
uword 
PageMap::GetGateNumber(TextFlow* tf)
{
  return map->Search(tf);
}

// replace textflow map.
void 
PageMap::Replace(uword gate_number, TextFlow* tf)
{
  map->Replace(gate_number, tf);
}

// remove map
void 
PageMap::Remove(uword gate_number)
{
  map->Delete(gate_number);
  gate_size --;
}

// add map
void 
PageMap::Add(FrameTemplate* gate_ft, TextFlow* tf)
{
  uword num = lt->GetGateNumber(gate_ft);
  if ((num == 0) || (num != gate_size + 1)) 
  {
    // error
    return;
  }
  map->Inject(tf);
  gate_size ++;
}

// get eraseable text-flow number
uword 
PageMap::GetErasableFlowNumber()
{
  uword empty = 0;
  TFListIterator tfli(map);
  TextFlow* tf = 0;
  while ((tf = tfli()) != 0) 
  {
    if (tf->IsEmpty()) 
    {
      empty ++;
    }
  }
  return empty;
}

// report change first frame
void 
PageMap::ReportChangeFirstFrame()
{
  TFListIterator tfli(map);
  TextFlow* tf = 0;
  while ((tf = tfli()) != 0) 
  {
    tf->ReportChangeFirstFrame();
  }
}


// page interface

// count layout-instances number
void 
PageMap::CountPageNumber()
{
  uword n = 0;
  for (LayoutInstance* li = first_li;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    n++;
  }
  page_num = n;
}

// generate page
LayoutInstance* 
PageMap::GenerateNPage(uword n)
{
  if (n == 0) 
  {
    return 0;
  }
  LayoutInstance* li;
  LayoutInstance* first = li = new LayoutInstance(this, last_li);
  if (first_li == 0) 
  {
    first_li = li;
  }
  for (uword i = 1; i < n; i++) 
  {
    li = new LayoutInstance(this, li);
  }
  last_li = li;
  CountPageNumber();
  if (!lt->IsTable()) 
  {
    doc->RecalcAllLayoutLunit();
    doc->RecalcLayouts();
  }
  for (li = first; li != 0; li = li->GetNextPageMapLayout()) 
  {
    li->Invalidate();
  }
  return first;
}

// generate page for file read
LayoutInstance* 
PageMap::GeneratePage()
{
  uword num = GetPageNum();
  SetPageNum(0);
  LayoutInstance* first = GenerateNPage(num);
  if (vzp_flags != 0) 
  {
    // set visible zero page flags
    udword n = 0;
    for (LayoutInstance* li = first_li;
	 li != 0;
	 li = li->GetNextPageMapLayout()) 
    {
      li->SetVisibleZeroPage((*vzp_flags)[n++]);
    }
  }
  return first;
}

// vanish page
void 
PageMap::VanishNPage(uword num)
{
  if (num > page_num) 
  {
    num = page_num;
  }
  if (num == 0) 
  {
    return;
  }
  
  LayoutInstance* li = last_li;
  uword n;
  for (n = 0; n < num; n++)
  {
    li->PrepareToDie();
    li = li->GetPrevLayout();
  }
  
  li = last_li;
  LayoutInstance* prev = 0;
  for (n = 0; n < num; n++) 
  {
    prev = li->GetPrevLayout();
    
    // invalidate
    li->Invalidate();
    
    // remove
    delete li;
    li = prev;
  }
  if (num == page_num) 
  {
    first_li = 0;
    last_li = 0;
  }
  else 
  {
    last_li = prev;
  }
  
  CountPageNumber();
  
  if (lt->IsRegular()) 
  {
    doc->LayoutRemoved();
  }
  if (!lt->IsTable()) 
  {
    doc->RecalcAllLayoutLunit();
    doc->RecalcLayouts();
  }
}

// expand page capability check
// return               : True, expand posible
//                      : False, expand imposible
bool 
PageMap::CanExpandPage()
{
  uword n = GetGateSize();
  if (n == 0) 
  {
    return True;
  }
  
  if (doc->GetPageMapSize() <= 1) 
  {
    return False;
  }
  
  TFListIterator tfli(map);
  TextFlow* tf = 0;
  while ((tf = tfli()) != 0) 
  {
    // all text flow
    
    PMListIterator pmli(doc->GetPMList());
    PageMap* pm;
    while ((pm = pmli()) != 0) 
    {
      if (pm == this) 
      {
	break;
      }
    }
    if (pm == 0) 
    {
      // this page-map isn't mapped
      assert(False);
      continue;
    }
    while ((pm = pmli()) != 0) 
    {
      if ((pm->GetGateNumber(tf)) != 0) 
      {
	return True;
      }
    }
  }
  return False;
}

// condense page check
// return               : True, condense posible
//                        Fase, condense imposible
bool 
PageMap::CanCondensePage()
{
  if ((GetGateSize() == 0) &&
      (GetPageNum() > 1)) 
  {
    return True;
  }
  
  if (doc->GetPageMapSize() <= 1) 
  {
    return False;
  }
  
  TFListIterator tfli(map);
  TextFlow* tf = 0;
  
  while ((tf = tfli()) != 0) 
  {
    // all text flow
    
    // empty text flow check
    if (tf->IsEmpty()) 
    {
      if ((tf->GetNext() == 0) && (tf->GetPrev() == 0)) 
      {
	// store last flow!
	return False;
      }
      continue;
    }
    
    // search another map
    PMListIterator pmli(doc->GetPMList());
    PageMap* pm;
    while ((pm = pmli()) != 0) 
    {
      if (pm == this) 
      {
	break;
      }
    }
    if (pm != 0) 
    {
      while ((pm = pmli()) != 0) 
      {
	if (pm->GetGateNumber(tf) != 0) 
	{
	  break;
	}
      }
    }
    
    if (pm == 0) 
    {
      // check unused frame
      FrameInstance* fi = GetLastLayout()->GetGateFI(tf);
      assert(fi != 0);
      if (!fi->EraseableFrameP()) 
      {
	return False;
      }
    }
  }
  return True;
}

// divide page-map
PageMap* 
PageMap::Divide(LayoutInstance* li)
{
  // create new page-map
  PageMap* pm = new PageMap(doc, lt);
  
  // map the text-flow
  TFListIterator tfli(GetTFMap());
  TextFlow* tf;
  uword i = 1;
  while ((tf = tfli()) != 0) 
  {
    pm->Replace(i++, tf);			// textflow - gate map
  }
  
  // set first and last layout-instance
  pm->first_li = li;
  pm->last_li = last_li;
  // update this
  last_li = li->GetPrevPageMapLayout();
  if (last_li == 0) 
  {
    first_li = 0;
  }
  // change page-map in the layout-instance
  while (li != pm->last_li) 
  {
    li->SetPageMap(pm);
    li = li->GetNextPageMapLayout();
  }
  li->SetPageMap(pm);
  last_li->ClearNextPageMapLayout();
  pm->first_li->ClearPrevPageMapLayout();
  
  // set the page-number
  if (first_li == 0) 
  {
    page_num = 0;
  }
  else 
  {
    uword n = 1;
    for (LayoutInstance* l = first_li; 
	 l != last_li; 
	 l = l->GetNextPageMapLayout()) 
    {
      n++;
    }
    page_num = n;
  }
  
  if (pm->first_li == 0) 
  {
    pm->page_num = 0;
  }
  else 
  {
    uword n = 0;
    for (LayoutInstance* l = pm->first_li; 
	 l != 0;
	 l = l->GetNextPageMapLayout()) 
    {
      l->SetPageMapPageNumber(++n);
    }
    pm->page_num = n;
  }
  return pm;
}

// check identical gate
bool 
PageMap::IsIdenticalGate(PageMap* pm)
{
  TFListIterator tfli1(GetTFMap());
  TFListIterator tfli2(pm->GetTFMap());
  TextFlow* tf1;
  TextFlow* tf2;
  for (;;) 
  {
    tf1 = tfli1();
    tf2 = tfli2();
    if (tf1 != tf2) 
    {
      return False;
    }
    if ((tf1 == 0) || (tf2 == 0)) 
    {
      break;
    }
  }
  return True;
}

// check page-map identical twins
bool 
PageMap::IsIdenticalTwins(PageMap* pm)
{
  if (lt != pm->lt) 
  {
    // different template
    return False;
  }
  return IsIdenticalGate(pm);
}

// concat twins
void 
PageMap::ConcatTwins(PageMap* next)
{
  if ((next->first_li == 0) || 
      (next->last_li == 0) || 
      (next->page_num == 0)) 
  {
    return;
  }
  
  // change layout-instance's owner
  LayoutInstance* li = next->first_li;
  for (;;) 
  {
    li->SetPageMap(this);
    if (li == next->last_li) 
    {
      break;
    }
    li = li->GetNextLayout();
  }
  
  last_li = next->last_li;
  page_num += next->page_num;
  next->first_li = 0;
  next->last_li = 0;
  next->page_num = 0;
}

// get first text-flow frame
FrameInstance* 
PageMap::GetFirstTextFlowFrame(TextFlow* tf)
{
  if (first_li == 0) 
  {
    return 0;
  }
  for (FrameTemplate* ft = GetGateFT(tf);
       ft != 0;
       ft = ft->GetNextTFFT()) 
  {
    FrameInstance* fi = first_li->FindFIByFT(ft);
    if (fi != 0) 
    {
      return fi;
    }
  }
  return 0;
}

// get last text-flow frame
FrameInstance* 
PageMap::GetLastTextFlowFrame(TextFlow* tf)
{
  return(last_li == 0) ? 0 : last_li->GetExitFI(tf);
}

// copy text-flow gate infomation
void 
PageMap::CopyTFGateInfo(PageMap* source)
{
  TFListIterator tfli(source->GetTFMap());
  TextFlow* tf;
  uword n = 1;
  while ((tf = tfli()) != 0) 
  {
    Replace(n++, tf);
  }
}

// get previous page-map
PageMap* 
PageMap::GetPrevPageMap()
{
  return doc->GetPrevPageMap(this);
}

// get next page-map
PageMap* 
PageMap::GetNextPageMap()
{
  return doc->GetNextPageMap(this);
}

// get previous page-map which has argument text-flow
PageMap* 
PageMap::GetTextFlowPrevPageMap(TextFlow* tf)
{
  for (PageMap* pm = GetPrevPageMap();
       pm != 0;
       pm = pm->GetPrevPageMap()) 
  {
    if (pm->map->Search(tf) != 0) 
    {	// find text-flow
      return pm;
    }
  }
  return 0;
}

// get next page-map which has argument text-flow
PageMap* 
PageMap::GetTextFlowNextPageMap(TextFlow* tf)
{
  for (PageMap* pm = GetNextPageMap();
       pm != 0;
       pm = pm->GetNextPageMap()) 
  {
    if (pm->map->Search(tf) != 0) 
    {	// find text-flow
      return pm;
    }
  }
  return 0;
}

// change layout size
void 
PageMap::ChangeLayoutSize(Iunit width, Iunit height)
{
  lt->GetFissionFrame()->ChangeSize(width, height);
  doc->RecalcAllLayoutLunit();
}

// save
void 
PageMap::WriteToStream(PStream* stream, UniqLTList* ltlist)
{
  // save header and version
  stream->StartBlockOut(PStream::HDR_PAGEMAP, save_version);
  CHECK;
  
  uword lt_n = ltlist->GetLTNum(GetLayoutTemplate());
  uword page_num = GetPageNum();
  uword gate_size = GetGateSize();
  
  // save layout number
  stream->OutUWord(lt_n);
  CHECK;
  
  // save page number
  stream->OutUWord(page_num);
  CHECK;
  
  // save gate size
  stream->OutUWord(gate_size);
  CHECK;
  
  TFListIterator tfli(GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    uword sid = GetTextFlowSID(tf);
    // save id
    stream->OutUWord(sid);
    CHECK;
  }
  
  // sage layout visible zero page flags
  BitString bs(page_num);
  udword n =0;
  for (LayoutInstance* li = first_li;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    bs.Set(n++, li->VisibleZeroPage());
  }
  
  bs.WriteToStream(stream);
  CHECK;
  
  stream->EndBlockOut();
}

// load for derived class
PageMap* 
PageMap::ReadFromStream(PageMap* this_,
			 PStream* stream,
			 DocumentContent* doc,
			 UniqLTList* ltlist,
			 TFList* tfl)
{
  // read header and version
  word version;
  stream->StartTypedBlockIn(PStream::HDR_PAGEMAP, version);
  CHECK 0;
  
  if (version != save_version) 
  {
    stream->SetError(SE_BADVERSION);
    return 0;
  }
  
  uword lt_n, page_num, gate_size;
  
  // layout number
  lt_n = stream->InUWord(); CHECK 0;
  
  // page number
  page_num = stream->InUWord(); CHECK 0;
  
  // gate size
  gate_size = stream->InUWord(); CHECK 0;
  
  LayoutTemplate* lt = ltlist->GetLT(lt_n);
  PageMap* pm = (this_ == 0) 
  ? (new PageMap(doc, lt))
  : (this_->Initialize(doc, lt), this_);
  
  for (uword i = 1; i <= gate_size; i++) 
  {
    uword sid;
    // save id
    sid = stream->InUWord(); CHECK 0;
    TextFlow* tf;
    if (tfl == 0) 
    {
      tf = doc->GetTextFlow(sid);
    }
    else 
    {
      tf = tfl->Access(sid);
    }
    pm->Replace(i, tf);				// textflow - gate map
  }
  pm->SetPageNum(page_num);
  
  // read layout visible zero page flags
  pm->vzp_flags = BitString::ReadFromStream(stream);
  if (stream->GetError() == SE_NOMORE) 
  {
    stream->SetError(SE_NOERROR);
  }
  CHECK 0;
  
  stream->EndBlockIn();
  return pm;
}

// get textflow SID
uword 
PageMap::GetTextFlowSID(TextFlow* tf)
{
  uword sid = 0;
  for (TextFlow* t = doc->GetFirstTextFlow();
       t != 0;
       t = t->GetNext()) 
  {
    if (!t->OnTableP()) 
    {
      sid++;
    }
    if (t == tf) 
    {
      break;
    }
  }
  return sid;
}

// get default text frame margin
Margin 
PageMap::GetDefaultMargin()
{
  switch (lt->GetKind()) 
  {
   case LayoutTemplate::PageSizeTemplate:
   case LayoutTemplate::RegularTemplate:
    return PageSize::GetDefaultFrameMargin();
   case LayoutTemplate::TableTemplate:
    return Table::GetDefaultFrameMargin();
  }
  return Margin(0, 0, 0, 0);
}

// ------------------------------------------------------------
// vanishing unused layout

// search unused layout and kill 
void 
PageMap::KillUnusedLayout(LayoutInstance* from)
{
  PageMap* next_pm = from->GetPageMap()->GetNextPageMap();
  if (next_pm != 0) 
  {
    // invalidate next page-map layout
    // because RecalcAllLayoutLunit() is called in VanishNPage.
    next_pm->GetDocumentContent()->InvalidateToEnd(next_pm);
  }
  
  for (PageMap* scan_pm = from->GetPageMap();
       scan_pm != 0;
       scan_pm = next_pm) 
  {
    next_pm = scan_pm->GetNextPageMap();
    for (LayoutInstance* li = from;
	 li != 0;
	 li = li->GetNextPageMapLayout()) 
    {
      if (li->IsUsed() == False) 
      {
	scan_pm->RemoveLayoutToLast(li);
	if (scan_pm->GetFirstLayout() == 0) 
	{
	  delete scan_pm;
	  scan_pm->GetDocumentContent()->RemovePageMap(scan_pm);
	}
	for (scan_pm = next_pm;
	     scan_pm != 0;
	     scan_pm = next_pm) 
	{
	  next_pm = scan_pm->GetNextPageMap();
	  if ((scan_pm->GetFirstLayout() == 0) ||
	      (scan_pm->GetFirstLayout()->IsUsed() == False)) 
	  {
	    delete scan_pm;
	    scan_pm->GetDocumentContent()->RemovePageMap(scan_pm);
	  }
	}
	return;
      }
    }
    if (next_pm != 0) 
    {
      from = next_pm->GetFirstLayout();
    }
  }
}

// remove layout to page-map last layout
void 
PageMap::RemoveLayoutToLast(LayoutInstance* li)
{
  uword remove_num = 0;
  while (li != 0) 
  {
    remove_num++;
    li = li->GetNextPageMapLayout();
  }
  VanishNPage(remove_num);
}

void 
PageMap::Invalidate()
{
  for (LayoutInstance* li = first_li;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    li->Invalidate();
  }
}
