// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pagemap.h,v 3.3 1999/06/20 21:51:26 kudou Exp $
// PageMap class
// CAEg̃ev[gƃCX^XƂ̑ΉsȂNX
// ܂ACAEg̃ev[g牽ł̃CX^X
// Ă邩Aۂ̃t[ƃev[g̃t[Q[g
// Ƃ̑ΉsȂ

#ifndef PAGEMAP_H
#define PAGEMAP_H

class DocumentContent;
class LayoutTemplate;
class LayoutInstance;
class FrameTemplate;
class UniqLTList;
class BitString;
#ifndef TFLIST_DEFINED
class TFList;				// forword ref.
#endif

#include "margin.h"

// page mapping info. and text flow mapping info.
class PageMap
{
private:
  // back pointer, which document's page-map
  DocumentContent* doc;
  
  // layout template
  LayoutTemplate* lt;
  
  // text-flow list, this list items correspond to layout-template's gate.
  TFList* map;
  
  // gate size, cache of text flow list.
  uword gate_size;
  
  // how many pages are generated
  uword page_num;
  
  // first layout-instance which this page map is used
  LayoutInstance* first_li;
  
  // last layout-instance which this page map is used
  LayoutInstance* last_li;
  
  // layout visible zero page flags
  // used only in file read
  BitString* vzp_flags;
  
protected:
  // file save version
  enum 
  {
    save_version = 1
  };
  
  // count page number
  void CountPageNumber();
  
public:
  // constructor
  // doc		: which document
  // lt		: template
  PageMap(DocumentContent* doc, LayoutTemplate* lt);
  
  // constructor, for file read
  PageMap();
  
  // duplicate pagemap
  // This function create the another layout-template, and the created
  // layout-template has exactly same layout infomation.
  // name		: new layout-template's name
  PageMap* DuplicatePageMap(char* name);
  
  // make replace pagemap
  // lt		: layout infomation
  PageMap* MakeReplacePageMap(LayoutTemplate* lt);
  
protected:
  // initialize, for file load
  void Initialize(DocumentContent* doc, LayoutTemplate* lt);
  
  // remove text-flow
  void RemoveTextFlow(TextFlow* tf, BufferPointer* bp = 0);
  
public:
  // destructor
  ~PageMap();
  
  // kill frame
  // delete all frame-templates and frame-instances
  void KillAllFrames();
  
  // remove instance
  void RemoveInstance();
  
  // remove instance
  void RemoveInstance(FrameTemplate* ft);
  
  // ------------------------------
  // report functions

  // get layout template
  LayoutTemplate* GetLayoutTemplate() 
  { return lt; }
  
  // get document content
  DocumentContent* GetDocumentContent() 
  { return doc; }

  // ------------------------------
  // gate access methods
  // gate size
  uword GetGateSize() 
  { return gate_size; }
  
  // get gate text-flow
  TextFlow* GetGateTF(uword gate_number);
  
  // get gate text-flow
  TextFlow* GetGateTF(FrameTemplate* ft);
  
  // get gate frame-template
  FrameTemplate* GetGateFT(uword gate_number);
  
  // get gate frame-template
  FrameTemplate* GetGateFT(TextFlow* tf);
  
  // get gate number
  uword GetGateNumber(TextFlow* tf);
  
  // get eraseable text-flow number
  uword GetErasableFlowNumber();
  
  // get text flow map
  // don't change map contents
  TFList* GetTFMap() 
  {
    return map;
  }
  
  // get gate info
  // gate_ft		: gate frame-template
  // tf		: ans, gate text-flow
  // gate		: ans, gate number
  void GetGateInfo(FrameTemplate* gate_ft, TextFlow** tf, uword* gate);

  // ------------------------------
  // gate edit methods
  // replace new text-flow
  void Replace(uword gate_number, TextFlow* tf);
  
  // remove map
  void Remove(uword gate_number);
  
  // add text-flow
  void Add(FrameTemplate* gate_tf, TextFlow* tf);
  
  // ------------------------------
  // page interface

  // how many page
  uword  GetPageNum() 
  {
    return page_num;
  }
  
  void SetPageNum(uword n) 
  {
    page_num = n;
  }	// file-read only use this.
  
  // generate page
  // This method is very important, because it's the only way to 
  // create layout instances!
  // n			: how many page
  // return		: first generated layout-instance
  LayoutInstance* GenerateNPage(uword n);
  
  // generate page for file read
  // This method is called only when file read
  LayoutInstance* GeneratePage();
  
  // vanish page
  // This medhod is very important too, it's the only way to
  // vanish pages.
  // n			: how many page
  void VanishNPage(uword n);
  
  // expand page capability check
  // return		: False, expand imposible
  bool CanExpandPage();
  
  // condense page check
  // this method check the capability for page close
  // return		: False, condence imposible
  bool CanCondensePage();
  
  // divide page-map
  // This method create new page-map, and return the new.
  // The returning new page-map is not seted in document content 
  // proper position. So you shuld set the new page-map in the document
  // content after call this method.
  // li		: first layout-instance of new page-map
  // return		: new page-map
  PageMap* Divide(LayoutInstance* li);
  
  // get first layout-instance
  LayoutInstance* GetFirstLayout() 
  {
    return first_li;
  }
  
  // get last layout-instance
  LayoutInstance* GetLastLayout() 
  {
    return last_li;
  }
  
  // get previous page-map
  PageMap* GetPrevPageMap();
  
  // get next page-map
  PageMap* GetNextPageMap();
  
  // get previous page-map which has argument text-flow
  PageMap* GetTextFlowPrevPageMap(TextFlow* tf);
  
  // get next page-map which has argument text-flow
  PageMap* GetTextFlowNextPageMap(TextFlow* tf);
  
  // get first text-flow frame
  FrameInstance* GetFirstTextFlowFrame(TextFlow* tf);
  
  // get last text-flow frame
  FrameInstance* GetLastTextFlowFrame(TextFlow* tf);
  
  // copy text-flow gate infomation
  void CopyTFGateInfo(PageMap* source);

  // ------------------------------
  // section interface
  
  // check page-map identical twins
  bool IsIdenticalTwins(PageMap* pm);
  
  // check identical gate
  bool IsIdenticalGate(PageMap* pm);
  
  // concat twins
  // This method move the next's contents(layout-instances).
  // 'next' is not deleted in this method. So delete 'next'
  // after call this function.
  void ConcatTwins(PageMap* next);
  
  // change template
  // this method vanish it's old layout-instances. and create new 
  // layout-instances.
  // new_lt		: new layout-template
  //void ChangeLayoutTemplate(LayoutTemplate* new_lt);
  
  // change layout size
  void ChangeLayoutSize(Iunit width, Iunit height);
  
  // report change first frame
  void ReportChangeFirstFrame();
  
  // ------------------------------
  // file save & read
  
  // save
  // ps		: stream
  // return 		: result
  void WriteToStream(PStream* ps, UniqLTList* ltlist);
  
  // load for derived class
  static PageMap* ReadFromStream(PageMap* this_,// for derived class
				  PStream* ps,
				  DocumentContent* doc,
				  UniqLTList* ltlist,
				  TFList* tfl);		// map from
  
  // get textflow SID(Save ID)
  virtual uword GetTextFlowSID(TextFlow*);
  
  // get default text frame margin
  Margin GetDefaultMargin();
  
  // ------------------------------
  // vanishing unused layout
  
  // search unused layout and kill 
  // search_from	: search start layout
  static void KillUnusedLayout(LayoutInstance* search_from);
  
  // remove layout to page-map last layout
  void RemoveLayoutToLast(LayoutInstance* li);
  
  // ------------------------------
  // invalidate

  // invalidate page map layout
  void Invalidate();
};

#endif /* PAGEMAP_H */
