// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: panel.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Panel
// ϕA\Ȃǂ̓ꕶ߂̊{NX

#include "pword.h"
#include "panel.h"
#include "frameins.h"
#include "docconte.h"
#include "document.h"
#include "docprese.h"
#include "docwindo.h"
#include "docedit.h"
#include "bufnew.h"
#include "textflow.h"
#include "pstreams.h"
#include "tablepnl.h"
#include "vtextpnl.h"

#ifndef NDEBUG
#include "ddisplay.h"
#endif

BP* 
Panel::GetOwnedRealBP()
{
  BP* bp = new BP(GetBP());
#ifndef NDEBUG
  bool can = bp->Decrement();
  assert(can);
#else
  bp->Decrement();
#endif
  return bp;
}

// set size
void 
Panel::SetSize(Iunit width, Iunit height)
{
  Panel::width = width;
  Panel::height = height;
}

// constructor
Panel::Panel(DocumentContent* doc, BP* bpp, Iunit width, Iunit height)
{
  assert(bpp != NULL);
  
  Panel::doc = doc;
  Panel::bpp = new BP(bpp);
  Panel::width = width;
  Panel::height = height;
  pos_x = 0L;
  pos_y = 0L;
  code = doc->GetUniqPanelCode();
  GetDocumentContent()->AddPanel(this);
}

// destructor
Panel::~Panel()
{
  GetDocumentContent()->RemovePanel(this);
  if (bpp != 0) 
  {
    delete bpp;
  }
}

Iunit 
Panel::GetWidth()
{
  return width + GetAdditionalWidth();
}

Iunit 
Panel::GetHeight()
{
  return height + GetAdditionalHeight();
}

// virtual method
// get additional width
Iunit 
Panel::GetAdditionalWidth()
{
  return 0;
}

// virtual method
// get additional height
Iunit 
Panel::GetAdditionalHeight()
{
  return 0;
}

// insert panel
void 
Panel::InsertPanel()
{
  sjis code = doc->GetPanelCode(this);
  
  // insert panel.
// NO!! NOT THIS!!
#if 0
  doc->
  GetFirstDocWindow()->
  GetEditor()->
  InsertPanel(code, bpp);
#endif
  assert(Selected_Window != 0);
  Selected_Window->GetEditor()->InsertTable(code, bpp);
}

void
Panel::UpdateSize()
{
  GetTextFlow()->DelayFormat(bpp, bpp);
  DocumentWindow::touch_caret();
}

// change panel size
void 
Panel::ChangeSize(Iunit width, Iunit height)
{
  SetSize(width, height);
  UpdateSize();
}

// change panel size with no scalling
void 
Panel::StretchSize(Iunit top_diff, Iunit bot_diff,
		    Iunit lef_diff, Iunit rig_diff)
{
  top_diff = - ((height < - top_diff) ? height : - top_diff);
  bot_diff = - ((height < - bot_diff) ? height : - bot_diff);
  lef_diff = - ((width < - lef_diff) ? width : - lef_diff);
  rig_diff = - ((width < - rig_diff) ? width : - rig_diff);
  if (height < - (top_diff + bot_diff)) 
  {
    top_diff = - ((- top_diff + height + bot_diff) / 2);
    bot_diff = - (height + top_diff);
  }
  if (width < - (lef_diff + rig_diff)) 
  {
    lef_diff = - ((- lef_diff + width + rig_diff) / 2);
    rig_diff = - (width + lef_diff);
  }
  SetSize(width + lef_diff + rig_diff, height + top_diff + bot_diff);
  UpdateSize();
}

// update panel position
void 
Panel::SetPanelPosition(Lunit pos_x, Lunit pos_y)
{
  Panel::pos_x = pos_x;
  Panel::pos_y = pos_y;
}

// save
void 
Panel::WriteASCIIToStream(BufStream*)
{
}

// save panel header
void 
Panel::WriteHeaderToStream(PStream* stream)
{
  // write header
  stream->OutUWord(PStream::HDR_PANEL);
  CHECK;
  
  stream->OutUWord(code);
  CHECK;
  
  stream->OutWord(GetPanelID());
  CHECK;
}

// load
Panel* 
Panel::ReadFromStream(DocumentContent* doc, BP* bpp, PStream* stream)
{
  if (!doc->CheckPanelNumMax()) 
  {
    // panel code over flow
    return 0;
  }
  
  // read header
  int header = stream->InUWord();
  CHECK 0;
  
  if (header != PStream::HDR_PANEL) 
  {
    // header error
    return 0;
  }
  
  // for backword compatibility
  uword code = stream->InUWord();
  code = code;
  CHECK 0;
  
  PanelID id = (PanelID) (stream->InWord());
  CHECK 0;
  
  Panel* pl = 0;
  switch (id) 
  {
   case TablePanelID:		// table panel object
    pl = TablePanel::ReadFromStream(doc, bpp, stream);
    CHECK 0;
    break;
   case VTextPanelID:		// virtual text object
    pl = VTextPanel::ReadFromStream(doc, bpp, stream);
    CHECK 0;
    break;
   case GraphPanelID:
    break;
   case DDEPanelID:
    break;
   case OLEPanelID:
    break;
   default:
    // id error
    return 0;
  }
  if (pl && (!pl->ConfirmReadAll())) 
  {
    // can't read all frame object
    // may be less memory
    delete pl;
    return 0;
  }
  return pl;
}

// get layout
LayoutInstance* 
Panel::GetLayout()
{
  return 0;
}

void 
Panel::Mark(PStream*)
{
  // do nothing.
}

// get text flow
TextFlow* 
Panel::GetTextFlow()
{
  return bpp->GetTextFlow();
}

// search method
AvlSearch::Comp 
Panel::Compare(void* elem1_, void* elem2_)
{
  Panel* elem1 = (Panel*)elem1_;
  Panel* elem2 = (Panel*)elem2_;
  
  if (elem1->code == elem2->code) 
  {
    return AvlSearch::Equal;
  }
  if (elem1->code < elem2->code) 
  {
    return AvlSearch::Small;
  }
  return AvlSearch::Big;
  
}

AvlSearch::Comp 
Panel::KeyCompare(void* elem_, void* key_)
{
  Panel* elem = (Panel*)elem_;
  uword* key = (uword*)key_;
  
  if (elem->code == *key) 
  {
    return AvlSearch::Equal;
  }
  if (elem->code < *key) 
  {
    return AvlSearch::Small;
  }
  return AvlSearch::Big;
  
}

bool 
Panel::ConfirmReadAll()
{
  return True;  // default
}
