// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: panel.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Panel
// ϕA\Ȃǂ̓ꕶ߂̊{NX

#ifndef PANEL_H
#define PANEL_H

#include "avllist.h"
#include "view.h"

class Panel
{
private:
  // which document panel
  DocumentContent* doc;
  
  // panel position
  BP* bpp;
  
  // panel size
  Iunit width;
  Iunit height;
  
  // panel position
  Lunit pos_x;
  Lunit pos_y;
  
  // panel code
  uword code;
  
public:
  // recognize ID of this panel object
  enum PanelID 
  {
    TablePanelID = 1,		// table panel object
    GraphPanelID = 2,		// graphic panel object
    DDEPanelID   = 3,		// DDE panel
    OLEPanelID   = 4,		// OLE panel, Some Day *_*
    VTextPanelID   = 5,	// virtual text panel, today
  };
private:
  BP* GetBP() 
  { return bpp; }
  
protected:
  // set size
  void SetSize(Iunit width, Iunit height);
  
  // get additional width
  virtual Iunit GetAdditionalWidth();
  
  // get additional height
  virtual Iunit GetAdditionalHeight();
  
public:
  // constructor
  Panel(DocumentContent* doc, BP* bpp, Iunit width, Iunit height);
  
  // destructor
  virtual ~Panel();
  
  // insert panel
  void InsertPanel();
  
  // get panel width
  Iunit GetWidth();
  
  // get panel height
  Iunit GetHeight();
  
  // update size
  void UpdateSize();
  
  // get panel id
  virtual PanelID GetPanelID() = 0;
  
  // change panel size with scalling
  virtual void ChangeSize(Iunit width, Iunit height);
  
  // change panel size with no scalling
  virtual void StretchSize(Iunit top_diff, Iunit bot_diff,
                            Iunit lef_diff, Iunit rig_diff);
  
  // update panel position
  // pos_x, pos_y	: position
  virtual void SetPanelPosition(Lunit pos_x, Lunit pos_y);
  
  // get x position
  Lunit GetX();
  
  // get y position
  Lunit GetY();
  
  // get document
  DocumentContent* GetDocumentContent();
  
  // save
  virtual void WriteToStream(PStream* ps) = 0;
  
  // save
  virtual void WriteASCIIToStream(BufStream* ps);
  
  // save panel header
  void WriteHeaderToStream(PStream* ps);
  
  // load
  static Panel* ReadFromStream(DocumentContent* doc, BP* bpp, PStream* ps);
  
  // get layout
  virtual LayoutInstance* GetLayout();
  
  // mark attribute
  virtual void Mark(PStream* ps);
  
  // get buffer pointer
  BP* GetOwnedRealBP();
  BP* GetRightBP();
  
  // get text flow
  TextFlow* GetTextFlow();
  
  // panel code
  uword GetPanelCode() 
  { return code; }
  
  TablePanel* CastToTablePanel();
  VTextPanel* CastToVTextPanel();
  
  // search method
  static AvlSearch::Comp Compare(void* elem1, void* elem2);
  static AvlSearch::Comp KeyCompare(void* elem, void* key);
  
  // read error check
  virtual bool ConfirmReadAll();
};

inline Lunit 
Panel::GetX()
{
  return pos_x;
}

inline Lunit 
Panel::GetY()
{
  return pos_y;
}

// get document
inline DocumentContent*  
Panel::GetDocumentContent()
{
  return doc;
}

inline BP* 
Panel::GetRightBP()
{
  return this->GetBP();
}

inline TablePanel* 
Panel::CastToTablePanel()
{
  return((TablePanel*) this);
}

inline VTextPanel* 
Panel::CastToVTextPanel()
{
  return((VTextPanel*) this);
}

#endif /* PANEL_H */
