// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pclipboa.h,v 3.3 2000/05/13 16:29:03 kudou Exp $
// define PClipboard class for managing clipboard.
// The PClipboard class is a superclass to PClipboardRead and
// PClipboardWrite and implements common logic to them, as well as
// specifying the instance data, which is the same for read and write.
// It also provides the static function IsFormatAvailable.
// This clipboard class is based on the same model for reading and writing.
// The status variable maintains a current state, either opened,
// closed, or started.  The state transition is 
//
//  Open() goes from closed to opened
//  Start() goes from opened to started
//  End() goes from started back to opened
//  Close() goes from opened to closed

#ifndef PCLIPBOA_H
#define PCLIPBOA_H

class PClipboard
{
private:
  static bool open_flag;
public:
  static void EnsureClose();
  static void SetOpenFlag(bool f) { open_flag = f; }

  PClipboard();
  ~PClipboard();
	
  static int IsFormatAvailable(int);
  
  // open clipboard
  int Open(HWND);

  // close clipboard
  void Close();
	
  // start and end reading or writing -- always supplemented
  // by logic in xxRead or xxWrite class
  
  void Start();
  void End();
  
  void Handle();
	
  bool ErrorP() 
  {
    return status == error;
  }
  
private:
  // empty clipboard
  static int Empty();
		
  // the status is private -- it is managed exclusively at this level
  enum { closed, opened, started, started_handle, error };
  int status;		// one of flags above

protected:
  char* data;
  long len;
  HANDLE data_handle;
	
};

class PClipboardWrite
  : public PClipboard
{
public:

  // open(special version for writing, which includes clipboard emptying)
  int Open(HWND);

  // obtain global memory of specified length
  char* Start(udword len);

  // write global memory to clipboard
  void End(int type);

  // internal routine, or for people that have their own handles
  void Handle(int, HANDLE);
};

class PClipboardRead
  : public PClipboard
{
public:

  // get clipboard data
  char* Start(int type);
	
  // unlock clipboard data being looked at
  void End();

  // internal routine, or for people with their own handles
  HANDLE Handle(int type);
};

#endif /* PCLIPBOA_H */
