// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: picture.cpp,v 3.5 2000/05/13 16:29:04 kudou Exp $
// class Picture
// rbg}bvێNXBgDIB`ŃC[Wێ
// 邪AɃLbVꂽC[WǗ

#include "pword.h"
#include "rect.h"
#include "gslist.h"
class Picture;
GSListDeclare(Picture);
typedef GSList(Picture)            PicList;
typedef GSListIterator(Picture)    PicListIterator;
#define PICLIST_DEFINED
#include "picture.h"
#include "vdisplay.h"
#include "mwindow.h"
#include "view.h"
#include "dib.h"
#include "vmem.h"
#include "pclipboa.h"
#include "fileutil.h"
#include <limits.h>
#include <stdio.h>
#include <io.h>
#ifdef _WIN32
#include <fcntl.h>
#endif /* _WIN32 */
#ifdef __CYGWIN32__
#include <unistd.h>
#endif /* __CYGWIN32__ */

PicList* Picture::cache_pic = new PicList();
uword Picture::cache_num = 0;

// get cf_dib format memory
inline void* 
Picture::GetCF_DIB()
{
  return(void*)*vm_dib;
}

// set dib width and height
void 
Picture::SetDIBWidthAndHeight()
{
  BITMAPINFOHEADER bih;
  GetDibInfo(GetCF_DIB(), &bih);
  if (bih.biWidth > INT_MAX) 
  {
    dib_width = INT_MAX;
  }
  else 
  {
    dib_width = (int)bih.biWidth;
  }
  if (bih.biHeight > INT_MAX) 
  {
    dib_height = INT_MAX;
  }
  else 
  {
    dib_height = (int)bih.biHeight;
  }
}

// clear object
inline void 
Picture::Clear()
{
  vm_dib = 0;
  dib_size = 0;
  dib_width = 0;
  dib_height = 0;
  cache = 0;
  cache_width = 0;
  cache_height = 0;
}

Picture::Picture(HANDLE data, WORD format)
{
  if (format == CF_BITMAP) 
  {
    data = Picture::CreateDIB((HBITMAP)data);
  }
#ifndef NDEBUG
  else if (format != CF_DIB) 
  {
    assert(False);
  }
#endif
  Clear();
  if (data) 
  {
    dib_size = ::GlobalSize(data);
    if ((vm_dib = VMem::CopyHandle(data)) != 0) 
    {
      SetDIBWidthAndHeight();      
    }
  }
  if (format == CF_BITMAP) 
  {
    ::GlobalFree(data);
  }
}

// constructor for duplicate
Picture::Picture(Picture* pic)
{
  Clear();
  if (pic->vm_dib) 
  {
    if ((vm_dib = VMem::Duplicate(pic->vm_dib)) != 0) 
    {
      dib_size = pic->dib_size;
      dib_width = pic->dib_width;
      dib_height = pic->dib_height;
    }	 
  }
}

// constructor
Picture::Picture(VMem* vm, udword size)
{
  Clear();
  if ((vm_dib = VMem::Duplicate(vm)) != 0) 
  {
    dib_size = size;      
    SetDIBWidthAndHeight();
  }
}

#ifndef _WIN32
static bool NEAR
HugeRead(int hFile, LPSTR lpBuffer, DWORD dwSize)
{
#define BYTES_PER_READ  32767
#ifdef _WIN32
  char* lpInBuf = lpBuffer;
#else /* _WIN32 */
  char huge* lpInBuf = (char huge*) lpBuffer;
#endif /* _WIN32 */
  int       nBytes;
  
  while (dwSize)
  {
    nBytes = (int) (dwSize > (DWORD) BYTES_PER_READ ? BYTES_PER_READ : 
		    LOWORD(dwSize));
    if (_lread(hFile, (LPSTR) lpInBuf, nBytes) != (WORD) nBytes)
    {
      return False;
    }
    dwSize  -= nBytes;
    lpInBuf += nBytes;
  }
  return True;
}
#endif /* _WIN32 */

// read file
Picture::Picture(char* file_name)
{
  Clear();
  
#ifdef _WIN32
  int hFile = open(file_name, O_RDONLY | O_BINARY);
#else /* _WIN32 */
  OFSTRUCT open_buff;
  int hFile = OpenFile(file_name, &open_buff, OF_READ);
#endif /* _WIN32 */
  if (hFile == -1)
  {
    // file open error
    return;
  }
  // get length of DIB in bytes for use when reading
  BITMAPFILEHEADER   bmfHeader;
  DWORD              dwBitsSize;
  
  dwBitsSize = ::filelength(hFile);
  
#define DIB_HEADER_MARKER	((WORD) ('M' << 8) | 'B')
  
  // Go read the DIB file header and check if it's valid.
#ifdef _WIN32
#ifdef CW
  if ((read(hFile, (char*) &bmfHeader, (int)sizeof(bmfHeader)) != sizeof(bmfHeader)) ||
#else
  if ((read(hFile, (void*) &bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader)) ||
#endif
#else /* _WIN32 */
  if ((::_lread(hFile, (LPSTR) &bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader)) ||
#endif /* _WIN32 */
      (bmfHeader.bfType != DIB_HEADER_MARKER))
  {
    // header error
#ifdef _WIN32
    close(hFile);
#else /* _WIN32 */
    ::_lclose(hFile);
#endif /* _WIN32 */
    return;
  }
  
  // Allocate memory for DIB
  vm_dib = VMem::Make(dwBitsSize - sizeof(bmfHeader));
  
  void* mem = vm_dib->GetStuff();

  if (mem == 0)
  {
    // memory error
    delete vm_dib;
#ifdef _WIN32
    close(hFile);
#else /* _WIN32 */
    ::_lclose(hFile);
#endif /* _WIN32 */
    return;
  }
  
  // Go read the bits.
#ifdef _WIN32
  int size = dwBitsSize - sizeof(bmfHeader);
  if (read(hFile, (char*)mem, size) != size)
#else /* _WIN32 */
  if (!HugeRead(hFile, (char*)mem, dwBitsSize - sizeof(bmfHeader)))
#endif /* _WIN32 */
  {
    delete vm_dib;
    vm_dib = 0;
#ifdef _WIN32
    close(hFile);
#else /* _WIN32 */
    ::_lclose(hFile);
#endif /* _WIN32 */
    return;
  }
  
  dib_size = dwBitsSize - sizeof(bmfHeader);
  SetDIBWidthAndHeight();
#ifdef _WIN32
  close(hFile);
#else /* _WIN32 */
  ::_lclose(hFile);
#endif /* _WIN32 */
}

Picture::~Picture()
{
  delete vm_dib;
  RemoveCache();
}

// add cache
void 
Picture::AddCache()
{
  cache_pic->Push(this);
  if (++ cache_num > cache_picture_max) 
  {
    // free old cache
    Picture* old = cache_pic->Eject();
    -- cache_num;
    if (old->cache) 
    {
      ::DeleteObject(old->cache);
      old->cache = 0;
    }
  }
}

// remove cache
void 
Picture::RemoveCache()
{
  if (cache) 
  {
    cache_pic->Delete(this);
    -- cache_num;
    ::DeleteObject(cache);
    cache = 0;
  }
}

// change cache priority
void 
Picture::CacheUsed()
{
  // move to list top
  cache_pic->Delete(this);
  cache_pic->Push(this);
}

// cache hit check
bool 
Picture::CacheHitCheck(int width, int height)
{
  if (!cache ||
      (width != cache_width) || 
      (height != cache_height)) 
  {
    return False;
  }
  return True;
}

// display
void 
Picture::Redisplay(VDisplay* vdsp, Rect& rec)
{
  if (!IsValid()) 
  {
    return;
  }
  
  // draw
  HDC hDC = vdsp->GetDC();
  RECT r = vdsp->ItoWR(rec);
  BOOL res = True;
  if (vdsp->IsPrinter()) 
  {
    //
    // printer
    //
    res = ::StretchDibBlt(hDC, r.left, r.top, 
			  r.right - r.left, r.bottom - r.top, 
			  GetCF_DIB(), 0, 0, dib_width, dib_height, SRCCOPY);
  }
  else if (CacheHitCheck(r.right - r.left, r.bottom - r.top)) 
  {
    //
    // cache hit!
    //
    HDC hMem = ::CreateCompatibleDC(hDC);
    HBITMAP hOld = (HBITMAP)::SelectObject(hMem, cache);
    res = ::BitBlt(hDC, r.left, r.top, r.right - r.left, r.bottom - r.top,
		    hMem, 0, 0, SRCCOPY);
    ::SelectObject(hMem, hOld);
    ::DeleteDC(hMem);
  }
  else 
  {
    if (cache) 
    {
      // clear cache
      RemoveCache();
    }
    cache_width = r.right - r.left;
    cache_height = r.bottom - r.top;
    cache = ::CreateCompatibleBitmap(hDC, cache_width, cache_height);
    if (cache) 
    {
      //
      // make new cache data
      //
      HDC hMem = ::CreateCompatibleDC(hDC);
      HBITMAP hOld = (HBITMAP)::SelectObject(hMem, cache);
      res = ::StretchDibBlt(hMem, 0, 0, cache_width, cache_height, 
			    GetCF_DIB(), 0, 0, 
			    dib_width, dib_height, SRCCOPY);
      if (res) 
      {
	res = ::BitBlt(hDC, r.left, r.top, cache_width, cache_height, 
			hMem, 0, 0, SRCCOPY);
      }
      ::SelectObject(hMem, hOld);
      ::DeleteDC(hMem);
      if (res) 
      {
	AddCache();
      }
      else 
      {
	::DeleteObject(cache);
	cache = 0;
      }
    }
    if (!cache) 
    {
      //
      // no cache memory
      //
      res = ::StretchDibBlt(hDC, r.left, r.top, 
			    r.right - r.left, r.bottom - r.top, 
			    GetCF_DIB(), 0, 0, 
			    dib_width, dib_height, SRCCOPY);
    }
  }
  if (!res) 
  {
    // in case of GDI paint failure
    ::FillRect(hDC, &r, (HBRUSH)::GetStockObject(WHITE_BRUSH));
  }
}

// copy to clipboard
void 
Picture::CopyToClipboard()
{
  if (!IsValid()) 
  {
    return;
  }
  
  HANDLE paste_dib = 0;
  paste_dib = vm_dib->CopyToHandle();
  HBITMAP paste_bmp = 0;
  if (paste_dib) 
  {
    paste_bmp = CreateBitMap(paste_dib);
  }
  else 
  {
    // can't create data for clipboard
    return;
  }
  if (::OpenClipboard(main_window_handle)) 
  {
    PClipboard::SetOpenFlag(True);
    ::EmptyClipboard();
    ::SetClipboardData(CF_DIB, paste_dib);
    if (paste_bmp) 
    {
      ::SetClipboardData(CF_BITMAP, paste_bmp);
    }
    ::CloseClipboard();
    PClipboard::SetOpenFlag(False);
  }
}

Picture* 
Picture::GetClipBoardPicture()
{
  if (!::OpenClipboard(main_window_handle))
  {
    return 0;
  }
  PClipboard::SetOpenFlag(True);
  
  Picture* pic = 0;
  HANDLE h = ::GetClipboardData(CF_DIB);
  if (h) 
  {
    pic = new Picture(h, CF_DIB);
  }
  else 
  {
    h = ::GetClipboardData(CF_BITMAP);
    if (h) 
    {
      pic = new Picture(h, CF_BITMAP);
    }
  }
  if ((pic != 0) && (!pic->IsValid())) 
  {
    delete pic;
    pic = 0;
  }
  ::CloseClipboard();
  PClipboard::SetOpenFlag(False);
  return pic;
}

//
// static methods
//
#if 0
// copy clipboard bitmap
HBITMAP 
Picture::CopyClipBoardBitMap(HWND hWnd)
{
  // get clipboard data
  ::OpenClipboard(hWnd);
  
  HBITMAP h_clip_board = ::GetClipboardData(CF_BITMAP);
  if (h_clip_board == 0) 
  {
    return 0;
  }
  HBITMAP hBmp = CopyBitMap(h_clip_board);
  
  ::CloseClipboard();
  return hBmp;
}
#endif

#if 0
// copy clipboard DIB
HANDLE 
Picture::CopyClipBoardDIB(HWND hWnd)
{
  ::OpenClipboard(hWnd);
  
  HBITMAP h_clip_board = ::GetClipboardData(CF_DIB);
  if (h_clip_board == 0) 
  {
    return 0;
  }
  
  HANDLE dib = CopyHandle(h_clip_board);
  
  ::CloseClipboard();
  return dib;
}
#endif

#if 0
// copy bitmap
HBITMAP 
Picture::CopyBitMap(HBITMAP src)
{
  HDC hdc_mem = ::CreateCompatibleDC(Default_View->GetDC());
  HDC hdc_mem2 = ::CreateCompatibleDC(Default_View->GetDC());
  
  ::SelectObject(hdc_mem, src);
  BITMAP bm;
  ::GetObject(src, sizeof(BITMAP), (LPSTR)&bm);
  HBITMAP hBmp = ::CreateBitmapIndirect(&bm);
  ::SelectObject(hdc_mem2, hBmp);
  ::BitBlt(hdc_mem2, 0, 0, bm.bmWidth, bm.bmHeight, 
            hdc_mem, 0, 0, SRCCOPY);
  ::DeleteDC(hdc_mem2);
  ::DeleteDC(hdc_mem);
  
  return hBmp;
}
#endif

// copy DIB
HANDLE
Picture::CopyDIB(HANDLE dib)
{
  return ::CopyHandle(dib);
}

// create DIB
HANDLE
Picture::CreateDIB(HBITMAP bmp)
{
  if (!bmp)
  {
    return NULL;
  }
  HPALETTE hpal = (HPALETTE)::GetStockObject(DEFAULT_PALETTE);
  BITMAP bm;
  ::GetObject(bmp,sizeof(bm), (LPSTR)&bm);
  WORD biBits =  bm.bmPlanes * bm.bmBitsPixel;
  BITMAPINFOHEADER bi;
  bi.biSize = sizeof(BITMAPINFOHEADER);
  bi.biWidth = bm.bmWidth;
  bi.biHeight = bm.bmHeight;
  bi.biPlanes = 1;
  bi.biBitCount = biBits;
  bi.biCompression = BI_RGB;
  bi.biSizeImage = 0;
  bi.biXPelsPerMeter = 0;
  bi.biYPelsPerMeter = 0;
  bi.biClrUsed = 0;
  bi.biClrImportant = 0;
  DWORD dwLen  = bi.biSize + DibPaletteSize(&bi);
  HDC hdc = ::GetDC(NULL);
  hpal = ::SelectPalette(hdc, hpal, FALSE);
  ::RealizePalette(hdc);
  HANDLE hdib = ::GlobalAlloc(GHND,dwLen);
  if (!hdib)
  {
    ::SelectPalette(hdc,hpal,FALSE);
    ::ReleaseDC(NULL,hdc);
    return NULL;
  }
  BITMAPINFOHEADER FAR *lpbi = (BITMAPINFOHEADER FAR *) GlobalLock(hdib);
  *lpbi = bi;
  ::GetDIBits(hdc, bmp, 0, (WORD)bi.biHeight, NULL, (LPBITMAPINFO)lpbi, DIB_RGB_COLORS);
  bi = *lpbi;
  ::GlobalUnlock(hdib);
  if (bi.biSizeImage == 0)
  {
    bi.biSizeImage = WIDTHBYTES((DWORD)bm.bmWidth * biBits) * bm.bmHeight;
  }
  dwLen = bi.biSize + DibPaletteSize(&bi) + bi.biSizeImage;
  HANDLE h;
  if ((h = (HANDLE)::GlobalReAlloc(hdib,dwLen,0)) != 0)
  {
    hdib = h;
  }
  else
  {
    ::GlobalFree(hdib);
    hdib = NULL;
    ::SelectPalette(hdc,hpal,FALSE);
    ::ReleaseDC(NULL,hdc);
    return hdib;
  }
  lpbi = (BITMAPINFOHEADER FAR *) GlobalLock(hdib);
  if (::GetDIBits(hdc, bmp, 0, (WORD)bi.biHeight,
		  (LPSTR)lpbi + (WORD)lpbi->biSize + DibPaletteSize(lpbi),
		  (LPBITMAPINFO)lpbi, DIB_RGB_COLORS) == 0)
  {
    ::GlobalUnlock(hdib);
    hdib = NULL;
    ::SelectPalette(hdc,hpal,FALSE);
    ::ReleaseDC(NULL,hdc);
    return NULL;
  }
  bi = *lpbi;
  ::GlobalUnlock(hdib);
  ::SelectPalette(hdc,hpal,FALSE);
  ::ReleaseDC(NULL,hdc);
  return hdib;
}

// create bitmap
HBITMAP 
Picture::CreateBitMap(HANDLE dib)
{
  if (!dib)
  {
    return NULL;
  }
  LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER)::GlobalLock(dib);
  if (!lpbi)
  {
    return NULL;
  }
  HDC hdc = ::GetDC(NULL);
  HBITMAP hbm;
  hbm = ::CreateDIBitmap(hdc,
			 (LPBITMAPINFOHEADER)lpbi,
			 (LONG)CBM_INIT,
			 (LPSTR)lpbi + (WORD) lpbi->biSize + DibPaletteSize(lpbi),
			 (LPBITMAPINFO)lpbi,
			 DIB_RGB_COLORS);
  ::ReleaseDC(NULL,hdc);
  ::GlobalUnlock(dib);
  return hbm;
}

// get dib width and height
void 
Picture::GetDIBWidthAndHeightCFDIB(void* cf_dib, Iunit& width, Iunit& height)
{
  BITMAPINFOHEADER bih;
  GetDibInfo(cf_dib, &bih);
  if (bih.biXPelsPerMeter == 0 || bih.biYPelsPerMeter == 0)
  {
    width = (Iunit) Default_View->ScaleLunitX((Dunit) bih.biWidth);
    height = (Iunit) Default_View->ScaleLunitY((Dunit) bih.biHeight);
  }
  else
  {
    WORD mm0_width  = (WORD) ((bih.biWidth * 10000L) / bih.biXPelsPerMeter);
    width  = mm0_to_iu(mm0_width);
    WORD mm0_height = (WORD) ((bih.biHeight * 10000L) / bih.biYPelsPerMeter);
    height = mm0_to_iu(mm0_height);
  }
}

void 
Picture::GetDIBWidthAndHeightDIB(HANDLE dib, Iunit& width, Iunit& height)
{
  void* cf_dib = ::GlobalLock(dib);
  if (cf_dib) 
  {
    GetDIBWidthAndHeightCFDIB(cf_dib, width, height);
  }
  else 
  {
    width = height = 0;
  }
  ::GlobalUnlock(dib);
}


//
// picture file read
//

Picture::FileCheck 
Picture::CheckFileConsistency(Picture::FileFormat ff, char* file_name)
{
  switch (ff)
  {
   case BMP:
    return CheckBMPFileConsistency(file_name);

   case RGBE:
    return CheckRGBEFileConsistency(file_name);
    
   default:
    return NotSupportFormatError;
  }
};

Picture::FileCheck
Picture::CheckBMPFileConsistency(char* file_name)
{
  FileCheck fc = FileOk;
  File f(file_name);
  if (f.ErrorP())
  {
    return OpenError;
  }
  
  // get length of DIB in bytes for use when reading
  DWORD size  = ::filelength(f.GetFileHandle());
  
  // Go read the DIB file header and check if it's valid.
  BITMAPFILEHEADER bmfHeader;
#ifdef _WIN32
  if ((read(f.GetFileHandle(), (LPSTR) &bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader)) ||
#else /* _WIN32 */
  if ((::_lread(f.GetFileHandle(), (LPSTR) &bmfHeader, sizeof(bmfHeader)) != sizeof(bmfHeader)) ||
#endif /* _WIN32 */
      (bmfHeader.bfType != DIB_HEADER_MARKER))
  {
    // header error
    fc = FormatError;
  }
  else if (bmfHeader.bfSize != size)
  {
    // size error
    fc = FileSizeError;
  }
  return fc;
}

Picture::FileCheck
Picture::CheckRGBEFileConsistency(char* file_name)
{
  const udword rgbe_file_size = 32000; // RGBE each file size
  uword file_name_size = strlen(file_name); // for the time beeing
  FileCheck fc = FileOk;
  static char rgbe_suffix [] = "RGBE";
  file_name[file_name_size - 1] = '1';
  for (uword i = 0; i < 4; i++)
  {
    file_name[file_name_size - 2] = rgbe_suffix[i];
    File f(file_name);
    if (f.ErrorP())
    {
      fc = OpenError;
    }
    else 
    {
      udword size  = ::filelength(f.GetFileHandle());
      if (size != rgbe_file_size)
      {
	fc = FileSizeError;
      }
    }
    if (fc != FileOk)
    {
      break;
    }
  }
  return fc;
}
