// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pime.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of PIME class

#include "pword.h"
extern "C"
{
#include <ctype.h>
#include <dde.h>
#include <stdlib.h>
#ifdef BW3
#include <winnls.h>
#else /* BW3 */
#include "windows/winnls.h"
#endif /* BW3 */
}
#include "pime.h"
#include "rect.h"
#include "screen.h"
#include "view.h"

#ifdef BW3_IMM
// ============================================================
// new PIME for 32-bit Windows

#include <imm.h>

static HIMC hIMC = 0;
static HWND hWnd = 0;
static bool push_pop_status_p = false;
static bool on_when_lost_focus_p = false;
static bool first_focus_call_p = true;
static int system_font_ascent = 0;
static int ignore_font = 0;
static HFONT old_font = 0;

// ------------------------------------------------------------
// setup
void
PIME::Create(HWND hWnd)
{
  if (!hIMC)
  {
    hIMC = ::ImmGetContext(hWnd);
    ::hWnd = hWnd;

    TEXTMETRIC tm;
    {
      HFONT old_font = (HFONT)SelectObject(Screen::dc, GetStockObject(SYSTEM_FONT));
      GetTextMetrics(Screen::dc, &tm);
      SelectObject(Screen::dc, old_font);
    }
    system_font_ascent = tm.tmAscent;
  }
}

void
PIME::Destroy()
{
  if (hIMC)
  {
    ::ImmReleaseContext(hWnd, hIMC);
    hIMC = 0;
  }
}

// ------------------------------------------------------------
// IME status
bool
PIME::GetOpen()
{
  return ::ImmGetOpenStatus(hIMC) != 0;
}

void
PIME::SetOpen(bool status)
{
  ::ImmSetOpenStatus(hIMC, (BOOL)status);
}

void
PIME::SetClosed()
{
  SetOpen(false);
}

void
PIME::PopOpenStatus()
{
  SetOpen(push_pop_status_p);
}

void
PIME::PushOpenStatus()
{
  push_pop_status_p = GetOpen();
}

int
PIME::GetPending()
{
  return 0;	// dummy
}

void
PIME::KillFocus()
{
  SetFont(0);
  if (!first_focus_call_p)
  {
    on_when_lost_focus_p = GetOpen();
    SetClosed();
  }
}

void
PIME::SetFocus()
{
  if (first_focus_call_p)
  {
    first_focus_call_p = false;
  }
  else 
  {
    SetOpen(on_when_lost_focus_p);
  }
}

// ------------------------------------------------------------
// Font
HFONT
PIME::SetFont(HFONT hFont)
{
  if (ignore_font)
  {
    return 0;
  }
  if (hFont)
  {
    LOGFONT lf;
    if (::GetObject(hFont, sizeof(LOGFONT), &lf))
    {
      if (::ImmSetCompositionFont(hIMC, &lf))
      {
	// success
      }
    }
  }
  if (old_font)
  {
    BOOL success = ::DeleteObject(old_font);
  }
  old_font = hFont;
  return hFont;	// dummy
}

void
PIME::SetIgnoreFont(int ignore)
{
  SetFont(0);
  ignore_font = ignore;
}

int
PIME::GetIgnoreFont()
{
  return ignore_font;
}

// ------------------------------------------------------------
// uses the little black window at the bottom of the screen
void
PIME::DefaultConvertWin()
{
  // nothing for IMM (?)
}

// ------------------------------------------------------------
// starts at the first coordinate for the first line, and uses
// the rectangle specified by the remaining arguments for the
// remaining lines
void
PIME::RectConvertWin(HWND hWnd2, Drect* dr, Dpoint* dp, int ascent, int tategaki_p)
{
  Drect clip_dr[1];
  Dpoint caret_dp[1];
  *clip_dr = *dr;
  *caret_dp = *dp;

  if (ignore_font)
  {
    ascent = system_font_ascent;
  }
  if (tategaki_p)
  {
    POINT_X(caret_dp) += ascent;
  }
  else
  {
    POINT_Y(caret_dp) -= ascent;
  }

  SET_MIN(RECT_TOP_X(clip_dr), POINT_X(caret_dp));
  SET_MIN(RECT_TOP_Y(clip_dr), POINT_Y(caret_dp));
  SET_MAX(RECT_BOT_X(clip_dr), POINT_X(caret_dp));
  SET_MAX(RECT_BOT_Y(clip_dr), POINT_Y(caret_dp));

  // see COMPOSITIONFORM SDK documentation
  COMPOSITIONFORM cf;
  cf.dwStyle = CFS_RECT;
  cf.ptCurrentPos.x = POINT_X(caret_dp);
  cf.ptCurrentPos.y = POINT_Y(caret_dp);
  cf.rcArea.left = RECT_TOP_X(clip_dr);
  cf.rcArea.top = RECT_TOP_Y(clip_dr);
  cf.rcArea.right = RECT_BOT_X(clip_dr);
  cf.rcArea.bottom = RECT_BOT_Y(clip_dr);

  ::ImmSetCompositionWindow(hIMC, &cf);
}

// ------------------------------------------------------------
// DDE related.  Certain IME's communication with the application
// via DDE.  This routine handles such messages, namely
// WM_DDE_ACK, WM_DDE_TERMINATE, WM_DDE_DATA
int
PIME::DDEDispatch(unsigned, WORD, LONG)
{
  // noting for IMM
  return 0;	// dummy
}

// ------------------------------------------------------------
// register
void
PIME::WordRegister(char* moji, char* yomi)
{
  HKL hkl = ::GetKeyboardLayout(0L);

  // I couldn't register word here without dialog. Becauls 
  // ImmRegisterWord needs IME specific hinshi information.
  // So I call register word dialog with ImmConfigureIME. (kudou)
  REGISTERWORD rw;
  rw.lpReading = yomi;
  rw.lpWord = moji;
  ::ImmConfigureIME(hkl, hWnd, IME_CONFIG_REGISTERWORD, &rw);
}

#else /* BW3_IMM */
// ============================================================
// old PIME for 16-bit Windows

int ime_error;

ATOM	PIME::aMode;				
ATOM	PIME::aIsOpen;	
ATOM	PIME::aIme;	
ATOM    PIME::aImeCtl;

LONG	PIME::lIMEParam;

int	PIME::cfIme = 0;
int     PIME::was_open = 0;
HFONT   PIME::old_font = 0;
int     PIME::ignore_font = 0;
int     PIME::system_font_ascent = 0;

HANDLE PIME::hIme = 0;
IMESTRUCT* PIME::imestruct = 0;
HANDLE PIME::vhIme = 0;				
DDEPOKE* PIME::ddepoke = 0;
HANDLE PIME::hIMEP = 0;
HWND PIME::hWnd = 0;

int	PIME::wIMEMode = 0;	
int	PIME::wIMEOpen = 0;

HWND	PIME::hWndServer = NULL;	
int	PIME::fConversation = NULL;	
int	PIME::fInitializing = FALSE;	
char	PIME::szMode[16];
char	PIME::szOpen[8];		

int     PIME::created = 0;
int     PIME::error = 0;

int     PIME::on_when_lost_focus = 0;
int     PIME::first_focus_call = 1;


#define CHECK if (!created) return

// find out if IME exists.  

int
PIME::Exists()
{
  return(1);
//  IMEPRO fuck;
//  return IMPQueryIME(&fuck);
}


// DefaultConvertWin, RectConvertWin -- // set up conversion window of
// various sorts

// set up default conversion window for IME
void
PIME::DefaultConvertWin()
{
  CHECK;
#ifdef _WIN32
  imestruct->fnc = IME_SETCONVERSIONWINDOW;
#else /* _WIN32 */
  imestruct->fnc = IME_MOVECONVERTWINDOW;
#endif /* _WIN32 */
  imestruct->wParam = MCW_DEFAULT;
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */
}

// set up conversion window as rectangle inside window
void
PIME::RectConvertWin(HWND hWnd2,
		      Drect* dr, Dpoint* dp, int ascent, int tategakip)
{
  CHECK;
#ifdef _WIN32
  imestruct->fnc = IME_SETCONVERSIONWINDOW;
#else /* _WIN32 */
  imestruct->fnc = IME_MOVECONVERTWINDOW;	// set function
#endif /* _WIN32 */
  
  Drect clip_dr[1];
  Dpoint caret_dp[1];
  *clip_dr = *dr;
  *caret_dp = *dp;
  if (ignore_font)
  {
    ascent = system_font_ascent;
  }

  if (tategakip)
  {
    imestruct->wParam = MCW_WINDOW | MCW_RECT | MCW_VERTICAL;
    POINT_X(caret_dp) += ascent;
  }
  else
  {
    imestruct->wParam = MCW_WINDOW | MCW_RECT;
    POINT_Y(caret_dp) -= ascent;
  }

  SET_MIN(RECT_TOP_X(clip_dr), POINT_X(caret_dp));
  SET_MIN(RECT_TOP_Y(clip_dr), POINT_Y(caret_dp));
  SET_MAX(RECT_BOT_X(clip_dr), POINT_X(caret_dp));
  SET_MAX(RECT_BOT_Y(clip_dr), POINT_Y(caret_dp));

  imestruct->lParam1 = MAKELONG(POINT_X(caret_dp), POINT_Y(caret_dp));
  imestruct->lParam2 = MAKELONG(RECT_TOP_X(clip_dr), RECT_TOP_Y(clip_dr));
  imestruct->lParam3 = MAKELONG(RECT_BOT_X(clip_dr), RECT_BOT_Y(clip_dr));
  
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd2, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd2, lIMEParam);
#endif /* _WIN32 */
  ime_error = imestruct->wParam;
}

// SetMode, GetMode -- get and set conversion mode

void 
PIME::SetMode(WORD wParam)
// wParam is logical or of mode flags like IME_MODE_ROMAN
{
  CHECK;
  if (!hWndServer) 
  {
    imestruct->fnc = IME_SET_MODE;
    imestruct->wParam = wParam;
#ifdef _WIN32
    ::SendIMEMessageEx(hWnd,lIMEParam);
#else /* _WIN32 */
    ::SendIMEMessage(hWnd,lIMEParam);
#endif /* _WIN32 */
  }
  else 
  {
    {
      LPIMESTRUCT lpIme = (LPIMESTRUCT)(ddepoke->Value);
      ddepoke->fRelease=0;
      ddepoke->cfFormat=cfIme;

      lpIme->fnc = IME_SET_MODE;
      lpIme->wParam = wParam;
      ::PostMessage(hWndServer, WM_DDE_POKE, (WPARAM_T)hWnd, MAKELONG(vhIme, aIme));
    }
  }
  DDERequest(aMode);
}


int
PIME::GetMode()
{
  CHECK 0;
#ifdef _WIN32
  imestruct->fnc = IME_GETCONVERSIONMODE;
#else /* _WIN32 */
  imestruct->fnc = IME_GET_MODE;
#endif /* _WIN32 */
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */
  return imestruct->wParam;
}

void	
PIME::SendKey(WORD key)
{
  CHECK;
#ifdef _WIN32
  imestruct->fnc = IME_SENDVKEY;
#else /* _WIN32 */
  imestruct->fnc = IME_SENDKEY; 
#endif /* _WIN32 */
  imestruct->wParam = key;
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd,lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd,lIMEParam);
#endif /* _WIN32 */
}


// WordRegister -- call the IME to enter a word in its dictionary
// either moji or yomi or both may be NULL
void 
PIME::WordRegister(char* moji, char* yomi)
{
  CHECK;
  HANDLE hmoji=0, hyomi=0;
  if (moji)
  {
    int moji_len = strlen(moji)+1;
    hmoji = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, moji_len);
    char* moji_addr = (char*)::GlobalLock(hmoji);
    huge_memcpy(moji_addr, 0, moji, 0, moji_len);
    ::GlobalUnlock(hmoji);
  }
  if (yomi)
  {
    int yomi_len = strlen(yomi)+1;
    hyomi = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, yomi_len);
    char* yomi_addr = (char*)::GlobalLock(hyomi);
    huge_memcpy(yomi_addr, 0, yomi, 0, yomi_len);
    ::GlobalUnlock(hyomi);
  }

#ifdef _WIN32
  imestruct->fnc = IME_ENTERWORDREGISTERMODE;
#else /* _WIN32 */
  imestruct->fnc = IME_WORDREGISTER;
#endif /* _WIN32 */
  imestruct->lParam1 = (LPARAM_T)hmoji;
  imestruct->lParam2 = (LPARAM_T)hyomi;
  imestruct->lParam3 = (LPARAM_T)0;

#ifdef _WIN32
  ::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */

  if (moji)
  {
    ::GlobalFree(hmoji);
  }
  if (yomi)
  {
    ::GlobalFree(hyomi);
  }
}

void
PIME::WindowUpdate(int on_off)
{
#ifdef _WIN32
  // TODO:
  // This function seems to be abolished on Win32.
#define IME_WINDOWUPDATE 0x16
  imestruct->fnc = IME_WINDOWUPDATE;
#else /* _WIN32 */
  imestruct->fnc = IME_WINDOWUPDATE;
#endif /* _WIN32 */
  imestruct->wParam = on_off;
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */
}

// SetOpen, GetOpen -- set and query IME open status

void	
PIME::SetOpen(int open_status)
{
  CHECK;
  imestruct->fnc = IME_SETOPEN; 
  imestruct->wParam = wIMEOpen = open_status;
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */
}


WORD
PIME::GetOpenAndPending(int& pending)
{
  CHECK 0;
  imestruct->fnc = IME_GETOPEN;
  
#if (!defined(NDEBUG))
#ifdef _WIN32
  int err = !::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  int err = !::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */
  err = err;
#else
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd,lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd,lIMEParam);
#endif /* _WIN32 */
#endif

  pending = imestruct->wCount;
  return imestruct->wParam;
}


WORD
PIME::GetOpen()
{
  CHECK 0;
  int pending;
  return GetOpenAndPending(pending);
}

int
PIME::GetPending()
{
  CHECK 0;
  int pending;
  return GetOpenAndPending(pending) ? pending : 0;
}

int
PIME::GetCreated()
{
  return created;
}

// SetFont -- set font to be used by IME

HFONT
PIME::SetFont(HFONT hFont)
{
  if (!created || ignore_font)
  {
    if (hFont)
    {
      BOOL success = ::DeleteObject(hFont);
      if (!success)
      {
#if (!defined(NDEBUG))
	syserr("PIME::SetFont--invalid or in-use font handle");
#endif
      }
    }
    return 0;
  }

#ifdef _WIN32
  // TODO:
  // IME_SETFONT function seems to be abolished on Win32.
  // IME_SETCONVERSIONFONTEX may be replacement function.
#if 1
  imestruct->fnc	= IME_SETCONVERSIONFONTEX;
#else
#define IME_SETFONT 0x12
  imestruct->fnc	= IME_SETFONT;
#endif
#else /* _WIN32 */
  imestruct->fnc	= IME_SETFONT;
#endif /* _WIN32 */
  imestruct->wParam 	= (WPARAM_T)hFont;

#ifdef _WIN32
  HFONT result = (HFONT)::SendIMEMessageEx(hWnd, lIMEParam);
#else /* _WIN32 */
  HFONT result = (HFONT)::SendIMEMessage(hWnd, lIMEParam);
#endif /* _WIN32 */	

  if (old_font != 0)
  {
    BOOL success = ::DeleteObject(old_font);
    if (!success)
    {
#if (!defined(NDEBUG))
      syserr("PIME::SetFont--invalid or in-use font handle");
#endif
    }
  }
  old_font = hFont;

  return result;
}

void
PIME::SetFocus()
{
  if (first_focus_call)
  {
    first_focus_call = 0;
  }
  else 
  {
    SetOpen(on_when_lost_focus);
  }
}

void 
PIME::KillFocus()
{
  SetFont(0);
  if (!first_focus_call)
  {
    on_when_lost_focus = GetOpen();
    SetClosed();
  }
}

void
PIME::SetIgnoreFont(int ignore)
{
  SetFont(0);
  ignore_font = ignore;
}

int 
PIME::GetIgnoreFont()
{
  return ignore_font;
}


// DDERequest -- request DDE advice about IME

int
PIME::DDERequest(ATOM aItem)
{
  CHECK 0;
  if (!fConversation)
  {
    return FALSE;
  }
  ::PostMessage(hWndServer, WM_DDE_REQUEST, (WPARAM_T)hWnd, MAKELONG(CF_TEXT,aItem));
  return TRUE;
}


int
PIME::DDEStartAdvise(ATOM aItem)
{
  CHECK 0;

  HANDLE hMem;

  if (!fConversation)
  {
    return FALSE;
  }

  hMem = ::GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, 4L);
  DDELN* ddeln = (DDELN*) ::GlobalLock(hMem);
  if (ddeln == 0)
  {
    return 0;
  }
  ddeln->fRelease = 0;
  ddeln->fDeferUpd = 0;
  ddeln->fAckReq = 0;
  ddeln->cfFormat = CF_TEXT;
  ::GlobalUnlock(hMem);
  ::PostMessage(hWndServer, WM_DDE_ADVISE, (WPARAM_T)hWnd, MAKELONG(hMem,aItem));

  return TRUE;
}


int PIME::DDEEndAdvise(ATOM aItem)
{
  CHECK 0;

  if (!fConversation)
  {
    return FALSE;
  }
  
  ::PostMessage(hWndServer, WM_DDE_UNADVISE, (WPARAM_T)hWnd, MAKELONG(NULL,aItem));
  
  return TRUE;
}


// DDEProcess - process a message from DDE

void 
PIME::DDEProcess(HWND hWndS, ATOM aData, HANDLE hData)
{
  CHECK;

  int fRelease;

  if (hWndS!=hWndServer)
  {
    return;
  }

  DDEUP* lpUp = (DDEUP*) ::GlobalLock(hData);
  fRelease=(int)lpUp->fRelease;
  LPSTR lpch=(LPSTR)lpUp->rgb;

  // it's a mode message!

  if (aData==aMode)
  {
    lstrcpy((LPSTR)szMode, lpch);
    wIMEMode = GetMode();
  }

  // no, it's an open status message!!
  
  else if (aData == aIsOpen) 
  {
    LPSTR lpch = (LPSTR)lpUp->rgb;
    wIMEOpen = *lpch=='1';
  }
  
  ::GlobalUnlock(hData);
  if (fRelease)
  {
    ::GlobalFree(hData);
  }
}


// DDEAck - process a DDE ack

void
PIME::DDEAck(HWND hWndS, ATOM aCompare, ATOM /*aServer*/)
{
  CHECK;
  
  if (fInitializing && aCompare==aImeCtl) 
  {
    if (fConversation) 	// already conversing with someone else!
    {
      ::PostMessage(hWndS, WM_DDE_TERMINATE, (WPARAM_T)hWnd, 0L);
    }
    else 
    {
      hWndServer = hWndS;		// remember our server
      fConversation = TRUE;
    }
  }
}


// Create, Destroy -- set up and shut down IME

#ifdef _WIN32
// Win32 version <winnls.h> doesn't have a IMEPRO definition.
typedef struct _tagDATETIME {
    WORD        year;
    WORD        month;
    WORD        day;
    WORD        hour;
    WORD        min;
    WORD        sec;
} DATETIME;

typedef struct _tagIMEPRO {
    HWND        hWnd;
    DATETIME    InstDate;
    UINT        wVersion;
    BYTE        szDescription[50];
    BYTE        szName[80];
    BYTE        szOptions[30];
} IMEPRO;
#endif /* _WIN32 */
void 
PIME::Create(HWND hWnd)
{
  if (!Exists())
  {
    return;
  }
  
  PIME::hWnd    = hWnd;
  
  hIme 		= ::GlobalAlloc(GHND, (LONG)sizeof(IMESTRUCT));
  lIMEParam 	= MAKELONG(hIme,0);
  imestruct     = (LPIMESTRUCT) ::GlobalLock(hIme);

  hIMEP 	= GlobalAlloc(GHND, (LONG)sizeof(IMEPRO));

  aMode		= GlobalAddAtom((LPSTR)"MODE");
  aIsOpen	= GlobalAddAtom((LPSTR)"ISOPEN");
  aIme		= GlobalAddAtom((LPSTR)"IMECMD");

  cfIme 	= RegisterClipboardFormat((LPSTR)"IMECMD");

  vhIme = ::GlobalAlloc
  (
   GMEM_ZEROINIT|GMEM_MOVEABLE|GMEM_DDESHARE, 
   4L+(LONG)sizeof(IMESTRUCT) 
 );
  ddepoke = (DDEPOKE*) ::GlobalLock(vhIme);

  created = 1;
  
  // see if any IME wants to talk to use over DDE
  {
    ATOM ime_control = GlobalAddAtom("IMECTL");
    fInitializing = TRUE;
    ::SendMessage((HWND) -1,
		   WM_DDE_INITIATE, (WPARAM_T)hWnd, MAKELONG(NULL, ime_control));
    GlobalDeleteAtom(ime_control);
  } 

  wIMEMode 	= GetMode();
  
  // get default font ascent
  {
    TEXTMETRIC tm;
    {
      HFONT old_font = (HFONT)SelectObject(Screen::dc, GetStockObject(SYSTEM_FONT));
      GetTextMetrics(Screen::dc, &tm);
      SelectObject(Screen::dc, old_font);
    }
    system_font_ascent = tm.tmAscent;
  }
}

void
PIME::Close()
{
  CHECK;
  if (fConversation) 
  {
    DDEEndAdvise(aIsOpen);
    ::PostMessage(hWndServer, WM_DDE_TERMINATE, (WPARAM_T)hWnd, 0L);
    hWndServer=NULL;
    fConversation=FALSE;
  }
}


void
PIME::Destroy(void)
{
  CHECK;
  created = 0;
  
  ::GlobalUnlock(hIme);
  ::GlobalFree(hIme);

  ::GlobalFree(hIMEP);

  GlobalDeleteAtom(aMode);
  GlobalDeleteAtom(aIsOpen);
  GlobalDeleteAtom(aIme);

  ::GlobalUnlock(vhIme);
  ::GlobalFree(vhIme);
  
  if (old_font)
  {
    BOOL success = ::DeleteObject(old_font);
    if (!success)
    {
#if (!defined(NDEBUG))
      syserr("PIME::SetFont--invalid or in-use font handle");
#endif
    }
    old_font = 0;
  }
}


// AdviseMode -- turn on and off advising of mode through DDE

void
PIME::AdviseMode(int on)
{
  CHECK;
  if (on)
  {
    DDEStartAdvise(aMode);
    DDERequest(aMode);
  }
  else
  {
    DDEEndAdvise(aMode);
  }
}


// Query -- find if the IME supports the "job" function

int
PIME::Query(int job)
{
  CHECK 0;
#ifdef _WIN32
  imestruct->fnc    = IME_GETIMECAPS;
#else /* _WIN32 */
  imestruct->fnc    = IME_QUERY;
#endif /* _WIN32 */
  imestruct->wParam = job;
#ifdef _WIN32
  ::SendIMEMessageEx(hWnd,lIMEParam);
#else /* _WIN32 */
  ::SendIMEMessage(hWnd,lIMEParam);
#endif /* _WIN32 */
  return imestruct->wParam ;
}


// Commander -- dispatch IME-related Windows messages

int
PIME::DDEDispatch(unsigned message, WORD wParam, LONG lParam)
{
  CHECK 0;

  switch (message)
  {
   case WM_DDE_ACK:
    DDEAck((HWND)wParam, (ATOM)HIWORD(lParam), (ATOM)LOWORD(lParam));
    break;

   case WM_DDE_DATA:
#ifdef _WIN32
     // TODO:
     // Data packing method might be changed on Win32.
     // So. Do nothing now.
#else /* _WIN32 */
    DDEProcess((HWND)wParam, (ATOM)HIWORD(lParam), (ATOM)LOWORD(lParam));
#endif /* _WIN32 */
    break;

   case WM_DDE_TERMINATE:
    Close();
    break;

   default:
    return 0;
  }
  return 1; // we handled it
}

#endif /* BW3_IMM */
