// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pmenus.h,v 3.6 1999/06/25 23:01:24 kudou Exp $
// Menu ID, MDI ID

#ifndef PMENUS_H
#define PMENUS_H

// 0x1000 - 0x10ff: MDI command
// 0x1100 - 0x23ff: Menu and command ID
// 0x3000 - 0x3fff: String ID

#define COMMAND_HIGH_CODE(wParam) (((unsigned short) wParam) >> 8)

#define MDI_HIGH_Command		0x10
#define IDM_HIGH_Again			0x11
#define IDM_HIGH_More			0x12
#define IDM_HIGH_Char			0x13
#define IDM_HIGH_Para			0x14
#define IDM_HIGH_Frame			0x15
#define IDM_HIGH_Page			0x16
#define IDM_HIGH_Nav			0x17
#define IDM_HIGH_CharSize		0x18
#ifdef BW2_ABBREV
#define IDM_HIGH_Abbrev			0x19
#endif /* BW2_ABBREV */
#define IDM_HIGH_FontE			0x1a
#define IDM_HIGH_FontJ			0x1b
#define IDM_HIGH_CharStyle		0x1c
#define IDM_HIGH_ParaStyle		0x1d
#define IDM_HIGH_Mark			0x1e
#define IDM_HIGH_Disp			0x1f
#define IDM_HIGH_File			0x20
#define IDM_HIGH_Edit			0x21
#define IDM_HIGH_Location		0x22
#define IDM_HIGH_Help			0x23
#define IDM_HIGH_Other			0x24
#ifdef BW3_RECENTOPEN
#define IDM_HIGH_RecentOpen		0x25
#endif /* BW3_RECENTOPEN */

#define MDI_BASE_Command		0x1000
#define IDM_BASE_Again			0x1100
#define IDM_BASE_More			0x1200
#define IDM_BASE_Char			0x1300
#define IDM_BASE_Para			0x1400
#define IDM_BASE_Frame			0x1500
#define IDM_BASE_Page			0x1600
#define IDM_BASE_Nav			0x1700
#define IDM_BASE_CharSize		0x1800
#ifdef BW2_ABBREV
#define IDM_BASE_Abbrev			0x1900
#endif /* BW2_ABBREV */
#define IDM_BASE_FontE			0x1a00
#define IDM_BASE_FontJ			0x1b00
#define IDM_BASE_CharStyle		0x1c00
#define IDM_BASE_ParaStyle		0x1d00
#define IDM_BASE_Mark			0x1e00
#define IDM_BASE_Disp			0x1f00
#define IDM_BASE_File			0x2000
#define IDM_BASE_Edit			0x2100
#define IDM_BASE_Location		0x2210
#define IDM_BASE_Help			0x2300
#define IDM_BASE_Other			0x2400

#define IDM_BASE			0x1100

#ifdef _WIN32
#define SYSMENU_BASE			0xf000
#endif /* _WIN32 */
// -------------------------------------------------------------------- //
// MDI child window
// -------------------------------------------------------------------- //
// MDI child Window identifiers must not conflict with any commands.
// Reserve a generous range for them.

#define MDI_FirstChild                  MDI_BASE_Command

// -------------------------------------------------------------------- //
// Again command
// -------------------------------------------------------------------- //

#define IDM_Again			(IDM_BASE_Again + 0x00)
#define IDM_AgainReverse		(IDM_BASE_Again + 0x01)

// -------------------------------------------------------------------- //
// More command
// -------------------------------------------------------------------- //

#ifdef BW2_ABBREV
#define IDM_MoreAbbrevs			(IDM_BASE_More + 0x00)
#endif /* BW2_ABBREV */
#define IDM_MoreFontsE			(IDM_BASE_More + 0x01)
#define IDM_MoreFontsJ			(IDM_BASE_More + 0x02)
#define IDM_MoreCharStyles		(IDM_BASE_More + 0x03)
#define IDM_MoreParaStyles		(IDM_BASE_More + 0x04)
#define IDM_MoreMarks			(IDM_BASE_More + 0x05)

#define IDM_More_VirtualMincho		(IDM_BASE_More + 0x06)
#define IDM_More_VirtualGothic		(IDM_BASE_More + 0x07)
#define IDM_More_NoRomajiFont		(IDM_BASE_More + 0x08)
#define IDM_More_NoCharStyle		(IDM_BASE_More + 0x09)
#define IDM_More_NoParaStyle		(IDM_BASE_More + 0x0a)
#ifdef BW3_RECENTOPEN
#define IDM_MoreRecentOpen		(IDM_BASE_More + 0x0b)
#endif /* BW3_RECENTOPEN */

// -------------------------------------------------------------------- //
// File menu ID
// -------------------------------------------------------------------- //

#define IDM_File_New			(IDM_BASE_File + 0x00)
#define IDM_File_Open			(IDM_BASE_File + 0x01)
#define IDM_File_Close			(IDM_BASE_File + 0x02)
#define IDM_File_Save			(IDM_BASE_File + 0x03)
#define IDM_File_SaveAs			(IDM_BASE_File + 0x04)
#define IDM_File_Revert			(IDM_BASE_File + 0x05)
#define IDM_File_Print			(IDM_BASE_File + 0x06)
#define IDM_File_PrinterSetup		(IDM_BASE_File + 0x07)
#define IDM_File_WC			(IDM_BASE_File + 0x08)
#define IDM_File_Preferences		(IDM_BASE_File + 0x09)
#define IDM_File_AutoSave		(IDM_BASE_File + 0x0a)
#define IDM_File_Exit			(IDM_BASE_File + 0x0b)

// -------------------------------------------------------------------- //
// Edit menu ID
// -------------------------------------------------------------------- //

#define IDM_Edit_Undo			(IDM_BASE_Edit + 0x00)
#define IDM_Edit_UndoRun		(IDM_BASE_Edit + 0x01)
#define IDM_Edit_Redo			(IDM_BASE_Edit + 0x02)
#define IDM_Edit_RedoRun		(IDM_BASE_Edit + 0x03)
#define IDM_Edit_Cut			(IDM_BASE_Edit + 0x04)
#define IDM_Edit_Copy			(IDM_BASE_Edit + 0x05)
#define IDM_Edit_Paste			(IDM_BASE_Edit + 0x06)
#define IDM_Edit_Delete			(IDM_BASE_Edit + 0x07)
#define IDM_Edit_InsertFile		(IDM_BASE_Edit + 0x08)
#define IDM_Edit_Tategaki		(IDM_BASE_Edit + 0x09)
#define IDM_Edit_Ansi			(IDM_BASE_Edit + 0x0a)
#define IDM_Edit_VText_FileName		(IDM_BASE_Edit + 0x0b)
#define IDM_Edit_VText_PageNumber	(IDM_BASE_Edit + 0x0c)
#define IDM_Edit_VText_Time		(IDM_BASE_Edit + 0x0d)
#define IDM_Edit_VText_Update		(IDM_BASE_Edit + 0x0e)
#define IDM_Edit_VText_Freeze		(IDM_BASE_Edit + 0x0f)

// not a menu ID
#define IDM_Edit_DeleteRight		(IDM_BASE_Edit + 0x10)
#define IDM_Edit_DeleteRightWord	(IDM_BASE_Edit + 0x11)
#define IDM_Edit_DeleteNotOnMenu	(IDM_BASE_Edit + 0x12)
#define IDM_Edit_Back			(IDM_BASE_Edit + 0x13)
#define IDM_Edit_DeleteWord		(IDM_BASE_Edit + 0x14)
#define IDM_Edit_NewLine		(IDM_BASE_Edit + 0x15)
#define IDM_Edit_NewPar			(IDM_BASE_Edit + 0x16)
#define IDM_Edit_DeleteLine		(IDM_BASE_Edit + 0x17)
#define IDM_Edit_DeletePara		(IDM_BASE_Edit + 0x18)

#define IDM_Edit_InputText_MODE		(IDM_BASE_Edit + 0x19)
#define IDM_Edit_MakeTable_MODE		(IDM_BASE_Edit + 0x1a)
#define IDM_Edit_MoveLine_MODE		(IDM_BASE_Edit + 0x1b)
#define IDM_Edit_SelectFrame_MODE	(IDM_BASE_Edit + 0x1c)
#define IDM_Edit_DrawLine_MODE		(IDM_BASE_Edit + 0x1d)
#define IDM_Edit_Cut_MODE		(IDM_BASE_Edit + 0x1e)
#define IDM_Edit_SetFlow_MODE		(IDM_BASE_Edit + 0x1f)
#define IDM_Edit_ExchFlow_MODE		(IDM_BASE_Edit + 0x20)
#define IDM_Edit_FrameMargin_MODE	(IDM_BASE_Edit + 0x21)
#define IDM_Edit_SetMargin_MODE		(IDM_BASE_Edit + 0x22)

#define IDM_Edit_Mode_Inc		(IDM_BASE_Edit + 0x23)
#define IDM_Edit_Mode_Dec		(IDM_BASE_Edit + 0x24)

#define IDM_Edit_IMERegister		(IDM_BASE_Edit + 0x25)
#define IDM_Edit_EuroCombo		(IDM_BASE_Edit + 0x26)
#define IDM_Edit_IMEToggle		(IDM_BASE_Edit + 0x27)

#ifdef BW2_ABBREV
#define IDM_Edit_Abbrev_Register	(IDM_BASE_Edit + 0x28)
#endif /* BW2_ABBREV */

// -------------------------------------------------------------------- //
// Character menu ID
// -------------------------------------------------------------------- //

#define IDM_Char_Plain			(IDM_BASE_Char + 0x00)
#define IDM_Char_Bold			(IDM_BASE_Char + 0x01)
#define IDM_Char_Italic			(IDM_BASE_Char + 0x02)
#define IDM_Char_Underline		(IDM_BASE_Char + 0x03)
#define IDM_Char_Size			(IDM_BASE_Char + 0x04)
#define IDM_Char_Size_Inc		(IDM_BASE_Char + 0x05)
#define IDM_Char_Size_Dec		(IDM_BASE_Char + 0x06)
#define IDM_Char_SizeAdjust		(IDM_BASE_Char + 0x07)
#define IDM_Char_SizeAdjust_Inc		(IDM_BASE_Char + 0x08)
#define IDM_Char_SizeAdjust_Dec		(IDM_BASE_Char + 0x09)
#define IDM_Char_Lines			(IDM_BASE_Char + 0x0a)
#define IDM_Char_Tab_Left		(IDM_BASE_Char + 0x0b)
#define IDM_Char_Tab_Right		(IDM_BASE_Char + 0x0c)
#define IDM_Char_Tab_Decimal		(IDM_BASE_Char + 0x0d)
#define IDM_Char_Tab_Center		(IDM_BASE_Char + 0x0e)
#define IDM_Char_Inverted		(IDM_BASE_Char + 0x0f)
#define IDM_Char_Strikeout		(IDM_BASE_Char + 0x10)
#define IDM_Char_Subscript		(IDM_BASE_Char + 0x11)
#define IDM_Char_Subscript_Half		(IDM_BASE_Char + 0x12)
#define IDM_Char_Superscript		(IDM_BASE_Char + 0x13)
#define IDM_Char_Superscript_Half	(IDM_BASE_Char + 0x14)
#define IDM_Char_Nonbreaking		(IDM_BASE_Char + 0x15)
#define IDM_Char_Invisible		(IDM_BASE_Char + 0x16)
#define IDM_Char_Spacing		(IDM_BASE_Char + 0x17)
#define IDM_Char_Spacing_Inc		(IDM_BASE_Char + 0x18)
#define IDM_Char_Spacing_Dec		(IDM_BASE_Char + 0x19)
#define IDM_Char_CopyAttr		(IDM_BASE_Char + 0x1a)
#define IDM_Char_PasteAttr		(IDM_BASE_Char + 0x1b)
#define IDM_Char_Style_Define		(IDM_BASE_Char + 0x1c)
#define IDM_Char_Style_Redefine		(IDM_BASE_Char + 0x1d)
#define IDM_Char_Style_Pure		(IDM_BASE_Char + 0x1e)
#define IDM_Char_Style_Search		(IDM_BASE_Char + 0x1f)

#ifndef NDEBUG
// for new dispatcher
#define IDM_Char_Test_1			(IDM_BASE_Char + 0x24)
#endif

// IDM_CharSize is the base to which the actual size is added to
// get the ID for a text size menu item.  leaving 255 entries open
// after it allows point sizes of up to 255.
#define IDM_CharSize			IDM_BASE_CharSize

// -------------------------------------------------------------------- //
// Paragraph menu ID
// -------------------------------------------------------------------- //

#define IDM_Para_LineSpacing		(IDM_BASE_Para + 0x00)
#define IDM_Para_LineSpacing_Inc	(IDM_BASE_Para + 0x01)
#define IDM_Para_LineSpacing_Dec	(IDM_BASE_Para + 0x02)
#define IDM_Para_Spacing		(IDM_BASE_Para + 0x03)
#define IDM_Para_Spacing_Inc		(IDM_BASE_Para + 0x04)
#define IDM_Para_Spacing_Dec		(IDM_BASE_Para + 0x05)
#define IDM_Para_Margin			(IDM_BASE_Para + 0x06)
#define IDM_Para_ChangeIndent		(IDM_BASE_Para + 0x07)
#define IDM_Para_AlignLeft		(IDM_BASE_Para + 0x08)
#define IDM_Para_AlignCenter		(IDM_BASE_Para + 0x09)
#define IDM_Para_AlignRight		(IDM_BASE_Para + 0x0a)
#define IDM_Para_AlignEquality		(IDM_BASE_Para + 0x0b)
#define IDM_Para_AlignStretched		(IDM_BASE_Para + 0x0c)
#define IDM_Para_Border			(IDM_BASE_Para + 0x0d)
#define IDM_Para_SimpleBorder		(IDM_BASE_Para + 0x0e)
#define IDM_Para_Tab			(IDM_BASE_Para + 0x0f)
#define IDM_Para_DontChopInTwo		(IDM_BASE_Para + 0x10)
#define IDM_Para_PlaceOnNormal		(IDM_BASE_Para + 0x11)
#define IDM_Para_PlaceOnFrame		(IDM_BASE_Para + 0x12)
#define IDM_Para_PlaceOnPage		(IDM_BASE_Para + 0x13)
#define IDM_Para_CopyAttr		(IDM_BASE_Para + 0x14)
#define IDM_Para_PasteAttr		(IDM_BASE_Para + 0x15)
#define IDM_Para_CharStyle		(IDM_BASE_Para + 0x16)
#define IDM_Para_Style_Define		(IDM_BASE_Para + 0x17)
#define IDM_Para_Style_Redefine		(IDM_BASE_Para + 0x18)
#define IDM_Para_Style_Pure		(IDM_BASE_Para + 0x19)
#define IDM_Para_Style_Search		(IDM_BASE_Para + 0x1a)

#ifndef NDEBUG
// for new dispatcher
#define IDM_Para_Test_2			(IDM_BASE_Para + 0x1b)
#endif

// -------------------------------------------------------------------- //
// Frame menu ID
// -------------------------------------------------------------------- //

#define IDM_Frame_Margin		(IDM_BASE_Frame + 0x00)
#define IDM_Frame_AlignTop		(IDM_BASE_Frame + 0x01)
#define IDM_Frame_AlignMiddle		(IDM_BASE_Frame + 0x02)
#define IDM_Frame_AlignBottom		(IDM_BASE_Frame + 0x03)
#define IDM_Frame_AlignVerticalAdjust	(IDM_BASE_Frame + 0x04)
#define IDM_Frame_Border		(IDM_BASE_Frame + 0x05)
#define IDM_Frame_DefaultBorder		(IDM_BASE_Frame + 0x06)
#define IDM_Frame_DefaultTableBorder	(IDM_BASE_Frame + 0x07)
#define IDM_Frame_Cut			(IDM_BASE_Frame + 0x08)
#define IDM_Frame_Copy			(IDM_BASE_Frame + 0x09)
#define IDM_Frame_Paste			(IDM_BASE_Frame + 0x0a)
#define IDM_Frame_NewFlow		(IDM_BASE_Frame + 0x0b)
#define IDM_Frame_Fill			(IDM_BASE_Frame + 0x0c)
#define IDM_Frame_ReadFile		(IDM_BASE_Frame + 0x0d)
#define IDM_Frame_Insert		(IDM_BASE_Frame + 0x0e)
#define IDM_Frame_Delete		(IDM_BASE_Frame + 0x0f)
#define IDM_Frame_Split			(IDM_BASE_Frame + 0x10)
#define IDM_Frame_Combine		(IDM_BASE_Frame + 0x11)
#define IDM_Frame_Align			(IDM_BASE_Frame + 0x12)
#define IDM_Frame_MakeTable		(IDM_BASE_Frame + 0x13)

// -------------------------------------------------------------------- //
// Page menu ID
// -------------------------------------------------------------------- //

#define IDM_Page_Size			(IDM_BASE_Page + 0x00)
#define IDM_Page_Header			(IDM_BASE_Page + 0x01)
#define IDM_Page_PageNumber		(IDM_BASE_Page + 0x02)
#define IDM_Page_NewLayout		(IDM_BASE_Page + 0x03)
#define IDM_Page_NewSection		(IDM_BASE_Page + 0x04)
#define IDM_Page_ReplaceLayout		(IDM_BASE_Page + 0x05)
#define IDM_Page_RenameLayout		(IDM_BASE_Page + 0x06)
#define IDM_Page_Open			(IDM_BASE_Page + 0x07)
#define IDM_Page_Close			(IDM_BASE_Page + 0x08)

// -------------------------------------------------------------------- //
// Location menu ID
// -------------------------------------------------------------------- //

#define IDM_Location_AllFlow		(IDM_BASE_Location + 0x00)
#define IDM_Location_All		(IDM_BASE_Location + 0x01)
/*#define IDM_Location_Para		(IDM_BASE_Location + 0x02)*/
/*#define IDM_Location_Line		(IDM_BASE_Location + 0x03)*/
/*#define IDM_Location_Word		(IDM_BASE_Location + 0x04)*/
#define IDM_Location_Top		(IDM_BASE_Location + 0x05)
#define IDM_Location_Bot		(IDM_BASE_Location + 0x06)
#define IDM_Location_GotoPage		(IDM_BASE_Location + 0x07)
#define IDM_Location_PrevLocation	(IDM_BASE_Location + 0x08)
#define IDM_Location_NextSelection	(IDM_BASE_Location + 0x09)
#define IDM_Location_PrevSelection	(IDM_BASE_Location + 0x0a)
#define IDM_Location_Search		(IDM_BASE_Location + 0x0b)
#define IDM_Location_SearchQuickly	(IDM_BASE_Location + 0x0c)
#define IDM_Location_SearchBackward	(IDM_BASE_Location + 0x0d)
#define IDM_Location_SearchForward	(IDM_BASE_Location + 0x0e)
#define IDM_Location_MakeMark		(IDM_BASE_Location + 0x0f)
#define IDM_Location_RemoveMark		(IDM_BASE_Location + 0x10)

// internal use only
#define IDM_Location_FindGo		(IDM_BASE_Location + 0x11)

// -------------------------------------------------------------------- //
// Display menu ID
// -------------------------------------------------------------------- //

#define IDM_Disp_ZoomWindow		(IDM_BASE_Disp + 0x00)
#define IDM_Disp_ZoomWindow_Inc		(IDM_BASE_Disp + 0x01)
#define IDM_Disp_ZoomWindow_Dec		(IDM_BASE_Disp + 0x02)
#define IDM_Disp_NewWindow		(IDM_BASE_Disp + 0x03)
#define IDM_Disp_CascadeWindow		(IDM_BASE_Disp + 0x04)
#define IDM_Disp_TileWindow		(IDM_BASE_Disp + 0x05)
#define IDM_Disp_FrameLine		(IDM_BASE_Disp + 0x06)
#define IDM_Disp_FrameMargin		(IDM_BASE_Disp + 0x07)
#define IDM_Disp_ParaMargin		(IDM_BASE_Disp + 0x08)
#define IDM_Disp_FlowLine		(IDM_BASE_Disp + 0x09)
#define IDM_Disp_AutoLines		(IDM_BASE_Disp + 0x0a)
#define IDM_Disp_NextWindow		(IDM_BASE_Disp + 0x0b)
#define IDM_Disp_PrevWindow		(IDM_BASE_Disp + 0x0c)
#define IDM_Disp_Refresh		(IDM_BASE_Disp + 0x0d)
#define IDM_Disp_ScrollUp		(IDM_BASE_Disp + 0x0e)
#define IDM_Disp_ScrollDown		(IDM_BASE_Disp + 0x0f)
#define IDM_Disp_Bar			(IDM_BASE_Disp + 0x10)
#define IDM_Disp_Customizable		(IDM_BASE_Disp + 0x11)
#define IDM_Disp_Ribbon_Top		(IDM_BASE_Disp + 0x12)
#define IDM_Disp_Ribbon_Bot		(IDM_BASE_Disp + 0x13)
#define IDM_Disp_Ribbon_Left		(IDM_BASE_Disp + 0x14)
#define IDM_Disp_Ribbon_Right		(IDM_BASE_Disp + 0x15)
#define IDM_Disp_ModeBox		(IDM_BASE_Disp + 0x16)
#define IDM_Disp_CharBox		(IDM_BASE_Disp + 0x17)
#define IDM_Disp_ParaBox		(IDM_BASE_Disp + 0x18)
#define IDM_Disp_UserBox1		(IDM_BASE_Disp + 0x19)
#define IDM_Disp_UserBox2		(IDM_BASE_Disp + 0x1a)
#define IDM_Disp_UserBox3		(IDM_BASE_Disp + 0x1b)
#define IDM_Disp_UserBox4		(IDM_BASE_Disp + 0x1c)
#define IDM_Disp_BigBox			(IDM_BASE_Disp + 0x1d)

// -------------------------------------------------------------------- //
// Help menu ID
// -------------------------------------------------------------------- //

#define IDM_Help_Index			(IDM_BASE_Help + 0x00)
#define IDM_Help_Keyboard		(IDM_BASE_Help + 0x01)
#define IDM_Help_Commands		(IDM_BASE_Help + 0x02)
#define IDM_Help_Concepts		(IDM_BASE_Help + 0x03)
#define IDM_Help_Procedures		(IDM_BASE_Help + 0x04)
#define IDM_Help_UsingHelp		(IDM_BASE_Help + 0x05)
#define IDM_Help_About			(IDM_BASE_Help + 0x06)
#define IDM_Help_Screen			(IDM_BASE_Help + 0x07)
#define IDM_Help_DevInfo		(IDM_BASE_Help + 0x08)
#define IDM_Help_License		(IDM_BASE_Help + 0x09)

// -------------------------------------------------------------------- //
// Navigation Accelerator IDs
// -------------------------------------------------------------------- //

#define IDM_Nav_CharLeft		(IDM_BASE_Nav + 0x00)
#define IDM_Nav_CharRight		(IDM_BASE_Nav + 0x01)
#define IDM_Nav_LineUp			(IDM_BASE_Nav + 0x02)
#define IDM_Nav_LineDown		(IDM_BASE_Nav + 0x03)

#define IDM_Nav_WordLeft		(IDM_BASE_Nav + 0x04)
#define IDM_Nav_WordRight		(IDM_BASE_Nav + 0x05)
#define IDM_Nav_ParStart		(IDM_BASE_Nav + 0x06)
#define IDM_Nav_ParEnd			(IDM_BASE_Nav + 0x07)

#define IDM_Nav_LineLeft		(IDM_BASE_Nav + 0x08)
#define IDM_Nav_LineRight		(IDM_BASE_Nav + 0x09)
#define IDM_Nav_DocTop			(IDM_BASE_Nav + 0x0a)
#define IDM_Nav_DocBottom		(IDM_BASE_Nav + 0x0b)

#define IDM_Nav_CharLeftSelect		(IDM_BASE_Nav + 0x0c)
#define IDM_Nav_CharRightSelect		(IDM_BASE_Nav + 0x0d)
#define IDM_Nav_LineUpSelect		(IDM_BASE_Nav + 0x0e)
#define IDM_Nav_LineDownSelect		(IDM_BASE_Nav + 0x0f)

#define IDM_Nav_WordLeftSelect		(IDM_BASE_Nav + 0x10)
#define IDM_Nav_WordRightSelect		(IDM_BASE_Nav + 0x11)
#define IDM_Nav_ParStartSelect		(IDM_BASE_Nav + 0x12)
#define IDM_Nav_ParEndSelect		(IDM_BASE_Nav + 0x13)

#define IDM_Nav_LineLeftSelect		(IDM_BASE_Nav + 0x14)
#define IDM_Nav_LineRightSelect		(IDM_BASE_Nav + 0x15)
#define IDM_Nav_DocTopSelect		(IDM_BASE_Nav + 0x16)
#define IDM_Nav_DocBottomSelect		(IDM_BASE_Nav + 0x17)

#define IDM_Nav_CellLeft		(IDM_BASE_Nav + 0x18)
#define IDM_Nav_CellRight		(IDM_BASE_Nav + 0x19)
#define IDM_Nav_CellUp			(IDM_BASE_Nav + 0x1a)
#define IDM_Nav_CellDown		(IDM_BASE_Nav + 0x1b)

// -------------------------------------------------------------------- //
//                      fake menu ID
// -------------------------------------------------------------------- //

#define IDM_NoOperation			(IDM_BASE_Other + 0x00)
#define IDM_InputText			(IDM_BASE_Other + 0x01)

#ifndef NDEBUG
// These are testing ID's, invoked by the accelerators CTRL-1 etc.
#define IDM_Test_0			(IDM_BASE_Other + 0x10)
//#define IDM_Char_Test_1			(IDM_BASE_Other + 0x11)
//#define IDM_Para_Test_2			(IDM_BASE_Other + 0x12)
#define IDM_Test_3			(IDM_BASE_Other + 0x13)
#define IDM_Test_4			(IDM_BASE_Other + 0x14)
#define IDM_Test_5			(IDM_BASE_Other + 0x15)
#define IDM_Test_6			(IDM_BASE_Other + 0x16)
#define IDM_Test_7			(IDM_BASE_Other + 0x17)
#define IDM_Test_8			(IDM_BASE_Other + 0x18)
#define IDM_Test_9			(IDM_BASE_Other + 0x19)
#define IDM_CTRLS			(IDM_BASE_Other + 0x1a)
#define IDM_CTRLQ			(IDM_BASE_Other + 0x1b)
#define IDM_CTRLY			(IDM_BASE_Other + 0x1c)
#define IDM_Abort			(IDM_BASE_Other + 0x1d)
#define IDM_Debugger			(IDM_BASE_Other + 0x1e)
#define IDM_BufferInfo			(IDM_BASE_Other + 0x1f)
#endif

// -------------------------------------------------------------------- //
// Big menu definition
// -------------------------------------------------------------------- //

// The constants here give absolute positions of menus and items
// within other menus.  They are required because Windows allows
// no way to refer to a submenu symbolically.
// THESE CONSTANTS MUST be changed if menu structures change.

#define IDM_FileMenu 0
#define IDM_EditMenu 1
#define IDM_CharMenu 2
#define IDM_ParaMenu 3
#define IDM_LayoutMenu 4
#define IDM_LocationMenu 5
#define IDM_DispMenu 6

// Zero based position of UNDO, REDO in edit menu.
#define IDM_UndoPosition 0
#define IDM_RedoPosition 1

#ifdef BW2_ABBREV
#define IDM_AbbrevMenu IDM_EditMenu
#define IDM_AbbrevSubMenu 12
#endif /* BW2_ABBREV */

#ifdef BW3_RECENTOPEN
#define IDM_RecentOpenMenu IDM_FileMenu
#define IDM_RecentOpenSubMenu 3
#endif /* BW3_RECENTOPEN */

#define IDM_FontMenu IDM_CharMenu
#define IDM_FontJSubMenu 6
#define IDM_FontESubMenu 7

#define IDM_CharStyleMenu IDM_CharMenu
#define IDM_CharStyleSubMenu 15

#define IDM_ParaStyleMenu IDM_ParaMenu
#define IDM_ParaStyleSubMenu 10

#define IDM_MarkMenu IDM_LocationMenu
#define IDM_MarkSubMenu 13

#endif /* PMENUS_H */
