// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: printdlg.cpp,v 3.5 2000/05/13 16:29:04 kudou Exp $
// implement the PrintDialog class for PWord print dialog box

#include "pword.h"
#include "pmenus.h"
#include "dialogs.h"
#include "document.h"
#include "xstr.h"
#include "printdlg.h"

bool PrintDialog::reverse_print = False;

#if (_MSC_VER == 1200)
// disable 'this' pointer usage waring
#pragma warning (disable:4355)
#endif
PrintDialog::PrintDialog(char* _device_name, 
			 char* _port_name,
			 bool _has_selections,
			 int _first_page, int _last_page)
  : device_name(_device_name),
    port_name(_port_name),
    has_selections(_has_selections),
    first_page(_first_page),
    last_page(_last_page),
    copies(this, False),
    from(this, True),
    to(this, True)
{
  this->class_name = "Print";
  selection_only=0;
}

LRESULT_T
PrintDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      // printer destination
      char buf [256];
      ::wsprintf(buf, S_PrinterSetupString, device_name, port_name);
      this->SetItemText(IDD_PrintPrinterName, buf);

      // number of copies
      this->SendItemMessage(IDD_PrintCopies, EM_LIMITTEXT, 2);
      this->SetItemInt(IDD_PrintCopies, 1);

      // first page
      this->SendItemMessage(IDD_Print_FromPage, EM_LIMITTEXT, 4);
      this->SetItemInt(IDD_Print_FromPage, first_page);

      // last page
      this->SendItemMessage(IDD_Print_ToPage, EM_LIMITTEXT, 4);
      this->SetItemInt(IDD_Print_ToPage, last_page);

      // selection only
      this->SendItemMessage(IDD_PrintSelectionOnly,
			     BM_SETCHECK, selection_only);
      ::EnableWindow(this->GetItem(IDD_PrintSelectionOnly), this->has_selections);
      // reverse print
      this->SendItemMessage(IDD_PrintReverse,
			     BM_SETCHECK, reverse_print);
      this->Enable();
      return 1;
    }
			
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDD_Print_FromPage:
      from.Check(IDD_Print_FromPage);
      EnableOK();
      break;

     case IDD_Print_ToPage:
      to.Check(IDD_Print_ToPage);
      EnableOK();
      break;

     case IDD_PrintCopies:
      copies.Check(IDD_PrintCopies);
      EnableOK();
      break;

     case IDD_PrintSelectionOnly: 
      selection_only = (bool)(get_item_check(IDD_PrintSelectionOnly) != 0);
      Enable();
      break;
      
     case IDOK: 
      if (Anything()) 
      {
	reverse_print = (bool)(get_item_check(IDD_PrintReverse) != 0);
	End(1);
      }
      break;

     case IDCANCEL:
      End(0);
      return 1;
				
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
    
   default: 
    return 0;
  }
  return 0;
}

void
Item::Check(unsigned int ID)
{
  BOOL translated;
  this->valid = False;
  this->value = dlg->GetItemInt(ID, &translated);
  if (translated && (this->sign || 0 <= this->value))
  {
    this->valid = True;
    this->present = True;
  }
  else
  {
    const int buflen = 64;
    char buf[buflen + 1];
    dlg->GetItemText(ID, buf, buflen);
    if (buf[0] == '\0')
    {
      this->valid = True;
      this->present = False;
    }
  }
}

void
PrintDialog::EnableOK()
{
  bool valid = from.valid && to.valid && copies.valid;
  if (from.present && to.present && (from.value > to.value))
  {
    valid = False;
  }
  ::EnableWindow(GetItem(IDOK), valid);
}
	
void
PrintDialog::GetValues(bool& sel_only, 
		       bool& from_default,   int& from_value, 
		       bool& to_default,     int& to_value, 
		       bool& copies_default, int& copies_value)
{
  sel_only = selection_only;
  
  from_default = !from.present;
  from_value = from.value;
  
  to_default = !to.present;
  to_value = to.value;
  
  copies_default = !copies.present;
  copies_value = copies.value;
}

bool
PrintDialog::Anything()
{
  bool sel_only;
  bool from_default, to_default, copies_default;
  int from, to, copies;
  
  GetValues(sel_only, 
	    from_default, from, 
	    to_default, to, 
	    copies_default, copies);
  
  bool anything;
  if (sel_only) 
  {
    anything = has_selections;
  }
  else 
  {
    anything = ((to_default || (to >= first_page)) && 
		(from_default || (from <= last_page)));
  }

  if (!anything)
  {
    Issue(S_NothingToPrintMsg, MB_ICONEXCLAMATION | MB_OK);
  }
  return anything;
}

void
PrintDialog::Enable()
{
  int only = (int)get_item_check(IDD_PrintSelectionOnly);

  EnableWindow(GetItem(IDD_Print_From), !only);
  EnableWindow(GetItem(IDD_Print_To), !only);
  EnableWindow(GetItem(IDD_Print_FromPage), !only);
  EnableWindow(GetItem(IDD_Print_ToPage), !only);
}
