// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: printdlg.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// definitions for class PrintDialog
// PrintDialog has "memory" for all the options related to printing.
// If you make one and keep it around, you can run Go on it many times,
// and each time it appears it will have the saved information shown.
// If you want to remember print options separately for each document,
// for example, you might make a PrintDialog object and keep it with
// each document.  A PrintDialog object does not actually construct or
// do anything with a Windows dialog box until it is Go'd on, and even then
// the Windows dialog box has disappeared by the time Go returns.
//
// After running Go on the box you can get its options with GetValues.

#ifndef PRINTDLG_H
#define PRINTDLG_H

#include "dlg.h"

class PrintDialog;

// item is a minor class used to hold information about one
// numeric item in the box.  "Absence" is allowed, and construed
// as default.

struct Item
{
  PrintDialog* dlg;

  bool valid;         // OK status -- either absent or value number
  bool present;       // blank or not
  int value;          // value, if present
  
  bool sign;          // minus value possible?
  
  Item(PrintDialog* _dlg, bool _sign) 
  : sign(_sign) 
  , dlg(_dlg)
  { 
    valid = True;
    present = False;
  }
  void Check(unsigned int ID);
};

class PrintDialog
  : public NoKanjiModalDialog
{
private:
  Item copies, from, to;  
  bool selection_only;
  // values fed into the dialog
  char* device_name;
  char* port_name;
  bool has_selections;
  int first_page, last_page;
  static bool reverse_print;
  
public:
  PrintDialog(char* device_name, char* port_name, 
	       bool has_selections, 
	       int first_page, int last_page);

  // retrieve values
  void GetValues(bool& sel_only, 
		 bool& from_default,   int& from, 
		 bool& to_default,     int& to, 
		 bool& copies_default, int& copies);
  
  bool ReversePrintP()
  {
    return reverse_print;
  }
  
private:
  virtual LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);

  // enable OK button if all values valid
  void EnableOK();
  
  // see if anything would be printed
  bool Anything();
  
  // disable page from and to if selection only
  void Enable();
};		// class PrintDialog

#endif /* PRINTDLG_H */


