// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: printeri.cpp,v 3.8 2000/05/04 13:44:08 kudou Exp $
// implement PrinterInfo class

#include "pword.h"
#ifndef _WIN32
#  include <drivinit.h>
#endif /* _WIN32 */
#include "psetdlg.h"
#include "ploadabl.h"
#include "printeri.h"

#ifdef _WIN32
#  include <string.h>
#define _fstrchr strchr
#endif /* _WIN32 */

void
PrinterInfo::MakeDevMode(int n)
{
  devmode_size = n;
  delete dev_mode;
  dev_mode = (LPDEVMODE) new char[n];
  memset(dev_mode, 0, n);
}

PrinterInfo::PrinterInfo()
{
  Init();
  MakeDevMode(sizeof(DEVMODE));
}

PrinterInfo::PrinterInfo(PrinterInfo& pi)
{
  Init();
  memcpy((void*)this, (void*)&pi, sizeof(PrinterInfo));
  dev_mode = 0;
  if (pi.dev_mode)
  {
    MakeDevMode(pi.devmode_size);
    memcpy((void*)dev_mode, (void*)pi.dev_mode, pi.devmode_size);
  }
}

void
PrinterInfo::Init()
{
  dev_mode = 0;
  *port_name = '\0';
  *driver_name = '\0';
  *device_name = '\0';
  psstat = PSSTAT_UNKNOWN;
  n_env_size = 0;
  printing_offset_x = printing_offset_y = 0;
  error = False;
#ifndef _WIN32
  stupid_no_exttextout = False;
#endif /* _WIN32 */
#ifdef _WIN32
  dc_copies = 0;
#endif /* _WIN32 */
}

PrinterInfo::~PrinterInfo()
{
  delete dev_mode;
}

PrinterInfo*
PrinterInfo::Setup(PrinterInfo* printer_info) 
{
  PrinterSetupDialog dlg(printer_info, True);
  if (dlg.Go()) 
  {
    return dlg.GetPrinterInfo();
  }
  else
  {
    return 0;
  }
}

// Function accepts string in a PrintInfo format.  This format is:
//       (device name)[= | ,](driver name),(port)
// It then fills the buffers passed-in with parsed fields.
// If fAppendDriverExt is TRUE, ".DRV" is appended to the driver's name.
void
PrinterInfo::ParsePrintInfo(LPSTR print_info, BOOL fAppendDriverExt)
{
  char* dev = device_name;
  char* driv = driver_name;
  char* port = port_name;

  LPSTR p;
  while (('=' != *print_info) && (',' != *print_info))
  {
    *dev++ = *print_info++;
   }
  *dev = 0;
  print_info++;
   
  p = driver_name;
  while (*print_info != ',')
  {
    *driv++ = *print_info++;
  }

  *driv = 0;
  if (_fstrchr(p, '.') == NULL && fAppendDriverExt)
  {
    lstrcpy(driv, ".DRV");
  }
  print_info++;

  while (*print_info != 0)
  {
    *port++ = *print_info++;
  }
  *port = 0;
}

// Function is called when user selects "Ok" or "Setup..." button from
// "Printer setup" dialog box.  This function prepares a new PSSTRUCT 
// memory block with information about the selected printer.  If hWnd 
// is NOT NULL, the user is presented the printer's settings dialog box 
// to change any settings.  The hWnd parameter is NULL when the user
// selects the "Ok" button from the "Printer setup" dialog box.

#ifdef _WIN32
// DocumentProperties() is a replacement of ExtDeviceMode() for Win32.

PrinterInfo::SNP
PrinterInfo::SetupNewPrinter(PrinterInfo* old, HWND hWnd, LPSTR print_info) 
{
  // make up DEVMODE for this printer.
  ParsePrintInfo(print_info, TRUE);
  HANDLE hp = 0;
  BOOL ret = ::OpenPrinter(device_name, &hp, NULL);
  if (!ret)
  {
    return SNP_NODRIVER;
  }
  int dev_mode_size = ::DocumentProperties(hWnd, hp, device_name, NULL, NULL, 0);
  MakeDevMode(dev_mode_size);
  if (!dev_mode)
  {
    return SNP_NOMEMORY;
  }
  psstat = PSSTAT_EXTDEVMODE;
  n_env_size = 0;
  if (old && !stricmp(old->device_name, device_name))
  {
    ::DocumentProperties(hWnd, hp, device_name, dev_mode, old->dev_mode,
			 DM_IN_BUFFER | DM_OUT_BUFFER | (hWnd == NULL ? 0 : DM_IN_PROMPT));
  }
  else
  {
    ::DocumentProperties(hWnd, hp, device_name, dev_mode, 0,
			 DM_OUT_BUFFER | (hWnd == NULL ? 0 : DM_IN_PROMPT));
  }
  ::ClosePrinter(hp);

  // get device capabilities
  // Following function returns invalid value. This may be Win32 documentation bug.
  //int n = ::DeviceCapabilities(device_name, port_name, DC_COPIES, (LPTSTR)0, dev_mode);
  //assert(n == sizeof(int));
  ::DeviceCapabilities(device_name, port_name, DC_COPIES, (LPTSTR)&dc_copies, dev_mode);

  // replace ment of SetOffset();
  HDC ic = CreateIC();	// IC - Information Context - is faster than DC.
  if (ic != NULL)
  {
    printing_offset_x = ::GetDeviceCaps(ic, PHYSICALOFFSETX);
    printing_offset_y = ::GetDeviceCaps(ic, PHYSICALOFFSETY);
    ::DeleteDC(ic);
  }
  
  return SNP_SUCCESS;
}

void
PrinterInfo::SetCopiesNum(int n)
{
  assert(dev_mode);
  dev_mode->dmCopies = n;
}

#else /* _WIN32 */

// DRIVINIT.H doesn't define types for use with the old DeviceMode 
// function so we have to.
typedef void FAR PASCAL FNDEVICEMODE(HWND, HANDLE, LPSTR, LPSTR);
typedef FNDEVICEMODE /*FAR redundant*/* LPFNDEVICEMODE;

PrinterInfo::SNP 
PrinterInfo::SetupNewPrinter(PrinterInfo* old, HWND hWnd, LPSTR print_info) 
{
  ParsePrintInfo(print_info, TRUE);

  LPFNDEVMODE ExtDeviceMode;
  LPFNDEVICEMODE DeviceMode;

  PLoadable hDriver(driver_name);

  if (!hDriver) 
  {
    return SNP_NODRIVER;
  }

  ExtDeviceMode = (LPFNDEVMODE) GetProcAddress(hDriver, PROC_EXTDEVICEMODE);
  DeviceMode = (LPFNDEVICEMODE) GetProcAddress(hDriver, PROC_OLDDEVICEMODE);

  if (ExtDeviceMode == NULL && DeviceMode == NULL) 
  {
    return SNP_INVALIDDRIVER;
  }
  if (ExtDeviceMode != NULL) 
  {
    // Get size of complete DEVMODE structure.
    int dev_mode_size = ExtDeviceMode(hWnd, hDriver, NULL, device_name,
				      port_name, NULL, NULL, 0);

    MakeDevMode(dev_mode_size);
    if (!dev_mode)
    {
      return SNP_NOMEMORY;
    }
    psstat = PSSTAT_EXTDEVMODE;
    n_env_size = 0;

    if (old)
    {
      if (old->psstat == PSSTAT_EXTDEVMODE) 
      {
	if (stricmp(old->driver_name, driver_name)) 
	{
	  // Setting-up a different printer.
	  // Reset device-specific & driver-specific fields in DEVMODE.
#ifdef _WIN32
	  lstrcpy((char*)&old->dev_mode->dmDeviceName, device_name);
#else /* _WIN32 */
	  lstrcpy(old->dev_mode->dmDeviceName, device_name);
#endif /* _WIN32 */
	  old->dev_mode->dmDriverVersion = 0;
	  old->dev_mode->dmDriverExtra = 0;
	}
      }

      // Return value is IDOK if successful.
      ExtDeviceMode(hWnd, hDriver, dev_mode,
		    device_name, port_name, 
		    old == NULL ? NULL : old->dev_mode, 
		    NULL,
		    ((old == NULL ? 0 : DM_MODIFY) | 
		     ((hWnd == NULL) ? 0 : DM_PROMPT) | 
		     DM_COPY | DM_UPDATE));
      
    } 
    else 
    {
      // Return value is IDOK if successful.
      ExtDeviceMode(hWnd, hDriver, dev_mode,
		    device_name, port_name, 
		    NULL, NULL,
		    (((hWnd == NULL) ? 0 : DM_PROMPT) | 
		     DM_COPY | DM_UPDATE));
    }
  } 
  else 
  {
    // For all other cases, the DeviceMode function must be called.

    // If the old PSSTRUCT has a valid Printer Environment,
    // set the printer environment.
#ifdef PRINTER_ENVIRONMENT
    if ((old != NULL) && (old->n_env_size > 0))
    {
      SetEnvironment(port_name, (LPSTR) old->dev_mode, old->n_env_size);
    }
#endif
    
    if (hWnd != NULL) 
    {
      DeviceMode(hWnd, hDriver, device_name, port_name);
    }

#ifdef PRINTER_ENVIRONMENT
    // n_env_size is the size of the Printer Environment.
    int env_size = GetEnvironment(port_name, NULL, 0);

    // Allocate a DEVMODE large enough to contain the Printer Environment.
    MakeDevMode(env_size);
    if (!dev_mode)
    {
      return SNP_NOMEMORY;
    }
    n_env_size = env_size;

    if (env_size > 0)
    {
      // If a Printer Environment exists, save it.
      GetEnvironment(port_name, (LPSTR) dev_mode, env_size);
    } 
    lstrcpy(dev_mode->dmDeviceName, device_name);
    // Fill in values
    psstat = PSSTAT_DEVMODEONLY;
#endif
  }
  SetOffset();
  return SNP_SUCCESS;
}

void
PrinterInfo::SetOffset()
{
  HDC dc = CreateIC();
  if (dc != NULL)
  {
    POINT garb;
    int res = ::Escape(dc, GETPRINTINGOFFSET, NULL, NULL, (LPSTR)&garb);
    if (res <= 0)
    {
      printing_offset_x = printing_offset_y = 0;
    }
    else
    {
      printing_offset_x = garb.x;
      printing_offset_y = garb.y;
    }
    int escape = EXTTEXTOUT;
    stupid_no_exttextout = !::Escape(dc, QUERYESCSUPPORT, sizeof(int), (LPSTR)&escape, NULL);
#if 1
    // BeatWord Version 2 doesn't have next DeleteDC.
    // It was a dormant bug. (kudou)
    ::DeleteDC(dc);
#endif
  }
}
#endif /* _WIN32 */

// This function accepts a PrinterInfo and creates a device context for the 
// printer described in the structure.  If fUseDefaultSettings is TRUE,
// the default settings are used for the DC and not any settings that may
// exist in the PSSTRUCT set by a call to PrinterSetup.

HDC
PrinterInfo::CreateIC()
{
#ifdef MSC7_FUNARG_BUG
  return CreatexDC((void*) ::CreateIC);
#else
  return CreatexDC(::CreateIC);
#endif
}

HDC
PrinterInfo::CreateDC()
{
#ifdef MSC7_FUNARG_BUG
  return CreatexDC((void*) ::CreateDC);
#else
  return CreatexDC(::CreateDC);
#endif
}

#ifdef MSC7_FUNARG_BUG
HDC
PrinterInfo::CreatexDC(void* func)
#else
#if (VERSION_OF_WINDOWS_H == 31)
HDC
PrinterInfo::CreatexDC(HDC FAR PASCAL(*func)(LPCSTR, LPCSTR, LPCSTR, const void FAR*))
#elif defined(BCC5)
HDC
PrinterInfo::CreatexDC(HDC WINAPI (*func)(IN LPCSTR, IN LPCSTR, IN LPCSTR, IN CONST DEVMODE*))
#else
HDC
PrinterInfo::CreatexDC(HDC FAR PASCAL(*func)(LPSTR, LPSTR, LPSTR, LPSTR))
#endif
#endif
{
  if (error)
  {
    return 0;
  }
  
  HDC hDC;
  LPSTR p;
  DEVMODE* dm = 0;
  
  switch (psstat)
  {
   case PSSTAT_EXTDEVMODE:
    // Set lpDM to point to valid DEVMODE structure.
    dm = dev_mode;
    break;

   case PSSTAT_DEVMODEONLY:
   case PSSTAT_UNKNOWN:
    if (n_env_size > 0)
    {
         // If a printer environment exists for this printer use it.
      dm = dev_mode;
    }
  }

  // Remove extension from driver file name if it exists.
  p = _fstrchr(driver_name, '.');
  if (p)
  {
    *p = '\0';
  }

  // Create the device context.
#ifdef MSC7_FUNARG_BUG
  {
    hDC = (*(HDC(FAR PASCAL*) (LPSTR, LPSTR, LPSTR, LPSTR)) func)
    (driver_name, device_name, port_name, (LPSTR)dm);
  }
#elif defined(BCC5)
  hDC = (*func)(driver_name, device_name, port_name, dm);
#else
  hDC = (*func)(driver_name, device_name, port_name, (LPSTR)dm);
#endif

  // Restore the driver's extension if it was removed.
  if (p)
  {
    *p = '.';
  }

  return hDC;
}


// This function is called when an application initializes so that the 
// information about the default printer is loaded.

void
PrinterInfo::SetupDefPrinter() 
{
  char info[MAXPRINTINFOLEN];
  ::GetProfileString("windows", "device", "", info, sizeof(info));
  if (*info != '\0') 
  {
    SNP result = SetupNewPrinter(NULL, 0, info);
    if (result != SNP_SUCCESS)
    {
      error = True;
    }
  }
}

