// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: printeri.h,v 3.8 2000/05/13 16:29:04 kudou Exp $
// define PrinterInfo class

#ifndef PRINTERI_H
#define PRINTERI_H

#ifndef _WIN32
#include <drivinit.h>
#endif /* _WIN32 */

#ifdef _WIN32
#define MAXPORTLEN	MAX_PATH
#define MAXDRIVERLEN	MAX_PATH
#else /* _WIN32 */
#define MAXPORTLEN	(25)
#define MAXDRIVERLEN	(50)
#endif /* _WIN32 */
#define MAXDEVICELEN	(CCHDEVICENAME)   // From DRIVINIT.H
#define MAXPRINTINFOLEN	(MAXDEVICELEN + 1 + MAXDRIVERLEN + 1 + MAXPORTLEN)

class PrinterInfo
{
  friend class PrinterSetupDialog;
  
  enum PSSTAT
  {
    PSSTAT_UNKNOWN,
    PSSTAT_EXTDEVMODE, 
    PSSTAT_DEVMODEONLY,
  };

  // private members
  char port_name[MAXPORTLEN];
  char driver_name[MAXDRIVERLEN];
  char device_name[MAXDEVICELEN];
  PSSTAT psstat;
  int n_env_size;
  
  // DevMode can be different sizes depending on the 
  // printer and whether it supports ExtDevMode.
  DEVMODE* dev_mode;
  int devmode_size;

  int printing_offset_x;
  int printing_offset_y;
  bool error;
#ifndef _WIN32
  bool stupid_no_exttextout;
#endif /* _WIN32 */
#ifdef _WIN32
  int dc_copies;
#endif /* _WIN32 */
  
private:
  // internal routine used by CreateIC and CreateDC
#ifdef __CYGWIN32__
#define MSC7_FUNARG_BUG
#endif /* __CYGWIN32__ */
#ifdef MSC7_FUNARG_BUG
  HDC CreatexDC(void*);
#else
#if (VERSION_OF_WINDOWS_H == 31)
  HDC CreatexDC(HDC FAR PASCAL(*func)(LPCSTR, LPCSTR, LPCSTR, const void FAR*));
#elif defined(BCC5)
  HDC CreatexDC(HDC WINAPI (*func)(IN LPCSTR, IN LPCSTR, IN LPCSTR, IN CONST DEVMODE*));
#else
  HDC CreatexDC(HDC FAR PASCAL(*)(LPSTR,LPSTR,LPSTR,LPSTR));
#endif
#endif

  void MakeDevMode(int n);
    
  // parses a win.ini type string, placing its values in the PrinterInfo
  void ParsePrintInfo(LPSTR szPrintInfo, BOOL fAppendDriverExt);

#ifndef _WIN32
  // retrieve and store printing offset
  void SetOffset();
#endif /* _WIN32 */
  
public:
  PrinterInfo();
  PrinterInfo(PrinterInfo&);
  void Init();
  ~PrinterInfo();

  // return values from SetupNewPrinter, a routine called from
  // the dialog box when the user hits "Setup"
  enum SNP
  {
    SNP_SUCCESS,
    SNP_NODRIVER,
    SNP_INVALIDDRIVER,
    SNP_NOMEMORY, 
  };

  // called when user hits "Setup" in dialog box
  SNP SetupNewPrinter(PrinterInfo* , HWND hWnd, LPSTR print_info);
  
  // create DCs and ICs from the PrinterInfo
  HDC CreateDC();
  HDC CreateIC();
  
  // initialize a PrinterInfo to be the default printer
  void SetupDefPrinter();
  
  // get the device name
  char* GetDeviceName() { return device_name; }
  char* GetPortName() { return port_name; }

  // get printing offsets
  void GetPrintingOffsets(int& x, int& y)
  {
    x = printing_offset_x;
    y = printing_offset_y;
  }

  // runs the dialog box, returning NULL or a new PrinterInfo structure
  static PrinterInfo* Setup(PrinterInfo*);

#ifdef _WIN32
  bool DeviceSupportCopiesP() { return !!dc_copies; }
  void SetCopiesNum(int n);
#endif  /* _WIN32 */
};

#endif /* PRINTERI_H */
