// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: ptimer.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define PTimer class for Windows timers

#ifndef PTIMER_H
#define PTIMER_H

#include "window.h"

class PTimer
{
  // window for which timer is being set up, or
  // 0 for non-window based timer
  HWND hWnd;	

  // for window-based timer, ID passed in as
  // wParam in WM_TIMER messages  
  WORD ID;		
		
  int event;	
  
  void Init(HWND hWnd, int event, WORD time, TIMERPROC func=0)
  {
    PTimer::hWnd = hWnd;
    PTimer::event = event;
    ID = ::SetTimer(hWnd, event, time, func);
  }
	
public:
  // TIMERPROC:
  // void CALLBACK TimerProc(HWND, UINT, UINT, DWORD);
  PTimer(HWND hWnd, int event, WORD time, TIMERPROC func=0)
  {
    Init(hWnd, event, time, func);
  }
  
  PTimer(Window* w, int event, WORD time, TIMERPROC func=0)
  {
    Init(w->GetHandle(), event, time, func);
  }
	
  PTimer(WORD time, TIMERPROC func)
  {
    Init(0, 0, time, func);
  }
	
  ~PTimer()
  {
#if (!defined(NDEBUG))
    BOOL result = 
#endif
    ::KillTimer(hWnd, hWnd ? event : ID);
#if (!defined(NDEBUG))
    if (!result)
    {
      syserr("PTimer::~PTimer -- KillTimer failed.  "
	   "hWnd=%x, event=%x", hWnd, event);
    }
#endif
  }
  
  WORD GetID()
  {
    return ID;
  }
};

#endif /* PTIMER_H */
