// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pword.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// main program of pword

#include "pword.h"
#include <stdlib.h>
#include "boxes.h"
#include "rats.h"
#include "docwindo.h"
#include "mcursor.h"
#include "pmenus.h"
#include "pwordbas.h"
#include "pwordpre.h"
#include "caret.h"
#include "screen.h"
#include "view.h"
#include "wstdio.h"
#include "pclipboa.h"

// Global variavles
Document* Selected_Document = NULL;
DocumentWindow* Selected_Window = NULL;
UINT Clipboard_Format = 0;
HWND main_window_handle = 0;
MainWindow* main_window = NULL;
PrinterInfo* Printer_Info = NULL;
WORD windows_version_;
#ifdef BW21_W32
static DWORD windows_flags = 0;
#endif /* BW21_W32 */

#ifdef BW21_W32
// Win32 environment check from 16-bit windows. See next URL.
// http://support.microsoft.com/support/kb/articles/Q131/3/71.asp
bool
windows_w32_env_p()
{
#define WF_WINNT 0x4000
  return windows_95_or_later_p() || (windows_flags & WF_WINNT);
}

bool
windows_nt4_env_p()
{
  return (windows_flags & WF_WINNT) ? True : False;
}
#endif /* BW21_W32 */

static void
initialize(HINSTANCE hInstance)
{
  unsigned int get_version = LOWORD(GetVersion());
  windows_version_ = ((get_version & 0xff) << 8) | ((get_version & 0xff00) >> 8);

#ifdef BW21_W32
  windows_flags = ::GetWinFlags();
#endif
  
#ifndef NDEBUG
  initialize_wstdio(hInstance);
#endif
  init_command_table();
  Screen::Init();
  MouseCursor::InitialMouseCursor(hInstance);
}

void
ExitPWord(bool end)
{
  Boxes::kill_all_resources();
  Caret::KillAllResources();
  FontMetric::KillAllResources();
  Screen::KillAllResources();
  PWordPresentation::KillPrinterDC();
  DocumentWindow::KillBitmap();
  PClipboard::EnsureClose();
  MouseCursor::DestroyMouseCursor();
  if (end)
  {
#ifdef BW3_DEBUG
    assert(False);
#endif /* BW3_DEBUG */
    exit(1);
  }
}

void
initialization_fail()
{
#ifdef BW3_DEBUG
    assert(False);
#endif /* BW3_DEBUG */
  exit(1);
}

int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow)
{
  initialize(hInstance);
  PWordBase::init(hInstance, hPrevInstance, lpszCmdLine, nCmdShow);
  int result = PWordPresentation::Go();
  PWordBase::term();
  
  ExitPWord(False);
  return(result);
}
