// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pwordbas.cpp,v 3.17 2000/05/03 16:52:37 kudou Exp $
// implement PWordBase class
// The PWordBase class which enforces the distinction in the internal
// pWord architecture between content and representation.

#include "pword.h"
#include "pwordbas.h"
#include "again.h"
#include "attribut.h"
#include "autosave.h"
#include "bufnew.h"
#include "derivs.h"
#include "dlg.h"
#include "docconte.h"
#include "docprese.h"
#include "document.h"
#include "docwindo.h"
#include "fileopen.h"
#include "fileutil.h"
#include "fonts.h"
#include "marks.h"
#include "mcursor.h"
#include "menu.h"
#include "mwindow.h"
#include "pmenus.h"
#include "pref.h"
#include "printeri.h"
#include "ptimer.h"
#include "pundo.h"
#include "pwordpre.h"
#include "rats.h"
#include "statdlg.h"
#include "textflow.h"
#include "view.h"
#include "xstr.h"
#ifndef _WIN32
#include <drivinit.h>
#endif /* _WIN32 */
#include <stdlib.h>             // exit()

// static slots of class PWordBase
Document* PWordBase::first_document = NULL;
#ifndef BW3_FILEDLG
FileOpenDialog* PWordBase::file_open_dialog = NULL;
#endif /* BW3_FILEDLG */

int PWordBase::lobotomized = 
#ifndef LOBOTOMIZED
0
#else
1
#endif
;

#ifdef BW3_FILEDLG
int
PWordBase::FileOpenDlg(char* filename, char* filter_str, bool insert_file)
#else /* BW3_FILEDLG */
int
PWordBase::FileOpenDlg(char* filename, bool insert_file)
#endif /* BW3_FILEDLG */
{
#ifdef BW3_FILEDLG
  FileOpenDialog* file_open_dialog = new FileOpenDialog(filename, filter_str);
  file_open_dialog->SetMultipleFileP(true);
  bool result;
#else
  file_open_dialog->SetInitialName(filename);
  int result;
#endif /* BW3_FILEDLG */
  {
    NoKanjiDialog foo;
    result = file_open_dialog->Go(insert_file);
  }
  if (result)
  {
    // multiple file separator is null.
    memcpy(filename, file_open_dialog->GetResult(), MAX_PATH + 1);
  }
#ifdef BW3_FILEDLG
  delete file_open_dialog;
#endif /* BW3_FILEDLG */
  return(result);
}

void
PWordBase::GotoMark(int mark)
{
  Document* d;
  IntervalList* intervals;
  GlobalMarkTable.GetMarkData(mark, d, intervals);
  if (d != NULL)
  {
    d->GotoMark(intervals);
  }
}

// QueryEndSession -- see if all the documents are ready to end their
// session
int
PWordBase::QueryEndSession(int local, int confirm)
{
  for (Document* d = GetFirstDocument(); d != NULL; d = d->GetNextDocument())
  {
    if (!d->QueryEndSession(local, confirm))
    {
      return(FALSE);
    }
  }
  return(TRUE);
}

void
PWordBase::Terminate()
{
  Document* doc = GetFirstDocument();
  while (doc != NULL)
  {
    Document* next_doc = doc->GetNextDocument();
    delete doc;
    doc = next_doc;
  }
  PWordPresentation::Terminate();
}

// private method
void NEAR
PWordBase::AddDocument(Document* document)
{
  document->SetNextDocument(PWordBase::first_document);
  PWordBase::first_document = document;
}

void
PWordBase::RemoveDocument(Document* d)
{
  Document** place = &PWordBase::first_document;
  for (;;)
  {
    Document* doc = *place;
    if (doc == NULL)
    {
#ifndef NDEBUG
      syserr("PWordBase::CloseDocument -- document not found");
#endif
      break;
    }
    if (doc == d)
    {
      *place = d->GetNextDocument();
      delete d;
      break;
    }
    place = &doc->GetNextDocument();
  }
}

Document* NEAR
PWordBase::NewDocument(Document* d)
{
  if (d != NULL)
  {
    if (d->GetError())
    {
      delete d;
      d = NULL;
    }
    else
    {
      AddDocument(d);
    }
  }
  return(d);
}

void
PWordBase::RevertDocument(Document* d)
{
  Document* newd = Document::MakeForRevert(d);
  if (newd != NULL)
  {
    AddDocument(newd);
    RemoveDocument(d);
  }
}

Document*
PWordBase::GetDocumentByPathName(char* path_name)
{
  for (Document* d=GetFirstDocument(); d; d=d->GetNextDocument())
  {
    if (! strcmp(path_name, d->GetPathName()))
    {
      return d;
    }
  }
  return 0;
}

void
PWordBase::DelayFormat()
{
  for (Document* d = GetFirstDocument(); d; d = d->GetNextDocument())
  {
    d->DelayFormat();
  }
}

void
PWordBase::NewPrinter()
{
  MouseCursor::StartLongActivity();
  UnmarkCookieConnections();
  {
    for (Document* d = GetFirstDocument(); d; d = d->GetNextDocument())
    {
      DocumentContent* conte = d->GetDocumentContent();
      conte->MarkCookieConnections(0);
      (conte->GetUndo())->Clear();
    }
  }
  GlobalFontTable.RemoveUnmarkedEntries();
  GlobalFontTable.Fill(Printer_View->GetDC());
  RATEntry::GC();
  ::RegenerateAttributes();
  PWordBase::DelayFormat();
  MouseCursor::EndLongActivity();
}

void
PWordBase::RedisplayHidden()
{
  attr att = 0;
  bool hidden = False;
  
  MouseCursor::StartLongActivity();
  for (Document* d = GetFirstDocument(); d != NULL; d = d->GetNextDocument())
  {
    for (TextFlow* tf = d->GetDocumentContent()->GetFirstTextFlow();
	 tf != NULL; tf = tf->GetNext())
    {
      for (Paragraph* p = tf->GetFirstParagraph();
	   p != NULL; p = p->GetNextParagraph())
      {
	p->RedisplayHidden(att, hidden);
      }
    }
  }
  DocumentWindow::force_touch_caret();
  MouseCursor::EndLongActivity();
}

void
PWordBase::StyleChange(uword style)
{
  MouseCursor::StartLongActivity();
  GlobalDerivTable.ResolveEntriesInheritingStyle(style);
  for (Document* d = GetFirstDocument(); d; d = d->GetNextDocument())
  {
    d->StyleChange(style);
  }
  MouseCursor::EndLongActivity();
}

void
PWordBase::control_scroll_bar()
{
  for (Document* d = GetFirstDocument(); d != NULL; d = d->GetNextDocument())
  {
    d->GetDocumentContent() ->control_scroll_bar();
  }
}

void
PWordBase::CheckWindowCount()
{
  static int too_many_windows_warning_issued = False;
  if (!too_many_windows_warning_issued)
  {
    int count = 0;
    for (Document* d = GetFirstDocument();
	 d != NULL; d = d->GetNextDocument())
    {
      for (DocumentWindow* dw = (d->GetDocumentPresentation()
				 ->GetFirstDocWindow());
	   dw != NULL;
	   dw = dw->GetNextDocWindow())
      {
	++count;
	if (WINDOW_LIMIT <= count)
	{
	  too_many_windows_warning_issued = True;
	  Issue(S_ManyDocsMsg, MB_ICONHAND | MB_OK);
	}
      }
    }
  }
}

// The base is responsible for dispatching a few events,
#ifdef BW3_DISPATCH
LRESULT_T
PWordBase::Dispatch(bool menu_state_p, WORD command)
#else /* BW3_DISPATCH */
long
PWordBase::Dispatch(int command, int menu_state_p)
#endif /* BW3_DISPATCH */
{
  switch (command)
  {
   case IDM_File_WC:
    if (Selected_Window == NULL)
    {
      return(disabled_command(menu_state_p));
    }
    if (!menu_state_p)
    {
#ifdef BW3_FILEVERSIONSAVE
      if (PWordPresentation::ControlKey())
      {
	dword v1 = Selected_Document->GetFileVersion();
	dword v2 = Selected_Document->GetFileMinerVersion();
	dword v3 = Selected_Document->GetFileBetaVersion();
	dword v4 = Selected_Document->GetFileMinerBetaVersion();
	IssueVA("File Save Version\n\n%08d-%08d\n%08d-%08d", MB_OK, v1, v2, v3, v4);
      }
      else
      {
	StatDialog stat_dialog;
	stat_dialog.Go();
      }
#else /* BW3_FILEVERSIONSAVE */
      StatDialog stat_dialog;
      stat_dialog.Go();
#endif /* BW3_FILEVERSIONSAVE */
    }
    break;
    
   case IDM_File_AutoSave:
    if (!menu_state_p)
    {
      AutoSaveDialog dlg;
      dlg.Go();
    }
    break;
    
   case IDM_File_Exit:
    if (!menu_state_p)
    {
      MouseCursor::Arrow();
      if (PWordBase::QueryEndSession(True, True))
      {
	Terminate();
	return(1);
      }
    }
    break;
    
   case IDM_File_New:
    if (!menu_state_p)
    {
      MouseCursor::StartLongActivity();
      NewDocument(Document::MakeNew());
      MouseCursor::EndLongActivity();
    }
    break;
    
   case IDM_File_Open:
    if (!menu_state_p)
    {
      char filename[MAX_PATH + 1];
#ifdef BW3_FILEDLG
      strcpy(filename, S_WildCard);
      if (FileOpenDlg(filename, S_WildCard2) && *filename)
      {
	main_window->Update();  // clear screen
	char* fn = filename + strlen(filename) + 1;
	if (*fn != '\0')
	{
	  char openfile[MAX_PATH + 1];
	  strcpy(openfile, filename);
	  char* dir = openfile + strlen(filename);
	  *dir++ = '\\';	// directory separator
	  while ((*fn != '\0') &&
		 fn <= filename + MAX_PATH)
	  {
	    strcpy(dir, fn);
#ifndef _WIN32
	    ::AnsiUpper(openfile);
#endif /* _WIN32 */
	    PWordBase::OpenFile(openfile);
	    fn = fn + strlen(fn) + 1;
	  }
	}
	else
	{
#ifndef _WIN32
	  ::AnsiUpper(filename);
#endif /* _WIN32 */
	  PWordBase::OpenFile(filename);
	}
      }
#else /* BW3_FILEDLG */
      strcpy(filename, S_WildCard);
      if (FileOpenDlg(filename) && *filename)
      {
	main_window->Update();  // clear screen
	Document* d = GetDocumentByPathName(filename);
	if (d==NULL)
	{
	  Document* newd = Document::MakeFromFile(filename);
	  NewDocument(newd);
	}
	else if (IssueVA(S_AlreadyOpenMsg,
			  MB_ICONEXCLAMATION | MB_OKCANCEL,
			  FileUtil::GetFileNameOnly(filename))
		 == IDOK)
	{
	  d->Activate();
	}
      }
#endif /* BW3_FILEDLG */
    }
    break;
    
   case IDM_File_PrinterSetup:
    if (!menu_state_p)
    {
      PrinterInfo* new_printer_info = PrinterInfo::Setup(Printer_Info);
      if (new_printer_info)
      {
	delete Printer_Info;
	Printer_Info = new_printer_info;
	PWordPresentation::NewPrinter();
      }
    }
    break;
    
   case IDM_Location_RemoveMark:
    if (!Menu::item_exists_p(Menu_Type_MARK))
    {
      return(disabled_command(menu_state_p));
    }
    if (!menu_state_p)
    {
      int mark = Menu::go_dialog(Menu_Type_MARK, S_remove_mark_title);
      if (0 <= mark)
      {
	GlobalMarkTable.RemoveMark(mark);
      }
    }
    break;
    
#ifndef NDEBUG
   default:
    syserr("Unknown message in pwordbas: %d", command);
#endif
  }
  // MF_ENABLED == 0
  return(0);
}

void
PWordBase::no_more_memory()
{
  ::MessageBox((HWND) 0,
		S_no_more_memory, NULL, MB_SYSTEMMODAL | MB_OK | MB_ICONSTOP);
}

void
PWordBase::MemoryEmergency()
{
  if (!PWordPresentation::event_loop_started_p)
  {
    ::MessageBox((HWND) 0,
		  S_memory_emergency_on_startup,
		  NULL, MB_SYSTEMMODAL | MB_OK | MB_ICONSTOP);
    ExitPWord();
  }
  
  Issue(S_memory_emergency_1, MB_OK | MB_ICONSTOP);
  if (first_document != NULL)
  {
    Document* d;
    int dirty = False;
    for (d = GetFirstDocument(); d != NULL; d = d->GetNextDocument())
    {
      if (d->GetDocumentContent() ->GetDirty() && d != Selected_Document)
      {
	dirty = True;
      }
    }
    if (dirty
	&& (Issue(S_memory_emergency_2, MB_YESNO | MB_ICONQUESTION) == IDYES))
    {
      // old `PWordBase::CloseOtherDocuments'
      // close all documents other than the current one, asking the user
      // on each one whether or not he wants to save or not
      d = GetFirstDocument();
      while (d != NULL)
      {
	Document* next = d->GetNextDocument();
	if (d != Selected_Document)
	{
	  d->QueryEndSession(True /*local*/, True /*confirm*/);
	}
	d = next;
      }
    }
  }
  if (Issue(S_memory_emergency_3, MB_YESNO | MB_ICONQUESTION) == IDYES)
  {
    ExitPWord(1);
  }
}

// public method(replace constructor)
void
PWordBase::init(HINSTANCE hInstance,
		HINSTANCE hPrevInstance, char* lpszCmdLine, int nCmdShow)
{
  PWordPresentation::hInstance = hInstance;
  PWordPresentation::hPrevInstance = hPrevInstance;
  PWordPresentation::nCmdShow = nCmdShow;
  
#ifndef BW3_FILEDLG
  // create an unopened fileopen dialog.  This maintains a list of file names.
  file_open_dialog = new FileOpenDialog;
#endif /* BW3_FILEDLG */
  
  Printer_Info = new PrinterInfo;
  Printer_Info->SetupDefPrinter();
  
  // initializes the attribute subsystem
  InitAttributeSystem();
  
  // initialize the presentation
  if (!PWordPresentation::Init())
  {
    return;
  }
  
  // register our clipboard format
  Clipboard_Format = ::RegisterClipboardFormat(S_app_name);
  
  // make a place to remember "again" data
  Again::init();

#ifdef BW3_REGCHECK
  RegistoryCheck();
#endif /* BW3_REGCHECK */

  // maybe the user wants to open a document or get an automatic new window?
  if (!CommandLine(lpszCmdLine))
  {
    if (Pref_open_new)
    {
      NewDocument(Document::MakeNew());
    }
  }
}


#ifdef BW3_REGCHECK
void
PWordBase::RegistoryCheck()
{
  // get Registry

  // Checking registries are as follows.
  // HKEY_CLASSES_ROOT\.bw\	"bw_auto_file"
  // HKEY_CLASSES_ROOT\.bw\Content Type	"application/bw"
  // HKEY_CLASSES_ROOT\bw_auto_file\ "BW file"
  // HKEY_CLASSES_ROOT\bw_auto_file\AlwaysshowExt ""
  // HKEY_CLASSES_ROOT\bw_auto_file\EditFlags	00 00 00 00
  // HKEY_CLASSES_ROOT\bw_auto_file\DefaultIcon\ "$path\bw3.exe,0"
  // HKEY_CLASSES_ROOT\bw_auto_file\shell\open\command	"$path\bw3.exe %1"

  HKEY hk;
  DWORD type;
  DWORD size;
  ubyte* buf;
  LONG ret;
  bool update_need_p = false;
  bool bw_key_exist_p = false;
  bool bw_auto_key_exsit_p = false;
  bool bw_defaulticon_exsit_p = false;
  bool bw_shell_cmd_exsit_p = false;
  
  // HKEY_CLASSES_ROOT\.bw
  static char* bw[] =
  {	
    S_NIL,
    "Content Type",
    0,
  };
  static char* bw_val[] =
  {
    "bw_auto_file",
    "application/bw",
    0,
  };
  char* bw_key = ".bw";
  ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_key, 0, KEY_READ, &hk);
  if (ret == ERROR_SUCCESS)
  {
    bw_key_exist_p = true;
  
    char** p;
    char** q;
    for (p = bw, q = bw_val; *p != 0; p++, q++)
    {
      ret = ::RegQueryValueEx(hk, *p, 0, &type, (LPBYTE)0, &size);
      buf = new ubyte[size];
      ret = ::RegQueryValueEx(hk, *p, 0, &type, (LPBYTE)buf, &size);
      if (strcmp((const char*)buf, *q))
      {
	update_need_p = true;
      }
      delete buf;
    }
    ret = ::RegCloseKey(hk);
  }
  else
  {
    update_need_p = true;
  }
  
  // HKEY_CLASSES_ROOT\bw_auto_file
  static char* bw_auto[] =
  {
    S_NIL,
    "AlwaysshowExt",
    "EditFlags",
    0,
  };
  char* bw_auto_key = "bw_auto_file";
  ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_auto_key, 0, KEY_READ, &hk);
  if (ret == ERROR_SUCCESS)
  {
    bw_auto_key_exsit_p = true;
    int i = 0;
    char** p;
    for (p = bw_auto; *p != 0; p++)
    {
      ret = ::RegQueryValueEx(hk, *p, 0, &type, (LPBYTE)0, &size);
      size ++;
      buf = new ubyte[size];
      ret = ::RegQueryValueEx(hk, *p, 0, &type, (LPBYTE)buf, &size);
      switch (i++)
      {
      case 0:	// S_NIL
	if (strcmp((const char*)buf, S_BwFile))
	{
	  update_need_p = true;
	}
	break;
      case 1:	// AlwaysshowExt
	if (buf[0] != '\0')
	{
	  update_need_p = true;
	}
	break;
      case 2:	// EditFlags
        {
	  dword* efp = (dword*)buf;
	  if (*efp != 0)
	  {
	    update_need_p = true;
	  }
        }
	break;
      }
      delete buf;
    }
    ret = ::RegCloseKey(hk);
  }
  else
  {
    update_need_p = true;
  }
  
  // get BeatWord executable file path
  char executable_filename[MAX_PATH + 1];
  ::GetModuleFileName(NULL, executable_filename, MAX_PATH + 1);
  int n = strlen(executable_filename);
  char* reg_icon_value = new char[n + 1 + 2];
  strcpy(reg_icon_value, executable_filename);
  reg_icon_value[n] = ',';
  reg_icon_value[n + 1] = '0';
  reg_icon_value[n + 2] = '\0';
  char* reg_shell_cmd = new char[n + 1 + 3];
  strcpy(reg_shell_cmd, executable_filename);
  reg_shell_cmd[n] = ' ';
  reg_shell_cmd[n + 1] = '%';
  reg_shell_cmd[n + 2] = '1';
  reg_shell_cmd[n + 3] = '\0';

  // HKEY_CLASSES_ROOT\bw_auto_file\DefaultIcon
  char* bw_defaulticon_key = "bw_auto_file\\DefaultIcon";
  ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_defaulticon_key, 0, KEY_READ, &hk);
  if (ret == ERROR_SUCCESS)
  {
    bw_defaulticon_exsit_p = true;
    ret = ::RegQueryValueEx(hk, S_NIL, 0, &type, (LPBYTE)0, &size);
    buf = new ubyte[size];
    ret = ::RegQueryValueEx(hk, S_NIL, 0, &type, (LPBYTE)buf, &size);
    if (strcmp((const char*)buf, reg_icon_value))
    {
      update_need_p = true;
    }
    delete buf;
    ret = ::RegCloseKey(hk);
  }

  // HKEY_CLASSES_ROOT\bw_auto_file\shell\open\command	"$path\bw3.exe %1"
  char* bw_shell_cmd_key = "bw_auto_file\\shell\\open\\command";
  ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_shell_cmd_key, 0, KEY_READ, &hk);
  if (ret == ERROR_SUCCESS)
  {
    bw_shell_cmd_exsit_p = true;
    ret = ::RegQueryValueEx(hk, S_NIL, 0, &type, (LPBYTE)0, &size);
    buf = new ubyte[size];
    ret = ::RegQueryValueEx(hk, S_NIL, 0, &type, (LPBYTE)buf, &size);
    if (strcmp((const char*)buf, reg_shell_cmd))
    {
      update_need_p = true;
    }
    delete buf;
    ret = ::RegCloseKey(hk);
  }

  // update registory
  if (update_need_p)
  {
    DWORD diposition_p;
    // HKEY_CLASSES_ROOT\.bw
    if (!bw_key_exist_p)
    {

      ret = ::RegCreateKeyEx(HKEY_CLASSES_ROOT, bw_key, 0, S_NIL,
			     REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0,
			     &hk, &diposition_p);
    }
    else
    {
      ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_key, 0, KEY_ALL_ACCESS, &hk);
    }
    if (ret == ERROR_SUCCESS)
    {
      char** p;
      char** q;
      for (p = bw, q = bw_val; *p != 0; p++, q++)
      {
	ret = ::RegSetValueEx (hk, *p, 0, REG_SZ, (const unsigned char*)*q, strlen(*q));
      }
      ret = ::RegCloseKey(hk);
    }

    // HKEY_CLASSES_ROOT\bw_auto_file
    if (!bw_auto_key_exsit_p)
    {
      ret = ::RegCreateKeyEx(HKEY_CLASSES_ROOT, bw_auto_key, 0, S_NIL,
			     REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0,
			     &hk, &diposition_p);
    }
    else
    {
      ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_auto_key, 0, KEY_ALL_ACCESS, &hk);
    }
    if (ret == ERROR_SUCCESS)
    {
      char** p;
      int i = 0;
      for (p = bw_auto; *p != 0; p++)
      {
	switch (i++)
	{
	case 0:	// S_NIL
	  ret = ::RegSetValueEx (hk, *p, 0, REG_SZ,
				 (const unsigned char*)S_BwFile, strlen(S_BwFile));
	  break;
	case 1:	// AlwaysshowExt
	  ret = ::RegSetValueEx (hk, *p, 0, REG_SZ,
				 (const unsigned char*)S_NIL, 0);
	  break;
	case 2:	// EditFlags
	  {
	    DWORD d = 0;
	    ret = ::RegSetValueEx (hk, *p, 0, REG_BINARY,
				   (const unsigned char*)&d, 4);
	  }
	  break;
	}
      }
      ret = ::RegCloseKey(hk);
    }

    // HKEY_CLASSES_ROOT\bw_auto_file\DefaultIcon\ "$path\bw3.exe,0"
    if (!bw_defaulticon_exsit_p)
    {
      ret = ::RegCreateKeyEx(HKEY_CLASSES_ROOT, bw_defaulticon_key, 0, S_NIL,
			     REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0,
			     &hk, &diposition_p);
    }
    else
    {
      ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_defaulticon_key, 0, KEY_ALL_ACCESS, &hk);
    }
    if (ret == ERROR_SUCCESS)
    {
      ret = ::RegSetValueEx (hk, S_NIL, 0, REG_SZ,
			     (const unsigned char*)reg_icon_value,
			     strlen(reg_icon_value));
      ret = ::RegCloseKey(hk);
    }

    // HKEY_CLASSES_ROOT\bw_auto_file\shell\open\command	"$path\bw3.exe %1"
    if (!bw_shell_cmd_exsit_p)
    {
      ret = ::RegCreateKeyEx(HKEY_CLASSES_ROOT, bw_shell_cmd_key, 0, S_NIL,
			     REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, 0,
			     &hk, &diposition_p);
    }
    else
    {
      ret = ::RegOpenKeyEx(HKEY_CLASSES_ROOT, bw_shell_cmd_key, 0, KEY_ALL_ACCESS, &hk);
    }
    if (ret == ERROR_SUCCESS)
    {
      ret = ::RegSetValueEx (hk, S_NIL, 0, REG_SZ,
			     (const unsigned char*)reg_shell_cmd,
			     strlen(reg_shell_cmd));
      ret = ::RegCloseKey(hk);
    }
  }
  delete reg_icon_value;
  delete reg_shell_cmd;
}
#endif /* BW3_REGCHECK */

// public method(replace of destructor)
void
PWordBase::term()
{
  PWordPresentation::term();
}

#ifdef BW3_FILEDLG
void
PWordBase::OpenFile(char* openfile)
{
  Document* d = GetDocumentByPathName(openfile);
  if (!d)
  {
    Document* newd = Document::MakeFromFile(openfile);
    NewDocument(newd);
#ifdef BW3_RECENTOPEN
    PWordBase::RegisterRecentOpenFileName(openfile);
#endif /* BW3_RECENTOPEN */
  }
  else if (IssueVA(S_AlreadyOpenMsg,
		   MB_ICONEXCLAMATION | MB_OKCANCEL,
		   FileUtil::GetFileNameOnly(openfile))
	   == IDOK)
  {
    d->Activate();
  }
}
#endif /* BW3_FILEDLG */

#ifdef BW3_RECENTOPEN

static char document_directory[MAX_PATH + 1];

void
PWordBase::RegisterRecentOpenFileName(char* filename)
{
  Pref_file_string10.add_string(filename);
  FileUtil::GetPathNameOnly(document_directory, filename);
  Pref_document_directory = document_directory;
  MakeUpRecentOpenMenu();	// NOTE: this call breaks filename
}

void
PWordBase::MakeUpRecentOpenMenu()
{
  int i;
  for (i = 0; i < 10; ++i)
  {
    Menu::delete_menu(Menu_Type_RECENTOPEN, i);
  }
  for (i = 0; i < 10; ++i)
  {
    char* s = Pref_file_string10.get_string(i);
    if (s[0] != '\0')
    {
      Menu::add_menu(Menu_Type_RECENTOPEN, i, s);
    }
  }
}

#endif /* BW3_RECENTOPEN */

#define BW3_CMDLINE

bool
PWordBase::CommandLine(char* cmd_line)
{
#ifdef BW3_CMDLINE
  enum Action
  {
    Action_error,
    Action_other,
    Action_print,
    Action_delete_registory,
  };

  struct Option
  {
    char* str;
    Action act;
  } opt[] =
  {
    { "/d",		Action_delete_registory },
    { "/print",		Action_print },
    { "/p",		Action_print },
    0,
  };

  char* p = cmd_line;
  while (*p == ' ')
  {
    p++;
  }

  bool print_p = false;
  bool delete_registory_p = false;
  bool open_p = false;

  while (p && *p != '\0')
  {
    Action act = Action_other;
    char* next = 0;
    for (Option* o = opt; o->str != 0 ; o++)
    {
      if (!strncmp (p, o->str, strlen(o->str)))
      {
	act = o->act;
	next = p + strlen(o->str);
	while (*next == ' ')
	{
	  next++;
	}
	break;
      }
    }
    switch (act)
    {
    case Action_error:
      // unknown option
      ::MessageBox(0, p, "unknown option", MB_OK);
      break;

    case Action_other:
      next = p;
      while (*next != '\0')
      {
	if (*next == ' ')
	{
	  if (*(next + 1) != '\0' &&
	      *(next + 2) == ':')
	  {
	    *next = '\0';
	    next++;
	    break;
	  }
	  else if (*(next + 1) == '\\' &&
		   *(next + 2) == '\\')
	  {
	    *next = '\0';
	    next++;
	    break;
	  }
	}
	next ++;
      }
      {
	char long_path_name[MAX_PATH + 1];
	if (!FileUtil::IsAbsolute(p))
	{
	  char fullname[MAX_PATH + 1] = "";
	  FileUtil::GetDir(fullname);
	  FileUtil::ConcatPathAndFileName(fullname, p);
	  FileUtil::GetLongFileName(fullname, long_path_name, sizeof(long_path_name));
	}
	else
	{
	  FileUtil::GetLongFileName(p, long_path_name, sizeof(long_path_name));
	}
	//::MessageBox(0, long_path_name, "file", MB_OK);
	NewDocument(Document::MakeFromFile(long_path_name));
#ifdef BW3_RECENTOPEN
	PWordBase::RegisterRecentOpenFileName(long_path_name);
#endif /* BW3_RECENTOPEN */
      }
      open_p = true;
      break;

    case Action_print:
      print_p = true;
      break;

    case Action_delete_registory:
      delete_registory_p = true;
      break;
    }
    p = next;
  }
  return open_p;
  
#else /* BW3_CMDLINE */
  if (cmd_line && *cmd_line)
  {
    char* filename = strtok(cmd_line, " ");
    do 
    {
#ifndef _WIN32
      ::AnsiUpper(filename);
#endif /* _WIN32 */
      char fullname[MAX_PATH + 1] = "";
      if (!FileUtil::IsAbsolute(filename))
      {
	FileUtil::GetDir(fullname);
	FileUtil::ConcatPathAndFileName(fullname, filename);
      }
#ifdef _WIN32
      else
      {
	char* p = strchr(filename, '"');
	if (p)
	{
	  // explorer double click argument.
	  // ex.) C:\TEMP\"C:\TEMP\1.BW"
	  char* end = strchr(++p, '"');
	  if (end)
	  {
	    *end = '\0';
	    strncpy(fullname, p, MAX_PATH);
	  }
	}
	else
	{
	  strncpy(fullname, filename, MAX_PATH);
	}
      }
#else /* _WIN32 */
      else
      {
	strncpy(fullname, filename, MAX_PATH);
      }
#endif /* _WIN32 */
      NewDocument(Document::MakeFromFile(fullname));
#ifdef BW3_RECENTOPEN
      PWordBase::RegisterRecentOpenFileName(fullname);
#endif /* BW3_RECENTOPEN */
      filename = strtok(NULL, " ");
    }
    while (filename);
    return true;
  }
  else 
  {
    return false;
  }
#endif /* BW3_CMDLINE */
}
