// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: pwordpre.h,v 3.4 2000/05/04 13:44:08 kudou Exp $
// define the PWordPresentation class
// This class maintains the global pWord information
// related to the Windows interface.

#ifndef PWORDPRE_H
#define PWORDPRE_H

// All slots and methods of this class are declared STATIC.
// Keep this rule for best performance.  (konno)

// Mask value of display control flag.
#define DISPLAY_FRAME_LINE	(1 << 0)
#define DISPLAY_FRAME_MARGIN	(1 << 1)
#define DISPLAY_PARA_MARGIN	(1 << 2)
#define DISPLAY_FLOW_LINE	(1 << 3)

class AnsiDialog;
class SearchDialog;
class VTTimeDialog;

// this is here, rather than with all the other external variables
// in pword.h, cuz otherwise everybody'd hafta include windows.h

extern UINT Clipboard_Format;

class PWordPresentation
{
private:
  static AnsiDialog* ansi_dialog;
  static EditMode edit_mode_status;
#ifdef _WIN32
  static HHOOK old_hook_handle;
#else /* _WIN32 */
  static FARPROC old_hook_proc;
#endif /* _WIN32 */
  static MessBox* messbox;
  static PageBox* pagebox;
  static Preferences* preferences;
  static SearchDialog* search_dialog;
  static VTTimeDialog* vttime_dialog;
  static int error;
  static int display_flags;
public:
  static HINSTANCE hInstance;
  static HINSTANCE hPrevInstance;
  static int event_loop_started_p;
  static int nCmdShow;
  
  // exported function
public:
  static LRESULT_T FAR PASCAL _export HelpHookProc(int nCode, WPARAM_T wParam, LPARAM_T lParam);
  static LRESULT_T HelpHookProc_ (int nCode, WPARAM_T wParam, LPARAM_T lParam);

  // all methods are STATIC
private:
  static void NEAR control_display();
  static void NEAR SetEditMode(EditMode mode, int do_message);
public:
  static AnsiDialog* GetAnsiDialog();
  static EditMode GetEditModeStatus();
  static HDC MakePrinterDC();
  static MessBox* GetMessBox();
  static PageBox* GetPageBox();
  static SearchDialog* GetSearchDialog();
  static bool CheckExpiration();
  static int ControlKey();
  static int GetEditModeCommand();
  static int Go();
  static int Init();
  static int IsToolBox(HWND);
  static int ShiftKey();
  static int display_flow_line_p();
  static int display_frame_line_p();
  static int display_frame_margin_p();
  static int display_para_margin_p();
  static long Dispatch(int command);
  static long HandleEditMode(int command, int menu_state_p);
  static long handle_display(int menu_state_p, int* pref_ptr);
  static void ChangeEditMode(EditMode mode);
  static void EnableModeless(bool);
  static void KillPrinterDC();
  static void NewPrinter();
  static void Register();
  static void StatusOut(char*);
  static void StatusOutPermanent(char*);
  static void Terminate();
  static void Update();
  static void redraw_all_windows();
  static void term();
};

inline AnsiDialog* 
PWordPresentation::GetAnsiDialog()
{
  return(PWordPresentation::ansi_dialog);
}

inline SearchDialog* 
PWordPresentation::GetSearchDialog()
{
  return(PWordPresentation::search_dialog);
}

inline MessBox* 
PWordPresentation::GetMessBox()
{
  return(PWordPresentation::messbox);
}

inline PageBox* 
PWordPresentation::GetPageBox()
{
  return(PWordPresentation::pagebox);
}

// get edit mode status
inline EditMode
PWordPresentation::GetEditModeStatus()
{
  return(PWordPresentation::edit_mode_status);
}

// Returns non-zero, if frame line redisplay is needed.
inline int
PWordPresentation::display_frame_line_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FRAME_LINE);
}

// Returns non-zero, if frame margin redisplay is needed.
inline int
PWordPresentation::display_frame_margin_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FRAME_MARGIN);
}

// Returns non-zero, if paragraph margin redisplay is needed.
inline int
PWordPresentation::display_para_margin_p()
{
  return(PWordPresentation::display_flags & DISPLAY_PARA_MARGIN);
}

// Returns non-zero, if flow line redisplay is needed.
inline int
PWordPresentation::display_flow_line_p()
{
  return(PWordPresentation::display_flags & DISPLAY_FLOW_LINE);
}

#endif /* PWORDPRE_H */
