// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: rats.cpp,v 3.3 2000/05/04 13:44:09 kudou Exp $
// implement the RATEntry class for entries in the table of fully
// resolved attributes

#include "pword.h"
#include "rats.h"
#include "attribut.h"
#include "atts.h"
#include "fonts.h"
#include "pref.h"
#include "sjis.h"
#include "view.h"

// ------------------------------------------------------------
// FontMetric class

// FontMetric::Get requests "sizeof(FontMetric) * FONT_METRIC_NEW_ELEMENTS"
// bytes to xmalloc.  If you increase this value, speed is up, but more
// memory is required.
#define FONT_METRIC_NEW_ELEMENTS 10

// log2(sizeof(int) * 128)
#ifdef _WIN32
#define LOG2_OF_CACHE_SIZE 9
#else /* _WIN32 */
#define LOG2_OF_CACHE_SIZE 8
#endif /* _WIN32 */

DEFINE_SMARTNEW(FontMetric)

static HFONT selected_font = 0;
static FontMetric* selected_font_metric = 0;
static FontMetric* STATIC_NEAR hashed_roots[256] = {NULL};

// private static method
void NEAR
FontMetric::KillDeviceResources()
{
  if (selected_font)
  {
    SelectObject(Printer_View->GetDC(), GetStockObject(SYSTEM_FONT));
  }
  selected_font = 0;
  selected_font_metric = NULL;
}

// private method
HDC NEAR
FontMetric::PrinterDC()
{
  HDC dc = Printer_View->GetDC();
  if (selected_font_metric != this)
  {
    selected_font_metric = this;
    HFONT font = CreateFontIndirect(this->logfont);
    SelectObject(dc, font);
    if (selected_font)
    {
      DeleteObject(selected_font);
    }
    selected_font = font;
  }
  return(dc);
}

// private method
int NEAR
FontMetric::GetImmediateWidth(sjis c)
{
  HDC dc = this->PrinterDC();
  
  char str[4];
  int length = 1;
  str[0] = str[1] = str[2] = str[3] = (char) c;
  if (IsKanji(c))
  {
    str[0] = str[2] = (char) ((c) >> BITS_PER_CHAR);
    length = 2;
  }
#ifdef _WIN32
  SIZE s1, s2;
  GetTextExtentPoint32(dc, str, length * 2, &s1);
  GetTextExtentPoint32(dc, str, length, &s2);
  return s1.cx - s2.cx;
#else /* _WIN32 */
  return(LOWORD(GetTextExtent(dc, str, length * 2))
	 - LOWORD(GetTextExtent(dc, str, length)));
#endif /* _WIN32 */
}

// public lexical method
int
FontMetric::GetWidth(sjis c)
{
  int width;
  
  // This code depend on SJIS code design.  See sjis.h.
  // 0x00xx : ansi character
  // 0x01xx : kana character
  if (c < 0x0200)
  {
    width = this->fixed_width;
    if (width == 0)
    {
      int** cache_place = &this->caches[0];
      if (0x0080 <= c)
      {
	++cache_place;
	if (0x0100 <= c)
	{
	  ++cache_place;
	}
      }
      int* cache = *cache_place;
      if (cache == NULL)
      {
	assert(sizeof(int) * 128 == (1 << LOG2_OF_CACHE_SIZE));
	*cache_place = cache = (int *) xmalloc_on_log2(LOG2_OF_CACHE_SIZE);
	memset(cache, 0, sizeof(int) * 128);
      }
      int index = c & 0x007f;
      width = cache[index];
      if (width == 0)
      {
	width = (int) Printer_View->ScaleLunitX(this->GetImmediateWidth(c));
	cache[index] = width;
      }
    }
  }
  else
  {
    width = this->kanji_width;
    if (width == 0)
    {
      width = (int) Printer_View->ScaleLunitX(this->GetImmediateWidth(c));
    }
  }
  return(width);
}

// public lexical method
void
FontMetric::SimulatedLogfont(LOGFONT* logfont, View* view)
{
  memcpy(logfont, this->logfont, sizeof(LOGFONT));
  if (view->GetDeviceType() != PRINTER)
  {
    logfont->lfHeight = -(view->ScaleDunitY(this->logfont_height));
    logfont->lfWidth = view->ScaleDunitX(this->average_width);
    logfont->lfWeight = this->weight;
    logfont->lfItalic = this->italic;
    logfont->lfStrikeOut = this->struck_out;
    logfont->lfCharSet = this->char_set;
    logfont->lfQuality = PROOF_QUALITY;
    logfont->lfPitchAndFamily = (this->pitch_and_family & 0xf0);
  }
}

// private method
void NEAR
FontMetric::Rotate(FontMetric** root_ptr)
{
  FontMetric* parent = this->parent;
  FontMetric* god = parent->parent;
  this->parent = god;
  parent->parent = this;
  if (god == NULL)
  {
    *root_ptr = this;
  }
  else if (parent == god->small_)
  {
    god->small_ = this;
  }
  else
  {
    god->large_ = this;
  }
  
  FontMetric* son;
  if (this == parent->small_)
  {
    parent->small_ = son = this->large_;
    this->large_ = parent;
  }
  else
  {
    parent->large_ = son = this->small_;
    this->small_ = parent;
  }
  if (son != NULL)
  {
    son->parent = parent;
  }
}

// private method
// Move THIS to top node of binary tree.
void NEAR
FontMetric::Transform(FontMetric** root_ptr)
{
  for (;;)
  {
    FontMetric* parent = this->parent;
    if (parent == NULL)
    {
      break;
    }
    FontMetric* god = parent->parent;
    if (god != NULL)
    {
      ((this == parent->small_) == (parent == god->small_) ? parent : this)
      ->Rotate(root_ptr);
    }
    this->Rotate(root_ptr);
  }
}

// static private method
FontMetric* NEAR
FontMetric::Get(LOGFONT* logfont)
{
  LOGFONT pure_logfont[1];
  memset(pure_logfont, 0, sizeof(LOGFONT));
  pure_logfont->lfHeight = logfont->lfHeight;
  pure_logfont->lfWidth = logfont->lfWidth;
  pure_logfont->lfEscapement = 0;
  pure_logfont->lfOrientation = 0;
  pure_logfont->lfWeight = logfont->lfWeight;
  pure_logfont->lfItalic = logfont->lfItalic;
  pure_logfont->lfUnderline = 0;
  pure_logfont->lfStrikeOut = logfont->lfStrikeOut;
  pure_logfont->lfCharSet = logfont->lfCharSet;
  pure_logfont->lfOutPrecision = logfont->lfOutPrecision;
  pure_logfont->lfClipPrecision = logfont->lfClipPrecision;
  pure_logfont->lfQuality = logfont->lfQuality;
  pure_logfont->lfPitchAndFamily = logfont->lfPitchAndFamily;
  strcpy((char*) pure_logfont->lfFaceName, (char*) logfont->lfFaceName);

  // Get hash value to X.
  unsigned char* s = (unsigned char*) pure_logfont;
  unsigned char x = 0;
  int count = sizeof(LOGFONT);
  do
  {
    x = x ^ (x << 1) ^ *s++;
  } while (--count);
  
  FontMetric** root_ptr = &hashed_roots[x];
  FontMetric** place = root_ptr;
  FontMetric* parent = NULL;
  FontMetric* fm;
  for (;;)
  {
    fm = *place;
    if (fm != NULL)
    {
      int diff = memcmp(pure_logfont, fm->logfont, sizeof(LOGFONT));
      if (diff == 0)
      {
	break;
      }
      parent = fm;
      place = diff < 0 ? &fm->small_ : &fm->large_;
    }
    else
    {
      // Make new node.
      fm = new FontMetric;
      *place = fm;
      memset(fm, 0, sizeof(FontMetric));
      fm->parent = parent;
      memcpy(fm->logfont, pure_logfont, sizeof(LOGFONT));
      
      TEXTMETRIC tm[1];
      HDC dc = fm->PrinterDC();
      GetTextFace(dc, LF_FACESIZE, fm->facename);
      GetTextMetrics(dc, tm);

      // Convert metrics to logical size.
      fm->ascent = (int) Printer_View->ScaleLunitY(tm->tmAscent);
      fm->descent = (int) Printer_View->ScaleLunitY(tm->tmDescent);
      fm->logfont_height = ((int)
			    (Printer_View->ScaleLunitY
			     (tm->tmHeight - tm->tmInternalLeading)));
      fm->average_width = (int) Printer_View->ScaleLunitX(tm->tmAveCharWidth);
      fm->overhang = (int) Printer_View->ScaleLunitX(tm->tmOverhang);

      // Copy un-scalable value.
      fm->weight = tm->tmWeight;
      fm->italic = tm->tmItalic;
      fm->struck_out = tm->tmStruckOut;
      fm->char_set = tm->tmCharSet;
      fm->pitch_and_family = tm->tmPitchAndFamily;
      
      if ((tm->tmPitchAndFamily & 0x01) == 0) // fixed pitch
      {
	if (tm->tmAveCharWidth == tm->tmMaxCharWidth)
	{
	  fm->fixed_width = ((int)
			     Printer_View->ScaleLunitX(tm->tmAveCharWidth));
	}
	if (tm->tmCharSet == SHIFTJIS_CHARSET)
	{
	  // using width of zenkaku hiragana "A"
	  int kanji_width = fm->GetImmediateWidth((sjis) 0x82a0);
	  
	  // fixing for buggy font
	  if (kanji_width <= tm->tmAveCharWidth)
	  {
	    kanji_width = tm->tmMaxCharWidth;
	    if (kanji_width <= tm->tmAveCharWidth)
	    {
	      kanji_width += kanji_width;
	    }
	  }
	  fm->kanji_width = (int) Printer_View->ScaleLunitX(kanji_width);
	}
      }
      break;
    }
  }
  fm->Transform(root_ptr);
  return(fm);
}

void NEAR
sweep(FontMetric* fm)
{
  while (fm != NULL)
  {
    xfree_on_log2(fm->caches[0], LOG2_OF_CACHE_SIZE);
    xfree_on_log2(fm->caches[1], LOG2_OF_CACHE_SIZE);
    xfree_on_log2(fm->caches[2], LOG2_OF_CACHE_SIZE);
    sweep(fm->small_);
    FontMetric* foo = fm;
    fm = fm->large_;
    delete foo;
  }
}

// static method
void
FontMetric::KillAllResources()
{
  FontMetric::KillDeviceResources();
}

// static method
void NEAR
FontMetric::Sweep()
{
  FontMetric::KillAllResources();
  for (int x = 0; x != 256; ++x)
  {
    sweep(hashed_roots[x]);
  }
  memset(hashed_roots, 0, sizeof(hashed_roots));
}

// public lexical method
FontMetric* 
FontMetric::get_tategaki_font_metric()
{
  FontMetric* result = this->tategaki_font_metric;
  if (result == NULL)
  {
    result = this;
    if (this->char_set == SHIFTJIS_CHARSET
	&& this->facename[0] != '@'
	&& strlen(this->facename) < LF_FACESIZE - 1)
    {
      LOGFONT logfont[1];
      *logfont = *this->logfont;
      logfont->lfFaceName[0] = '@';
      strcpy((char*) &logfont->lfFaceName[1], this->facename);
      result = FontMetric::Get(logfont);
      if (result->char_set != SHIFTJIS_CHARSET || result->facename[0] != '@')
      {
	result = this;
      }
    }
    this->tategaki_font_metric = result;
  }
  return(result);
}

// ------------------------------------------------------------
// RATEntry class

DEFINE_SMARTNEW(RATEntry)

RATEntry* RATEntry::all_list = NULL;

Enum_Desc print_quality_desc[] =
{
  { "Proof-Quality",	PROOF_QUALITY, },
  { "Default-Quality",	DEFAULT_QUALITY, },
  { "Draft-Quality",	DRAFT_QUALITY, },
  { "Default",		DEFAULT_QUALITY, },
  { "Draft",		DRAFT_QUALITY, },
  { "Proof",		PROOF_QUALITY, },
  { NULL,		DEFAULT_QUALITY, },
};

// private method
void NEAR
RATEntry::MakeFontPair(int kanjip, int facename, int* vals)
{
  LOGFONT logfont[1];
  
  // setup printer logfont
  if (facename == 0 || facename == AttsEntry::UNKNOWN)
  {
    memset(logfont, 0, sizeof(LOGFONT));
  }
  else
  {
    memcpy(logfont,
	    &(::get_font_entry(facename) .GetLOGFONT()), sizeof(LOGFONT));
    
    int num_steps = vals[CA_subscript];
    if (0 < num_steps)
    {
      num_steps = -num_steps;
    }
    num_steps += vals[CA_delta_size];
    int size = vals[CA_size];
    for (; 0 < num_steps; --num_steps)
    {
      size = StepTextSize(size, 1);
    }
    for (; num_steps < 0; ++num_steps)
    {
      size = StepTextSize(size, -1);
    }
    if (size < 0)
    {
      size = 1;
    }
    
    logfont->lfHeight = -(Printer_View->ScaleDunitY(Point_to_iu(size)));
    logfont->lfWidth = 0;
    logfont->lfEscapement = 0;
    logfont->lfOrientation = 0;
    logfont->lfWeight = vals[CA_bold] ? FW_BOLD : FW_NORMAL;
    logfont->lfItalic = vals[CA_italic] ? 1 : 0;
    logfont->lfUnderline = 0;
    logfont->lfStrikeOut = vals[CA_strikeout];
    logfont->lfQuality = Pref_print_quality;
  }
  this->SetFontMetric(kanjip, FontMetric::Get(logfont));
}

void NEAR
RATEntry::MakeMyself()
{
  assert(this->at_index != 0);
  
  int* vals = ::get_atts_entry(this->at_index) .vals;
  
  int facename = vals[CA_facename2];
  if (facename == 0 || facename == AttsEntry::UNKNOWN)
  {
    facename = vals[CA_facename];
  }
  this->MakeFontPair(JISFONT, facename, vals);
  facename = vals[CA_facename];
  if (facename == 0 || facename == AttsEntry::UNKNOWN)
  {
    this->SetFontMetric(ROMAJIFONT, this->GetFontMetric(JISFONT));
  }
  else
  {
    this->MakeFontPair(ROMAJIFONT, facename, vals);
  }
}

// static method
void
RATEntry::GC()
{
  FontMetric::Sweep();
  for (RATEntry* rat = RATEntry::all_list; rat; rat = rat->chain)
  {
    rat->MakeMyself();
  }
}

RATEntry::RATEntry(unsigned int at_index)
{
  this->chain = RATEntry::all_list;
  RATEntry::all_list = this;
  this->at_index = at_index;
  this->MakeMyself();
}
