// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: rats.h,v 3.3 2000/05/04 13:44:09 kudou Exp $
// define classes for resolved attribute table

#ifndef RATS_H
#define RATS_H

#include "generics.h"
#include "smartnew.h"

// Array index.
#define ROMAJIFONT 0
#define JISFONT 1

class FontMetric
{
  friend class RATEntry;
  friend void NEAR sweep(FontMetric* fm);
  
private:
  // Binary search tree pointers.
  FontMetric* parent;
  FontMetric* small_;
  FontMetric* large_;
  FontMetric* tategaki_font_metric;
  
  // If this is a fixed pitch kanji font, KANJI_WIDTH is a kanji
  // character width.  Otherwise, this is not a kanji font or a variable
  // pitch font, and KANJI_WIDTH is a zero.
  int kanji_width;

  // If this is a fixed pitch font, FIXED_WIDTH is a font width,
  // otherwise, FIXED_WIDTH is a zero. */
  int fixed_width;
  
  // caches[0] : ansi low cache
  // caches[1] : ansi high cache
  // caches[2] : kana cache
  // each cache is vector of int[128]
  int* caches[3];

  // Pixel based logfont.
  LOGFONT logfont[1];

  // Assigned font name, not same as LOGFONT.lfFaceName.
  char facename[LF_FACESIZE];
  
  // Iunit based sizes.
  int ascent;
  int descent;
  int logfont_height;
  int average_width;
  int overhang;

  // Copy of TEXTMETRICS.  There has same types as Windows one.
  int weight;
  BYTE italic;
  BYTE struck_out;
  BYTE char_set;
  BYTE pitch_and_family;
  
public:
  REFER_SMARTNEW(FontMetric)
  
  // lexical method
private:
  HDC NEAR PrinterDC();
  int NEAR GetImmediateWidth(sjis c);
  void NEAR Rotate(FontMetric** root_ptr);
  void NEAR Transform(FontMetric** root_ptr);
public:
  BYTE GetCharSet();
  FontMetric* get_tategaki_font_metric();
  int GetAscent();
  int GetAverageWidth();
  int GetDescent();
  int GetOverhang();
  int GetWidth(sjis c);
  void SimulatedLogfont(LOGFONT* logfont, View* view);
  
  // static method
private:
  static FontMetric* NEAR Get(LOGFONT* logfont);
  static void NEAR KillDeviceResources();
  static void NEAR Sweep();
public:
  static void KillAllResources();
};

class RATEntry
{
private:
  static RATEntry* all_list;
  
private:
  // [ROMAJIFONT or JISFONT]
  // Call "GetFontMetric" and "SetFontMetric" to access this slot.
  FontMetric* font_metric[2];
  
  RATEntry* chain;
  unsigned int at_index;
  
public:
  RATEntry(unsigned int at_index);
  REFER_SMARTNEW(RATEntry)
  
  // lexical method
private:
  void NEAR MakeFontPair(int kanjip, int facename, int* vals);
  void NEAR MakeMyself();
public:
  FontMetric* GetFontMetric(int kanjip);
  void SetFontMetric(int kanjip, FontMetric* fm);

public:
  static void GC();
};

// in attribut.cpp
FontMetric* get_font_metric(attr attrib, int kanjip, int tategakip);

// Returns logical ascent.
inline int
FontMetric::GetAscent()
{
  return(this->ascent);
}

// Returns logical descent.
inline int
FontMetric::GetDescent()
{
  return(this->descent);
}

// Returns logical average width.
inline int
FontMetric::GetAverageWidth()
{
  return(this->average_width);
}

// Returns logical overhang.
inline int
FontMetric::GetOverhang()
{
  return(this->overhang);
}

// Returns Windows character set value.
inline BYTE
FontMetric::GetCharSet()
{
  return(this->char_set);
}

inline FontMetric* 
RATEntry::GetFontMetric(int kanjip)
{
  return(this->font_metric[kanjip]);
}

inline void
RATEntry::SetFontMetric(int kanjip, FontMetric* fm)
{
  this->font_metric[kanjip] = fm;
}

#endif /* RATS_H */
