// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: readlist.cpp,v 3.3 2000/05/13 16:29:05 kudou Exp $
// ReadList class
// Xgt@CǂݍށBfobNpɎg

#ifndef NDEBUG

#include "pword.h"
#include "readlist.h"

const size_t ReadList::one_time_buf_size = 256;

ReadList::ReadList(char* file_name)
  : MemStream(one_time_buf_size)
{
  num = 0;
  item_list = 0;
  ReadFile(file_name);
  SetupItemList();
}

ReadList::~ReadList()
{
}

char* 
ReadList::operator[] (uword n)
{
  if (item_list == 0) 
  {
    return 0;				// there are no items
  }
  if (n >= num) 
  {
    return 0;				// n is too big
  }
  return(*item_list)[n];
}

void 
ReadList::ReadFile(char* file_name)
{
  FILE* fp = fopen(file_name, "r");
  if (fp != 0) 
  {
    char* buf = new char[one_time_buf_size];
//#ifndef NDEBUG
//      DebugDisplay* dd = DebugDisplay::Open("com2");
//#endif
    while (feof(fp) == 0) 
    {
      // read one line
      uword n = 0;
      int c;
      while ((c = fgetc(fp)) != '\n' && c != EOF) 
      {
	buf[n++] = (char)c;
      }
      buf[n] = '\0';
      Printf(buf);		// read in real buffer
//#ifndef NDEBUG
//         dd->Printf("%s\n", buf);
//#endif
      num ++;
    }
//#ifndef NDEBUG
//      DebugDisplay::Close(dd);
//#endif
    delete buf;
  }
}

void 
ReadList::SetupItemList()
{
  if (num == 0) 
  {
    // may be no items
    return;
  }
  // get item_list memory
#ifdef __CYGWIN32__
  item_list = (char* (*)[0]) new char*[num];
#else /* __CYGWIN32__ */
  item_list = (char* (*)[]) new char*[num];
#endif /* __CYGWIN32__ */
  
  // set pointer
  char* p = (char*)GetStartAddress();
  size_t size = GetSize();
  char* end_p = p + size;
  for (uword index = 0; index < num; index ++) 
  {
    (*item_list)[index] = p;
    while (*p++ != '\0') 
    {
      if (p > end_p) 
      {
	// may be error
	return;
      }
    }
  }
}

#endif /* NDEBUG */
