// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: readlist.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// ReadList class
// Xgt@CǂݍށBfobNpɎg

#ifndef NDEBUG
#ifndef READLIST_H
#define READLIST_H

#include "mstream.h"

class ReadList
  : private MemStream
{
  // how many items
  uword num;
  
  // list of items
  char* (* item_list)[];
  
  // one time read buffer size
  static const size_t one_time_buf_size;
  
private:
  // read from file
  void ReadFile(char* file_name);
  
  // setup item list
  void SetupItemList();
  
public:
  // constructor
  ReadList(char* file_name);
  
  // destructor
  ~ReadList();
  
  // get items number
  uword GetNumber() 
  { return num; }
  
  // access item
  char* operator[] (uword n);
  
  // get item_list
  char* (* GetItemList())[] { return item_list; }
};

#endif /* READLIST_H */
#endif /* NDEBUG */

