// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: resizeme.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// ResizeMemory class
// resizeable memory management

#include "pword.h"
#include "resizeme.h"

#define USE_REALLOC
// if you don't want to use realloc(), comment out upper line!

#ifdef USE_REALLOC
#include <stdlib.h>		// for malloc, free, realloc
#else
#include <string.h>		// for memcpy
#endif

ResizeMemory::ResizeMemory(size_t size)
{
#ifdef USE_REALLOC
  memory = malloc(size);
#else 
  memory = new ubyte[size];
#endif
  ResizeMemory::size = size;
}

ResizeMemory::~ResizeMemory()
{
  if (memory == 0)
  {
    return;
  }
#ifdef USE_REALLOC
  free(memory);
#else
  delete memory;
#endif
}

void*
ResizeMemory::EnlargeMemory(ubyte magnification)
{
#ifdef USE_REALLOC
  memory = realloc(memory, size * magnification);
#else
  void* tmp = new ubyte[size * magnification];
  memcpy(tmp, memory, size * magnification);
  delete memory;
  memory = tmp;
#endif
  size = size * magnification;
  return memory;
}

void*
ResizeMemory::EnlargeMemory(size_t addendum_size)
{
#ifdef USE_REALLOC
  memory = realloc(memory, size + addendum_size);
#else
  void* tmp = new ubyte[size + addendum_size];
  memcpy(tmp, memory, size + addendum_size);
  delete memory;
  memory = tmp;
#endif
  size += addendum_size;
  return memory;
}

offset
ResizeMemory::GetOffset(void* p)
{
  return offset((ubyte*)p - (ubyte*)memory);
}

void*
ResizeMemory::GetPointer(offset o)
{
  return(ubyte*)memory + o;
}

void*
ResizeMemory::TakeMemory()
{
  void* ret = memory;
  memory = 0;
  size = 0;
  return ret;
}

void
ResizeMemory::FreeMemory(void* mem)
{
#ifdef USE_REALLOC
  free(mem);
#else
  delete mem;
#endif
}
