// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: saveasdl.cpp,v 3.6 1999/05/12 00:22:16 kudou Exp $
// Get a filename from a dialog box to save to

#include "pword.h"
#include "pmenus.h"
#include "dialogs.h"
#include "memo.h"
#include "docconte.h"
#include "document.h"
#include "pwordbas.h"
#include "fileutil.h"
#include "xstr.h"
#include "saveasdl.h"

#ifdef BW3_FILEDLG

// TEXTFILTERIDX value is a *.txt index in the S_WildCard2.o
#define TEXTFILTERIDX 2

SaveAsDialog::SaveAsDialog(char* init_file_name, char* filter_str, bool _save_as_text)
 : FileDialog(init_file_name, filter_str),
   save_as_text(_save_as_text)
{
}

bool
SaveAsDialog::Go()
{
  return FileDialog::Go(true);
}

extern "C" UINT CALLBACK
ComDlgCustSaveAsDlgProc(HWND hDlg, MSG_T uMsg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch(uMsg)
  {
  case WM_INITDIALOG:
    {
      SetWindowLong(hDlg, DWL_USER, lParam);
      LPOPENFILENAME lpOFN = (LPOPENFILENAME)lParam;
      SaveAsDialog* save_as = (SaveAsDialog*)lpOFN->lCustData;
      ::SendDlgItemMessage(hDlg, IDD_SAVEASTEXT, BM_SETCHECK, save_as->GetSaveAsText(), 0);
    }
    break;

  case WM_DESTROY:
    {
      LPOPENFILENAME lpOFN = (LPOPENFILENAME)GetWindowLong(hDlg, DWL_USER);
      SaveAsDialog* save_as = (SaveAsDialog*)lpOFN->lCustData;
      int save_as_text_p = ::SendDlgItemMessage(hDlg, IDD_SAVEASTEXT, BM_GETCHECK, 0, 0);
      save_as->SetSaveAsText(save_as_text_p != 0);
    }
    break;

  case WM_COMMAND:
    {
      switch (LOWORD(wParam))
      {
      case IDD_SaveAs_Memo:
        {	
	  MemoEditDialog memo_dialog(Selected_Document
				     ->GetDocumentContent()
				     ->GetMemo());
	  if (memo_dialog.Go())
	  {
	    Selected_Document->GetDocumentContent()->
	      SetMemo(memo_dialog.GetValue());
	  }
	}
	break;
      }
    }
    break;

  case WM_NOTIFY:
    {
      LPOFNOTIFY pofn = (LPOFNOTIFY)lParam;
      switch (pofn->hdr.code)
      {
      case CDN_TYPECHANGE:
        {
	  LPOPENFILENAME lpOFN = (LPOPENFILENAME)GetWindowLong(hDlg, DWL_USER);
	  ::SendDlgItemMessage(hDlg, IDD_SAVEASTEXT, BM_SETCHECK, 
			       (lpOFN->nFilterIndex == TEXTFILTERIDX),
			       0);
        }
	break;
      }
    }
    break;

  default:
    return FALSE;
  }
  return TRUE;
}

void
SaveAsDialog::OpenfilenameSetupHook(OPENFILENAME& ofn)
{
  ofn.lpTemplateName = "SAVEAS";
  ofn.Flags |= OFN_EXPLORER | OFN_ENABLETEMPLATE | OFN_ENABLEHOOK;
  ofn.lpfnHook = ComDlgCustSaveAsDlgProc;
  ofn.lCustData = (LPARAM_T)this;
  if (save_as_text)
  {
    ofn.nFilterIndex = TEXTFILTERIDX;
  }
}

#else /* BW3_FILEDLG */

// The Select() method is where SaveAs distinguishes itself from run-of-
// the mill abstract FileDialog boxes -- it checks to see if the file
// exists right before it is going to be confirmed, then checks with the
// user to make sure it's OK.

int
SaveAsDialog::Select()
{
  // see if file name is valid -- does this work??
  OFSTRUCT open_buf;
  int of_result = ::OpenFile(current_name, &open_buf, OF_PARSE);
  if (of_result == -1)
  {
    IssueVA(S_BadFilenameMsg, MB_ICONEXCLAMATION | MB_OK, current_name);
    return 0;
  }
  
  // user can't save under the name of an already open document
  FileUtil::GetDir(result_name);
  FileUtil::ConcatPathAndFileName(result_name, current_name);
  AnsiUpper(result_name);
  Document* d = PWordBase::GetDocumentByPathName(result_name);
  if ((d != NULL) && (d != this->doc))
  {
    IssueVA(S_AlreadyOpenMsg, MB_ICONEXCLAMATION | MB_OK, current_name);
    return 0;
  }
	  
  // if file exists, ask user if he wants to overwrite
  if (FileUtil::FileExists(current_name))
  {
    if (IssueVA(S_SaveAsConfirmFormat,
		 MB_ICONSTOP | MB_OKCANCEL, current_name)
	== IDCANCEL)
    {
      return(0);
    }
  }
  
  // if file name needs truncation, get user's OK
  else
  {
    char buf[MAX_PATH + 1];
    if (FileUtil::TruncateFilename(current_name, buf))
    {
      if (IssueVA(S_FilenameTruncMsg, MB_ICONSTOP | MB_OKCANCEL, buf)
	  == IDCANCEL) 
      {
	return 0;
      }
      else {
	strcpy(current_name, buf);
	return 1;
      }
    }
  }
  
  // otherwise go for it
  return 1;
}


// The SaveAsDialog WndProc does nothing at all different from the
// generic one defined on FileDialog, but to initialize the status of the
// "Save As Text" check box then later retrieve it and plug it in the 
// SaveAsDialog object, and handle the memo button.
LRESULT_T
SaveAsDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (Msg)
  {
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {	
     case IDD_SAVEASTEXT:
      save_as_text = (bool)(get_item_check(IDD_SAVEASTEXT) != 0);
      EnableWindow(GetItem(IDD_SaveAs_Memo), !save_as_text);
      break;
      
     case IDD_SaveAs_Memo:
      {	
	NoKanjiDialog::MaybeRestoreIME(); // method on superclass
	{
	  MemoEditDialog memo_dialog(Selected_Document
				      ->GetDocumentContent()
				      ->GetMemo());
	  if (memo_dialog.Go())
	  {
	    Selected_Document->GetDocumentContent()->
	    SetMemo(memo_dialog.GetValue());
	  }
	}
	NoKanjiDialog::MaybeUnrestoreIME(); // method on superclass
      }
      break;
      
     case IDOK:
		
      // beware the jabberwock, my friend
      save_as_text = (bool)(get_item_check(IDD_SAVEASTEXT) != 0);
      break;
    }
    break;
    
   case WM_INITDIALOG:
    SendItemMessage(IDD_SAVEASTEXT, BM_SETCHECK, save_as_text);
    EnableWindow(GetItem(IDD_SaveAs_Memo), !save_as_text);
    break;
  }
	
  // called in all cases
  
  return FileDialog::WndProc(Msg, wParam, lParam);
}

SaveAsDialog::SaveAsDialog(Document* _doc,
			   char* _initial_name, int save_as_text)
  : FileDialog(_initial_name),
    doc(_doc)
{
  this->class_name = "SaveAs";
  SaveAsDialog::save_as_text = (bool)(save_as_text != 0);
}
#endif /* BW3_FILEDLG */
