// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: saveasdl.h,v 3.4 1999/05/12 00:22:16 kudou Exp $
// Define a "class" for handling the save as dialog box.

#ifndef SAVEASDL_H
#define SAVEASDL_H

#include "dlg.h"
#include "filedlg.h"
#include "dialogs.h"

#ifdef BW3_FILEDLG

class SaveAsDialog
  : public FileDialog
{
  bool save_as_text;
  
  virtual void OpenfilenameSetupHook(OPENFILENAME& ofn);
public:
  SaveAsDialog(char* init_file_name, char* filter_str, bool save_as_text = false);
  bool GetSaveAsText() { return save_as_text; }
  bool Go();
  void SetSaveAsText(bool p) { save_as_text = p; }
};

#else /* BW3_FILEDLG */
class SaveAsDialog
  : public FileDialog,
    NoKanjiDialog
{
  bool save_as_text;
  Document* doc;
  
  // internal routines
  int Select();

public:
  SaveAsDialog(Document* , char* , int save_as_text=0);
  LRESULT_T WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam);	

  bool GetSaveAsText()
  {
    return save_as_text;
  }
};
#endif /* BW3_FILEDLG */

#endif /* SAVEASDL_H */
