// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: screen.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// class Screen

#ifndef SCREEN_H
#define SCREEN_H

#define WHITE RGB(0xff,0xff,0xff)
#define BLACK RGB(0, 0, 0)
#define RED RGB(0xff, 0, 0)
#define BLUE RGB(0, 0, 0xff)

#define PRIMARY_BACKGROUND RGB(0xff,0xff,0)
#define SECONDARY_BACKGROUND RGB(0,0xff,0xff)

#define BITMAP_POOL_SIZE 36

class Screen
{
public:
  static DWORD button_face_color;
  static DWORD button_shadow_color;
  static DWORD button_text_color;
  static DWORD pushed_button_color;
  static DWORD pushed_text_color;
  
  static int width;
  static int height;
  static int caption_height;
  static int caption_bitmap_height;
  static int frame_width;
  static int frame_height;
  static int vscroll_bitmap_width;
  static int hscroll_bitmap_height;
  static int kanji_window_height;
  static int closebox_bitmap_width;
  static int closebox_bitmap_height;
  static int system_font_height;
  
  static HDC dc;
  
  static HBRUSH primary_background_brush;
  static HBRUSH secondary_background_brush;
  
  static HBRUSH white_brush;
  static HBRUSH black_brush;
  static HBRUSH one_dot_brush;
  static HBRUSH selected_frame_brush;

  // Valid index values are INDEX_HORIAONTAL and INDEX_VERTICAL
  static HBRUSH simple_dotted_brush[2];
  static HBRUSH simple_broken_brush[2];
  
  static HBRUSH invisible_line_brush_h;
  static HBRUSH invisible_line_brush_v;
  
  static HBRUSH stocked_black_brush;
  static HBRUSH stocked_dark_gray_brush;
  static HBRUSH stocked_gray_brush;
  static HBRUSH stocked_light_gray_brush;
  static HBRUSH stocked_white_brush;

  static HFONT system_font;
  static HFONT vertical_system_font;
  
public:
  static void Init();
  static void KillAllResources();
  static void get_system_colors();
};

#endif /* SCREEN_H */
