// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: searchdl.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// define SearchDialog class
// In BeatWord, an object of type SearchDialog is created when the
// application starts and only destroyed when the application ends.
// It is owned by PWordPresentation.
// The actual Windows dialog box also exists permanently.  This prevents
// us from, e.g., having to remember the location of the box in between
// appearances to restore it to the same place.
// It also allows us to use the list box inside the dialog box to maintain
// the list of recent search strings.

#ifndef SEARCHDL_H
#define SEARCHDL_H

#include "dlg.h"

class SearchDialog
  : public PModelessDialog
{
  enum
  {
    SEARCHSTRINGMAX = 255,
    RECENTMAX =10,
  };
  char string[SEARCHSTRINGMAX];
  bool reverse;			// "reverse" check box
  bool all;			// "all" (global) check box
  
public:
  // constructor and destructor
  SearchDialog();

private:
  void NEAR update();
public:
  void set_string(char* s);
  // run the dialog box
  void Go();
  long Find();
  
  // get current values
  char* String();
  bool Reverse();
  bool All();
  
  // routines which all dialog boxes must provide
  LRESULT_T WndProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
};

inline bool
SearchDialog::All()
{
  return(this->all);
}

inline bool
SearchDialog::Reverse()
{
  return(this->reverse);
}

inline char* 
SearchDialog::String()
{
  return(this->string);
}

#endif /* SEARCHDL_H */
