// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: selframe.cpp,v 3.5 2000/05/13 16:29:06 kudou Exp $
// class EditFrame
// t[GfB^̃t[IҏW[h

#include "pword.h"
#include "cplist.h"
#include "fflist.h"
#include "flist.h"
#include "folist.h"
#include "editfram.h"
#include "blueprin.h"
#include "borderli.h"
#include "docconte.h"
#include "docedit.h"
#include "docsel.h"
#include "document.h"
#include "docwindo.h"
#include "fillobjc.h"
#include "fission.h"
#include "foiterat.h"
#include "frameown.h"
#include "grphobjc.h"
#include "intlist.h"
#include "layoutin.h"
#include "layoutte.h"
#include "mcursor.h"
#include "metafile.h"
#include "mfobject.h"
#include "objectid.h"
#include "panel.h"
#include "pmenus.h"
#include "table.h"
#include "vdisplay.h"

// ------------------------------------------------------------
// this class gets region cross-points from the two cross-points.
// and dragging position

class CrossPointRegion
{
  CrossPoint* from;
  CrossPoint* to;
  Vector to_vec;
  bool done;
  CellCPIterator* cpi;
  
  // region of selection 
  Rect rgn;
  
public:
  // constructor
  CrossPointRegion(CrossPoint* from, CrossPoint* to, Vector& to_vec);
  
  // destructor
  ~CrossPointRegion();
  
  // iterator
  CrossPoint* operator() ();
};

CrossPointRegion::CrossPointRegion(CrossPoint* from, 
				    CrossPoint* to, 
				    Vector& to_vec)
{
  CrossPointRegion::from = from;
  CrossPointRegion::to = to;
  CrossPointRegion::to_vec = to_vec;
  cpi = 0;
  done = False;
}

CrossPointRegion::~CrossPointRegion()
{
  delete cpi;
}

CrossPoint* 
CrossPointRegion::operator() ()
{
  if (done) 
  {
    return 0;
  }
  if (cpi != 0) 
  {
    CrossPoint* cp;
    while ((cp = (*cpi) ()) != 0) 
    {
      Rect rec = cp->GetOwnRect();
      if (rec.x1 < rgn.x2 && 
	  rec.x2 > rgn.x1 &&
	  rec.y1 < rgn.y2 &&
	  rec.y2 > rgn.y1)
      {
	return cp;
      }
    }
    done = True;
    return 0;
  }
  if (from == to) 
  {
    done = True;
    return from;
  }
  Rect from_rec = from->GetOwnRect();
  rgn.x1 = (from_rec.x1 < to_vec.x) ? from_rec.x1 : to_vec.x;
  rgn.x2 = (from_rec.x2 > to_vec.x) ? from_rec.x2 : to_vec.x;
  rgn.y1 = (from_rec.y1 < to_vec.y) ? from_rec.y1 : to_vec.y;
  rgn.y2 = (from_rec.y2 > to_vec.y) ? from_rec.y2 : to_vec.y;
  cpi = new CellCPIterator(from->GetFissionFrame());
  return(*this) ();
}


// ------------------------------------------------------------
// select mouse action

void NEAR 
EditFrame::SelectFrame_LDWN(WPARAM_T wParam, LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  //
  // Ctrl  +            add frame region
  // Shift +            set region base
  // Ctrl + Shift +     add frame region & set region base.
  //
  CrossPoint* cp = 0;
  if (selfrm.IsShiftSelect()) 
  {
    if ((FindLayoutW(mpos) != GetEditLI()) ||
	((cp = FindCrossPointW(mpos)) == 0)) 
    {
      CancelSelectFrame(); // cancel this
      return;
    }
    Vector v = WtoIv(mpos);
    MoveFrameSelection(cp, v);
    // add frame region
    EndFrameSelection();
    return;
  }
  
  if (!(wParam & MK_CONTROL) && 
      (ExistFrameSelection())) 
  {
    CancelSelectFrame(True, False);
  }
  
  if ((LockLayout(mpos) == 0) || 
      ((cp = FindCrossPointW(mpos)) == 0)) 
  {
    CancelSelectFrame();
    return;
  }
  Vector v = WtoIv(mpos);
  StartFrameSelection(cp, v);
  MouseCursor::SelectFrame();
  if (wParam & MK_SHIFT) 
  {
    // set region base
    selfrm.SetShiftSelect();
  }
}

void NEAR 
EditFrame::SelectFrame_MV(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  if (selfrm.IsFixed() == False) 
  {
    //
    // idle
    //
    if ((LockLayout(mpos) == 0) || 
	(FindCrossPointW(mpos) == 0)) 
    {
      MouseCursor::SelectFrameOff();
    }
    else 
    {
      MouseCursor::SelectFrame();
    }
  }
  else 
  {
    //
    // dragging now
    //
    if (FindLayoutW(mpos) != GetEditLI()) 
    {
      MouseCursor::SelectFrameOff();
    }
    else if (selfrm.IsShiftSelect()) 
    {
      MouseCursor::SelectFrame();
    }
    else 
    {
      MouseCursor::SelectFrame();
      CrossPoint* cp = FindCrossPointW(mpos);
      Vector v = WtoIv(mpos);
      MoveFrameSelection(cp, v);
    }
  }
}

void NEAR 
EditFrame::SelectFrame_LUP(WPARAM_T /*wParam*/, LPARAM_T lParam)
{
  if (!selfrm.IsFixed()) 
  {
    CancelSelectFrame(False);
    return;
  }

  // fixed
  VectW mpos(LPARAM_TO_X(lParam), LPARAM_TO_Y(lParam));
  if (FindLayoutW(mpos) != GetEditLI()) 
  {
    CancelSelectFrame();
    return;
  }
  CrossPoint* cp = FindCrossPointW(mpos);
  Vector v = WtoIv(mpos);
  MoveFrameSelection(cp, v);
  if (!selfrm.IsShiftSelect()) 
  {
    MouseCursor::SelectFrame();
    EndFrameSelection();
  }
}

void
EditFrame::WndProcSelectFrame(DocumentWindow* window, 
			       MSG_T Msg, 
			       WPARAM_T wParam, 
			       LPARAM_T lParam)
{
  EditFrame::window = window;
  switch (Msg) 
  {
   case WM_LBUTTONDOWN:
    SelectFrame_LDWN(wParam, lParam);
    break;
    
   case WM_MOUSEMOVE:
    SelectFrame_MV(wParam, lParam);
    break;
    
   case WM_LBUTTONUP:
    SelectFrame_LUP(wParam, lParam);
    break;
    
   case WM_RBUTTONDOWN:
    if (selfrm.IsFixed())
    {
      CancelFrameSelectionDrag();
    }
    else
    {
      CancelSelectFrame(False);
    }
    break;
  }
}

void 
EditFrame::ClearRedisplayRequestFlag(FissionFrame* ff)
{
  FOIterator foi(ff);
  FrameObject* fo;
  while ((fo = foi()) != 0)
  {
    fo->SetRedisplayRequestedStatus(False);
  }
}

void 
EditFrame::ClearRedisplayRequestFlag()
{
  FFList fflist;
  if (selfrm.IsFixed())
  {
    fflist.Push(selfrm.GetCrossPoint()->GetFissionFrame());
  }
  CPListIterator cpi(frames);
  FissionFrame* ff;
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    ff = cp->GetFissionFrame();
    if (fflist.Search(ff) == 0)
    {
      fflist.Push(ff);
    }
  }
  while ((ff = fflist.Pop()) != 0)
  {
    ClearRedisplayRequestFlag(ff);
  }
}

void 
EditFrame::InvalidateFrameSelection(FissionFrame* ff)
{
#ifdef FSEL_INVALIDATE_ALL
  // for test
  doc->GetDocumentContent()->Invalidate();
#else
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  if (Selected_Window != 0)
  {
    Selected_Window->InvalidateRequestedFrame(lt);
  }
#endif
}

void 
EditFrame::InvalidateFrameSelection()
{
#ifdef FSEL_INVALIDATE_ALL
  // for test
  doc->GetDocumentContent()->Invalidate();
#else
  FFList fflist;
  if (selfrm.IsFixed())
  {
    fflist.Push(selfrm.GetCrossPoint()->GetFissionFrame());
  }
  CPListIterator cpi(frames);
  FissionFrame* ff;
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    ff = cp->GetFissionFrame();
    if (fflist.Search(ff) == 0)
    {
      fflist.Push(ff);
    }
  }
  while ((ff = fflist.Pop()) != 0)
  {
    InvalidateFrameSelection(ff);
  }
#endif
}

void 
EditFrame::CancelSelectFrame(bool /*beep*/, 
			      bool mouse_ctrl)
{
  if (mouse_ctrl)
  {
    MouseCursor::SelectFrameOff();
  }
  ClearFrameSelection();
}

void 
EditFrame::ClearFrameSelection()
{
  ClearRedisplayRequestFlag();
  ClearFrameSelectionBit();
  InvalidateFrameSelection();
  ClearMultiFrameSelection();
  selfrm.Reset();
}

void 
EditFrame::CancelFrameSelectionDrag()
{
  FissionFrame* ff = selfrm.GetCrossPoint()->GetFissionFrame();
  ClearRedisplayRequestFlag(ff);
  ClearFrameSelectionBit();
  selfrm.SelectFrame();
  SetFrameSelectionBit();
  InvalidateFrameSelection(ff);
}

void 
EditFrame::StartFrameSelection(CrossPoint* cp, Vector& v)
{
  FissionFrame* ff = cp->GetFissionFrame();
  bool selected = FrameSelectedP(cp);
  ClearRedisplayRequestFlag(ff);
  ClearFrameSelectionBit();
  selfrm.StartSelection(cp, GetEditLT(), v);
  selfrm.SetSelectOp(!selected);
  SetFrameSelectionBit();
  InvalidateFrameSelection(ff);
}

void
EditFrame::EndFrameSelection()
{
  AddMultiFrameSelection(selfrm.GetCrossPoint(), 
			  selfrm.GetToCrossPoint(),
			  selfrm.GetToVector());
  selfrm.SelectFrame();
}

void 
EditFrame::MoveFrameSelection(CrossPoint* cp, Vector& v)
{
  if (v != selfrm.GetToVector())
  {
    FissionFrame* ff = cp->GetFissionFrame();
    ClearRedisplayRequestFlag(ff);
    ClearFrameSelectionBit();
    selfrm.Move(cp, v);
    SetFrameSelectionBit();
    InvalidateFrameSelection(ff);
  }
}

void 
EditFrame::SetFrameSelectionBit(CrossPoint* cp)
{
  assert(cp != 0);
  FrameObject* fo = cp->GetFrameObject();
  if (fo != 0)
  {
    fo->SetFrameSelected(True);
    fo->InvertRedisplayRequestedStatus();
  }
}

void 
EditFrame::ClearFrameSelectionBit(CrossPoint* cp)
{
  assert(cp != 0);
  FrameObject* fo = cp->GetFrameObject();
  if (fo != 0)
  {
    fo->SetFrameSelected(False);
    fo->InvertRedisplayRequestedStatus();
  }
}

bool 
EditFrame::FrameSelectedP(CrossPoint* cp)
{
  if (cp != 0)
  {
    FrameObject* fo = cp->GetFrameObject();
    if (fo != 0)
    {
      return fo->FrameSelectedP();
    }
  }
  return False;
}

void 
EditFrame::SetFrameSelectionBit()
{
  CrossPoint* cp;
  CPListIterator cpi(frames);
  while ((cp = cpi()) != 0) 
  {
    SetFrameSelectionBit(cp);
  }
  if (selfrm.IsFixed()) 
  {
    CrossPointRegion cpr(selfrm.GetCrossPoint(), 
			  selfrm.GetToCrossPoint(),
			  selfrm.GetToVector());

    while ((cp = cpr()) != 0) 
    {
      if (selfrm.GetSelectOp())
      {
	SetFrameSelectionBit(cp);
      }
      else
      {
	ClearFrameSelectionBit(cp);
      }
    }
  }
}

// clear frame selection bit
void 
EditFrame::ClearFrameSelectionBit()
{
  CrossPoint* cp;
  CPListIterator cpi(frames);
  while ((cp = cpi()) != 0) 
  {
    ClearFrameSelectionBit(cp);
  }
  if (selfrm.IsFixed()) 
  {
    CrossPointRegion cpr(selfrm.GetCrossPoint(), 
			  selfrm.GetToCrossPoint(),
			  selfrm.GetToVector());
    while ((cp = cpr()) != 0) 
    {
      ClearFrameSelectionBit(cp);
    }
  }
}

// select caret position frames
void 
EditFrame::SelectCaretFrames()
{
  if (Selected_Window == 0)
  {
    return;
  }
  
  // install selection
  FOList fol; // frame selection list
  IntervalList* intlist = (Selected_Window->GetEditor()
			   ->GetSelectionStack()
			   ->GetSelection());
  for (Interval* interval = intlist->GetHead();
       interval != 0;
       interval = interval->GetNext())
  {
    BP* bp0;
    BP* bp1;
    interval->GetLeftRight(bp0, bp1);
    FrameInstance* fi0 = bp0->MaybeFindFrame();
    FrameInstance* fi1 = bp1->MaybeFindFrame();
    FrameInstance* fi = fi0;
    while (fi != 0)
    {
      FrameObject* fo = fi->GetFrameTemplate();
      FOListIterator foli(fol);
      FrameObject* scan_fo;
      while ((scan_fo = foli()) != 0)
      {
	if (fo == scan_fo)
	{
	  break;
	}
      }
      if (scan_fo == 0)
      {
	fol.Inject(fo);
      }
      if (fi == fi1)
      {
	break;
      }
      fi = fi->GetNextTextFrame();
    }
  }
  InstallFrameSelection(fol);
}

// install frame selection
void 
EditFrame::InstallFrameSelection(FOList& fol)
{
  ClearFrameSelection();
  FOListIterator foli(fol);
  FrameObject* fo;
  while ((fo = foli()) != 0)
  {
    frames->Inject(fo->GetCrossPoint());
  }
  CheckRectFrameSelection();
  ClearRedisplayRequestFlag();
  SetFrameSelectionBit();
  InvalidateFrameSelection();
}


// ------------------------------------------------------------
// frame selection management

// check frame selection
bool 
EditFrame::ExistFrameSelection()
{
  return((toolbox == SelectFrame_MODE) && 
	  (frames->Number() != 0));
}

// check selection is rectanglar region
bool
EditFrame::IsRectRgnSelection()
{
  return(ExistFrameSelection() &&
	  (rect_rgn_cp1 != 0) &&
	  (rect_rgn_cp2 != 0));
}

// check single frame selection
bool
EditFrame::IsSingleFrameSelection()
{
  return(ExistFrameSelection() &&
	  IsRectRgnSelection() &&
	  (rect_rgn_cp1 == rect_rgn_cp2));
}

// clear multi frame selection infomation
void 
EditFrame::ClearMultiFrameSelection()
{
  frames->Clear();
  rect_rgn_cp1 = 0;
  rect_rgn_cp2 = 0;
  min_x_cp = 0;
  max_x_cp = 0;
  min_y_cp = 0;
  max_y_cp = 0;
}

// add another frame region 
void 
EditFrame::AddMultiFrameSelection(CrossPoint* from, 
				   CrossPoint* to,
				   Vector& to_vec)
{
  // get add cross-points
  CPList add;
  CPList overlap;
  CrossPointRegion cpr(from, to, to_vec);
  CrossPoint* cp;
  while ((cp = cpr()) != 0) 
  {
    CPListIterator cpi(frames);
    bool add_flag = True;
    CrossPoint* sel;
    while ((sel = cpi()) != 0) 
    {
      if (sel == cp) 
      {
	add_flag = False;
	break;
      }
    }
    if (add_flag) 
    {
      add.Push(cp);
    }
    else
    {
      overlap.Push(cp);
    }
  }
  if (selfrm.GetSelectOp())
  {
    // select frame 
    CPListIterator cpi(add);
    while ((cp = cpi()) != 0) 
    {
      frames->Inject(cp);
    }
  }
  else
  {
    // cancel frame
    CPListIterator cpi(overlap);
    while ((cp = cpi()) != 0) 
    {
      frames->Delete(cp);
    }
  }
  CheckRectFrameSelection();
}

void 
EditFrame::CheckRectFrameSelection()
{
  // now selected region create new regions.
  // check whether these new regions form rectangulous region or not
  min_x_cp = 0;
  max_x_cp = 0;
  min_y_cp = 0;
  max_y_cp = 0;
  bool single_rectangulous_selection = False;
  CPListIterator cpi(frames);
  CrossPoint* cp = cpi();
  if (cp != 0)
  {
    FissionFrame* ff = cp->GetFissionFrame();
    while ((cp = cpi()) != 0) 
    {
      if (ff != cp->GetFissionFrame())
      {
	// multi layout selections
	break;
      }
    }
    if (cp == 0)
    {
      // find minimun and maximum position frame
      cpi.Revert();
      cp = cpi();
      Rect rec = cp->GetRect();
      Rect rgn = rec;
      CrossPoint* min_cp = cp;
      CrossPoint* max_cp = cp;
      min_x_cp = cp;
      max_x_cp = cp;
      min_y_cp = cp;
      max_y_cp = cp;
      while ((cp = cpi()) != 0)
      {
	rec = cp->GetRect();
	if ((rec.x1 <= rgn.x1) &&
	    (rec.y1 <= rgn.y1))
	{
	  min_cp = cp;
	}
	if ((rec.x2 >= rgn.x2) &&
	    (rec.y2 >= rgn.y2))
	{
	  max_cp = cp;
	}
	if (rec.x1 < rgn.x1)
	{
	  min_x_cp = cp;
	  rgn.x1 = rec.x1;
	}
	if (rec.y1 < rgn.y1)
	{
	  min_y_cp = cp;
	  rgn.y1 = rec.y1;
	}
	if (rec.x2 > rgn.x2)
	{
	  max_x_cp = cp;
	  rgn.x2 = rec.x2;
	}
	if (rec.y2 > rgn.y2)
	{
	  max_y_cp = cp;
	  rgn.y2 = rec.y2;
	}
      }
      // now we know the minimum and maximun frame
      // check whether all selected frames collection is the same collection
      // which is made by minimum and maximum boundary
      ff->SetSpecialCheckP(False);
      cpi.Revert();
      while ((cp = cpi()) != 0)
      {
	cp->SetSpecialCheckP(True);
      }
      
      CPIterator cpi(ff);
      while ((cp = cpi()) != 0)
      {
	rec = cp->GetRect();
	Vector v1 = Vector(rec.x1, rec.y1);
	Vector v2 = Vector(rec.x1, rec.y2 - 1);
	Vector v3 = Vector(rec.x2 - 1, rec.y1);
	Vector v4 = Vector(rec.x2 - 1, rec.y2 - 1);
	if (rgn.IsInternalPos(v1) ||
	    rgn.IsInternalPos(v2) ||
	    rgn.IsInternalPos(v3) ||
	    rgn.IsInternalPos(v4))
	{
	  if (!cp->SpecialCheckP())
	  {
	    // these selections never make single rectangulous region
	    break;
	  }
	}
      }
      if (cp == 0)
      {
	single_rectangulous_selection = True;
	// these selections make single rectangulous region
	rect_rgn_cp1 = min_cp;
	rect_rgn_cp2 = max_cp;
      }
    }
  }
  if (!single_rectangulous_selection)
  {
    rect_rgn_cp1 = 0;
    rect_rgn_cp2 = 0;
  }
}

bool 
EditFrame::IsRemoveableFrameSelectionObject()
{
  CPListIterator cpi(frames);
  CrossPoint* cp;
  while ((cp = cpi()) != 0) 
  {
    FrameObject* fo = cp->GetFrameObject();
    if (!fo->CheckVanish()) 
    {
      // can't remove this frame object
      return False;
    }
  }
  return True;
}

// get selected fission-frame
FissionFrame* 
EditFrame::GetSelectedFrameFF()
{
  assert(frames->Number() != 0);
  return frames->GetTopData()->GetFissionFrame();
}

// check clipboad copy-able frame object
bool 
EditFrame::ExistCopyAbleFrameSelection()
{
  if (!IsSingleFrameSelection())
  {
    return False;
  }
  if ((selfrm.GetCrossPoint() != 0) &&
      (selfrm.GetCrossPoint()->GetFrameObject() != 0)) 
  {
    switch (selfrm.GetCrossPoint()->GetFrameObject()->GetObjectID()) 
    {
     case IDTextObject:
     case IDFillObject:
     case IDLSlantLineObject:
     case IDRSlantLineObject:
     case IDAllLayoutObject:
     case IDUnknownObject:
      break;
     case IDGraphicObject:
     case IDMetafileObject:
      return True;
    }
  }
  return False;
}

// copy frame object to clipboard
void 
EditFrame::CopyFrameSelectionToClipboard()
{
  if (ExistCopyAbleFrameSelection() == False) 
  {
    return;
  }
  FrameObject* fo = selfrm.GetCrossPoint()->GetFrameObject();
  switch (fo->GetObjectID()) 
  {
   case IDTextObject:
    // someday
   case IDFillObject:
   case IDLSlantLineObject:
   case IDRSlantLineObject:
   case IDAllLayoutObject:
   case IDUnknownObject:
    break;
   case IDGraphicObject:
    ((GraphicObject*)fo)->CopyToClipboard();
    break;
   case IDMetafileObject:
    ((MetafileObject*)fo)->CopyToClipboard();
    break;
   default:
    break;
  }
}

#ifndef NDEBUG
// browse frame
void 
EditFrame::BrowseFrame(FrameObject* fo)
{
  switch (fo->GetObjectID()) 
  {
   case IDLSlantLineObject:
   case IDRSlantLineObject:
   case IDAllLayoutObject:
    break;
   case IDUnknownObject:
    {
      PWordPresentation::StatusOut("Unknown Frame");
    }
    break;
   case IDTextObject:
    {
      PWordPresentation::StatusOut("Text Frame");
    }
    break;
   case IDFillObject:
    {
      PWordPresentation::StatusOut("Fill");
    }
    break;
   case IDGraphicObject:
    {
      PWordPresentation::StatusOut("BitMap");
    }
    break;
   case IDMetafileObject:
    {
      MetafileObject* mo = (MetafileObject*)fo;
      METAFILEPICT* mp = mo->GetMetafile()->GetMetafilePict();
      char* mes;
      switch (mp->mm) 
      {
       case MM_TEXT:
	mes = "Metafile: MM_TEXT";
	break;
       case MM_LOMETRIC:
	mes = "Metafile: MM_LOMETRIC";
	break;
       case MM_HIMETRIC:
	mes = "Metafile: MM_HIMETRIC";
	break;
       case MM_LOENGLISH:
	mes = "Metafile: MM_LOENGLISH";
	break;
       case MM_HIENGLISH:
	mes = "Metafile: MM_HIENGLISH";
	break;
       case MM_TWIPS:
	mes = "Metafile: MM_TWIPS";
	break;
       case MM_ISOTROPIC:
	mes = "Metafile: MM_ISOTROPIC";
	break;
       case MM_ANISOTROPIC:
	mes = "Metafile: MM_ANISOTROPIC";
	break;
       default:
	mes = "Metafile: Unknown Mapping Mode";
	break;
      }
      PWordPresentation::StatusOut(mes);
    }
    break;
   default:
    break;
  }
}
#endif /* NDEBUG */

// ------------------------------------------------------------
// selection border line

// get frame selection border line
void 
EditFrame::GetFrameSelectionBorderLine(uword& top, uword& bottom, 
					uword& left, uword& right)
{
  if (!ExistFrameSelection())
  {
    top = bottom = left = right = 0;
  }
  else if ((rect_rgn_cp1 != 0) &&
	   (rect_rgn_cp2 != 0))
  {
    // get rectanglar region's outlines 
    top    = rect_rgn_cp1->GetHBorder();
    left   = rect_rgn_cp1->GetVBorder();
    bottom = ((rect_rgn_cp2->GetVNext() != 0) ? 
	      rect_rgn_cp2->GetVNext()->GetHBorder() : 0);
    right  = ((rect_rgn_cp2->GetHNext() != 0) ? 
	      rect_rgn_cp2->GetHNext()->GetVBorder() : 0);
  }  
  else 
  {
    // get first selected frame border line
    CrossPoint* cp = frames->GetTopData();
    top    = cp->GetHBorder();
    left   = cp->GetVBorder();
    bottom = (cp->GetVNext() != 0) ? cp->GetVNext()->GetHBorder() : 0;
    right  = (cp->GetHNext() != 0) ? cp->GetHNext()->GetVBorder() : 0;
  }
}

// set frame selection border line
void 
EditFrame::SetFrameSelectionBorderLine(uword top, uword bottom,
					uword left, uword right,
					uword inter, TargetLine target)
{
  
#define APPLY_FRAME_LINE(VFUNC, HFUNC)\
  {\
   CPListIterator cpi(frames);\
   CrossPoint* cp;\
   while ((cp = cpi()) != 0) {\
      cp->VFUNC();\
      CrossPoint* vcp;\
      for (vcp = cp->GetVNext();\
	   vcp->GetKind() & CrossPoint::HEnd;\
	   vcp = vcp->GetVNext()) {\
	 vcp->VFUNC();\
      }\
      vcp->HFUNC();\
      CrossPoint* hcp;\
      for (hcp = vcp->GetHNext();\
	   hcp->GetKind() & CrossPoint::VStart;\
	   hcp = hcp->GetHNext()) {\
	 hcp->HFUNC();\
      }\
      cp->HFUNC();\
      for (hcp = cp->GetHNext();\
	   hcp->GetKind() & CrossPoint::VEnd;\
	   hcp = hcp->GetHNext()) {\
	 hcp->HFUNC();\
      }\
      hcp->VFUNC();\
      for (vcp = hcp->GetVNext();\
	   vcp->GetKind() & CrossPoint::HStart;\
	   vcp = vcp->GetVNext()) {\
	 vcp->VFUNC();\
      }\
   }\
}

  assert(frames->Number() != 0);
  //
  // set target line bit
  //
  APPLY_FRAME_LINE(SetVAdaptingSelection, SetHAdaptingSelection)
  
  //
  // apply 
  //
  {
    CPListIterator cpi(frames);
    CrossPoint* cp;
    while ((cp = cpi()) != 0) 
    {
      // left
      if (cp->IsSingleVAdaptingSelection() &&
	  (target & VBoundary)) 
      {
	cp->SetVBorder(left);
      }
      else if (cp->IsDoubleVAdaptingSelection() &&
	       (target & VInter)) 
      {
	cp->SetVBorder(inter);
      }
      CrossPoint* vcp;
      for (vcp = cp->GetVNext();
	   vcp->GetKind() & CrossPoint::HEnd;
	   vcp = vcp->GetVNext()) 
      {
	if (vcp->IsSingleVAdaptingSelection() &&
	    (target & VBoundary)) 
	{
	  vcp->SetVBorder(left);
	}
	else if (vcp->IsDoubleVAdaptingSelection() &&
		 (target & VInter)) 
	{
	  vcp->SetVBorder(inter);
	}
      }
      // bottom
      if (vcp->IsSingleHAdaptingSelection() &&
	  (target & HBoundary)) 
      {
	vcp->SetHBorder(bottom);
      }
      else if (vcp->IsDoubleHAdaptingSelection() &&
	       (target & HInter)) 
      {
	vcp->SetHBorder(inter);
      }
      CrossPoint* hcp;
      for (hcp = vcp->GetHNext();
	   hcp->GetKind() & CrossPoint::VStart;
	   hcp = hcp->GetHNext()) 
      {
	if (hcp->IsSingleHAdaptingSelection() &&
	    (target & HBoundary)) 
	{
	  hcp->SetHBorder(bottom);
	}
	else if (hcp->IsDoubleHAdaptingSelection() &&
		 (target & HInter)) 
	{
	  hcp->SetHBorder(inter);
	}
      }
      // top
      if (cp->IsSingleHAdaptingSelection() && 
	  (target & HBoundary)) 
      {
	cp->SetHBorder(top);
      }
      else if (cp->IsDoubleHAdaptingSelection() &&
	       (target & HInter)) 
      {
	cp->SetHBorder(inter);
      }
      for (hcp = cp->GetHNext();
	   hcp->GetKind() & CrossPoint::VEnd;
	   hcp = hcp->GetHNext()) 
      {
	if (hcp->IsSingleHAdaptingSelection() &&
	    (target & HBoundary)) 
	{
	  hcp->SetHBorder(top);
	}
	else if (hcp->IsDoubleHAdaptingSelection() &&
		 (target & HInter)) 
	{
	  hcp->SetHBorder(inter);
	}
      }
      // right
      if (hcp->IsSingleVAdaptingSelection() &&
	  (target & VBoundary)) 
      {
	hcp->SetVBorder(right);
      }
      else if (hcp->IsDoubleVAdaptingSelection() &&
	       (target & VInter)) 
      {
	hcp->SetVBorder(inter);
      }
      for (vcp = hcp->GetVNext();
	   vcp->GetKind() & CrossPoint::HStart;
	   vcp = vcp->GetVNext()) 
      {
	if (vcp->IsSingleVAdaptingSelection() &&
	    (target & VBoundary)) 
	{
	  vcp->SetVBorder(right);
	}
	else if (vcp->IsDoubleVAdaptingSelection() &&
		 (target & VInter)) 
	{
	  vcp->SetVBorder(inter);
	}
      }
    }
  }
  
  //
  // clear target line bit
  //
  APPLY_FRAME_LINE(ClearAdaptingSelection, ClearAdaptingSelection)
}

// ------------------------------------------------------------
// split selected frame

// this function assumes it's a single cell selection
void 
EditFrame::SplitSelectedFrame(uword column, uword row)
{
  FissionFrame* ff = GetSelectedFrameFF();
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  ClearRedisplayRequestFlag();
  ClearFrameSelectionBit();
  InvalidateFrameSelection();
  
  CrossPoint* cp = rect_rgn_cp1;
  if ((cp == 0) ||
      (cp->GetVNext() == 0) ||
      (cp->GetHNext() == 0)) 
  {
    // error
    return;
  }

  uword border_index;
  if (lt->IsTable()) 
  {
    border_index = BorderLine::GetDefaultTableIndex();
  }
  else 
  {
    border_index = BorderLine::GetDefaultFrameIndex();
  }
  HFission* top    = cp->GetCellTopFission();
  HFission* bottom = cp->GetCellBottomFission();
  VFission* left   = cp->GetCellLeftFission();
  VFission* right  = cp->GetCellRightFission();
  
  if (column > 1) 
  {
    Lunit size_x = (Lunit)right->X() - (Lunit)left->X();
    Iunit x = left->X();
    for (uword n = 1; n < column; n++) 
    {
      Iunit pos = (Iunit) ((size_x * n) / (Lunit)column + x);
      ff->Divide(top, bottom, pos, border_index);
    }
  }
  if (row > 1) 
  {
    Lunit size_y = (Lunit)bottom->Y() - (Lunit)top->Y();
    Iunit y = top->Y();
    for (uword n = 1; n < row; n++) 
    {
      Iunit pos = (Iunit) ((size_y * n) / (Lunit)row + y);
      ff->Divide(left, right, pos, border_index);
    }
  }
  ClearFrameSelection();
  SetDirty();
  UnforceTouchCaret();
}

// ------------------------------------------------------------
// frame region

bool
EditFrame::GetSingleFrameRegionRim(FrameRectRgn& rgn)
{
  if (!IsRectRgnSelection())
  {
    return False;
  }
  rgn.Set(rect_rgn_cp1, rect_rgn_cp2);
  return rgn.ValidP();
}

bool 
EditFrame::GetSingleFrameRegionRim(HFission*& top,
				    HFission*& bot,
				    VFission*& left,
				    VFission*& right)
{
  if (!IsRectRgnSelection())
  {
    return False;
  }
  
  HFission* from_top;
  HFission* from_bot;
  VFission* from_left;
  VFission* from_right;
  rect_rgn_cp1->GetCellFission(*((Fission**) &from_top),
				 *((Fission**) &from_bot), 
				 *((Fission**) &from_left),
				 *((Fission**) &from_right));
  HFission* to_top;
  HFission* to_bot;
  VFission* to_left;
  VFission* to_right;
  rect_rgn_cp2->GetCellFission(*((Fission**) &to_top),
			       *((Fission**) &to_bot), 
			       *((Fission**) &to_left),
			       *((Fission**) &to_right));
  
  top   = (from_top->Y() < to_top->Y()) ? from_top : to_top;
  bot   = (from_bot->Y() > to_bot->Y()) ? from_bot : to_bot;
  left  = (from_left->X() < to_left->X()) ? from_left : to_left;
  right = (from_right->X() > to_right->X()) ? from_right : to_right;
  return True;
}

bool 
EditFrame::ExistSingleFrameRegion()
{
  HFission* top;
  HFission* bot;
  VFission* left;
  VFission* right;
  return ExistSingleFrameRegion(top, bot, left, right);
}

bool 
EditFrame::ExistSingleFrameRegion(HFission*& top,
				   HFission*& bot,
				   VFission*& left,
				   VFission*& right)
{
  if (!GetSingleFrameRegionRim(top, bot, left, right))
  {
    return False;
  }
  if ((top->FindCrossPoint(left) != 0) &&
      (top->FindCrossPoint(right) != 0) &&
      (bot->FindCrossPoint(left) != 0) &&
      (bot->FindCrossPoint(right) != 0))
  {
    return True;
  }
  return False;
}

// ------------------------------------------------------------
// insert frame

bool
EditFrame::GetInsertRegion(FrameRectRgn& rgn, bool insert_line)
{
  if ((min_x_cp == 0) || (max_x_cp == 0) ||
      (min_y_cp == 0) || (max_y_cp == 0))
  {
    return False;
  }
  FissionFrame* ff = min_x_cp->GetFissionFrame();
  if (insert_line)
  {
    // horizontal region
    FrameRectRgn top_rgn(min_y_cp);
    FrameRectRgn bot_rgn(max_y_cp);
    rgn.Set(top_rgn.GetTop(), bot_rgn.GetBottom(),
	     ff->GetLeft(), ff->GetRight());
  }
  else
  {
    // vertical region
    FrameRectRgn lft_rgn(min_x_cp);
    FrameRectRgn rgh_rgn(max_x_cp);
    rgn.Set(ff->GetTop(), ff->GetBottom(),
	     lft_rgn.GetLeft(), rgh_rgn.GetRight());
  }
  return rgn.ValidP();
}

// check insert line posibility
bool 
EditFrame::PosibleInsertLine()
{
  FrameRectRgn rgn;
  return GetInsertRegion(rgn, True);
}

// check insert column posibility
bool 
EditFrame::PosibleInsertColumn()
{
  FrameRectRgn rgn;
  return GetInsertRegion(rgn, False);
}

// table selection check
bool 
EditFrame::TableSelectedP()
{
  return(((LayoutTemplate*)GetSelectedFrameFF()
	  ->GetFrameOwner())
	  ->IsTable());
}
  
// zeropage selection check
bool 
EditFrame::ZeroPageSelectedP()
{
  return(((LayoutTemplate*)GetSelectedFrameFF()
	  ->GetFrameOwner())
	  ->IsZeroPage());
}

bool 
EditFrame::ExistInsertableFrameSel()
{
  return(ExistFrameSelection() &&
	  (PosibleInsertLine() || PosibleInsertColumn()));
}

void 
EditFrame::InsertFrameSelection(bool keep_size, 
				 bool post_insert,
				 bool insert_line,
				 uword copy_num)
{
  FrameRectRgn rgn;
  if (!GetInsertRegion(rgn, insert_line))
  {
    return; // can't insert 
  }
  FissionFrame* ff = GetSelectedFrameFF();
  Vector size = ff->GetSize();
  ClearFrameSelection();
  ff->DisconnectOverlappedLine(rgn);
  BluePrint* bp = new BluePrint();
  bp->MakeSeed(ff);
  bp->CopyRegion(ff->GetFrameOwner(), rgn, insert_line);
  for (uword i = 0; i < copy_num; i++)
  {
    ff->MakeDuplicateRegion(rgn, post_insert, insert_line);
    bp->PlayRegion(ff->GetFrameOwner(), rgn, insert_line);
  }
  delete bp;
  ff->MergeFission();
  
  // reformat
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  if (keep_size || !lt->IsTable())
  { // original size
    ff->ChangeSize(size.x, size.y);
    if (Selected_Window != 0)
    {
      Selected_Window->InvalidateLayout(lt);
    }
  }
  else
  { // change size
    size = ff->GetSize();
    Panel* pnl = doc->GetDocumentContent()->GetTablePanel(lt);
    pnl->ChangeSize(size.x, size.y);
  }
  SetDirty();
  UnforceTouchCaret();
}

// ------------------------------------------------------------
// delete frame

bool
EditFrame::GetDeleteRegion(FrameRectRgn& rgn, bool delete_line)
{
  return GetInsertRegion(rgn, delete_line);
}

bool 
EditFrame::PosibleDeleteLine()
{
  FrameRectRgn rgn;
  return GetDeleteRegion(rgn, True);
}

bool 
EditFrame::PosibleDeleteColumn()
{
  FrameRectRgn rgn;
  return GetDeleteRegion(rgn, False);
}

bool 
EditFrame::ExistDeletableFrameSel()
{
  return(ExistFrameSelection() &&
	  (PosibleDeleteLine() || PosibleDeleteColumn()));
}

void 
EditFrame::DeleteFrameSelection(bool keep_size, 
				 bool remove_line)
{
  FrameRectRgn rgn;
  if (!GetDeleteRegion(rgn, remove_line))
  {
    return;// can't delete
  }
  FissionFrame* ff = GetSelectedFrameFF();
  if ((rgn.GetTop() == ff->GetTop()) &&
      (rgn.GetBottom() == ff->GetBottom()) &&
      (rgn.GetLeft() == ff->GetLeft()) &&
      (rgn.GetRight() == ff->GetRight()))
  {
    // delete hole of the table or page
    MessageBeep(0); // now..
    return;
  }
  ClearFrameSelection();
  Vector size = ff->GetSize();
  ff->DeleteRegion(rgn, remove_line);
  // reformat
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  if ((keep_size) ||
      !lt->IsTable())
  {
    // original size
    ff->ChangeSize(size.x, size.y);
    if (Selected_Window != 0)
    {
      Selected_Window->InvalidateLayout(lt);
    }
  }
  else
  {
    // change size
    size = ff->GetSize();
    Panel* pnl = doc->GetDocumentContent()->GetTablePanel(lt);
    pnl->ChangeSize(size.x, size.y);
  }
  SetDirty();
  UnforceTouchCaret();
}

// ------------------------------------------------------------
// combine selected frame

bool
EditFrame::CanCombineFrame()
{
  FrameRectRgn rgn;
  return GetSingleFrameRegionRim(rgn);
}

void 
EditFrame::CombineFrame(bool combine_vertical, 
			 bool combine_horizontal)
{
  FrameRectRgn rgn;
  if (!GetSingleFrameRegionRim(rgn))
  {
    return;
  }
  FissionFrame* ff = GetSelectedFrameFF();
  ClearFrameSelection();
//  ff->ClearSingleFrameRegion(rgn);
  ff->CombineFrameRegion(rgn, combine_vertical, combine_horizontal);
  // invalidate
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  if (Selected_Window != 0)
  {
    Selected_Window->InvalidateLayout(lt);
  }
  SetDirty();
  UnforceTouchCaret();
}

// ------------------------------------------------------------
// align selected frame

bool
EditFrame::CanAlignFrame()
{
  FrameRectRgn rgn;
  return GetSingleFrameRegionRim(rgn);
}

void
EditFrame::AlignFrame(bool align_vertical,
		       bool align_horizontal)
{
  FrameRectRgn rgn;
  if (!GetSingleFrameRegionRim(rgn))
  {
    return;
  }
  FissionFrame* ff = GetSelectedFrameFF();
  ClearFrameSelection();
  ff->AlignFrameRegion(rgn, align_vertical, align_horizontal);

  // invalidate
  LayoutTemplate* lt = (LayoutTemplate*)ff->GetFrameOwner();
  if (Selected_Window != 0)
  {
    Selected_Window->InvalidateLayout(lt);
  }
  SetDirty();
  UnforceTouchCaret();
}
