// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: setmark.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implement the SetMarkDialog class for PWord SetMark dialog box

#include "pword.h"
#include "pmenus.h"
#include "pwordpre.h"
#include "dialogs.h"
#include "marks.h"
#include "xstr.h"
#include "setmark.h"

SetMarkDialog::SetMarkDialog(char* suggestion)
{
  this->class_name = "SetMarkDlg";
  if (!suggestion) 
  {
    MarkName[0] = NULL;
  }
  else
  {
    ::copy_string(MarkName, suggestion, MARKNAMELEN + 1);
  }
}

LRESULT_T
SetMarkDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      this->SendItemMessage(IDD_SetMarkName, EM_LIMITTEXT, MARKNAMELEN);
      this->SetItemText(IDD_SetMarkName, MarkName);
    }
    return 1;

    // WM_CLOSE comes when the user closes the box with the Close
    // command from the control menu
			
   case WM_CLOSE:
    this->End(0);
    return(1);

   case WM_COMMAND:		// OK button
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      if (GlobalMarkTable.GetMarkByName(MarkName, Selected_Document)) 
      {
	switch (IssueVA(S_SetMark_RedefineMsg,
			 MB_ICONQUESTION | MB_OKCANCEL, MarkName)) 
	{
	 case IDOK:
	  break;
	 case IDCANCEL:
	  return 0;
	}
      }
      this->End(1);
      break;
				
     case IDD_SetMarkName:
      this->GetItemText(IDD_SetMarkName, MarkName, MARKNAMELEN+1);
      ::EnableWindow(GetItem(IDOK), *MarkName);
      break;

     case IDCANCEL:
      this->End(0);
      break;
					
     default:
      break;
    }
		
   default: 
    break;
  }
  return 0;
}
