// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: sizeadj.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of SizeAdjDialog class for dialog boxes

#include "pword.h"
#include <stdlib.h>
#include "pmenus.h"
#include "dialogs.h"
#include "sizeadj.h"

LONG SizeAdjDialog::old_wndproc = 0;

SizeAdjDialog::SizeAdjDialog(int char_size, int cur_delta_size)
  : NumDialog(1/*set*/, cur_delta_size)
{
  this->class_name = "SizeAdjDlg";
  this->char_size = char_size;
}

LRESULT_T
SizeAdjDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T lParam)
{
	
  switch (Msg)
  {
   // to initialize the dialog, fill in the static field showing the
   // current character size, and set the radio button to the right
   // polarity.  Other initialization is handled by NumDialog.
   
   case WM_INITDIALOG:
    SetItemInt(IDD_SizeAdj_BaseSize, char_size);
    if (value<0)
    {
      value = -value;
      set_item_check(IDD_SubSize);
    }
    else {
      set_item_check(IDD_AddSize);
    }
    {
      HWND base_handle = GetItem(IDD_SizeAdj_BaseSize);
      old_wndproc = GetWindowLong(base_handle, GWL_WNDPROC);
      SetWindowLong(base_handle,
		     GWL_WNDPROC, (LONG) SizeAdjDialog::OurWndProc);
    }
    break; // to pass msg to NumDialog
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      {
	if (get_item_check(IDD_SubSize))
	{
	  value = -value;
	  break;
	}
      }
     default:
      break;
    }
    break;
    
   default: 
    break;
  }
  return NumDialog::WndProc(Msg,wParam,lParam);
}

int
SizeAdjDialog::CheckValue(int val)
{
  return(val <= 9);
}

LRESULT_T
SizeAdjDialog::OurWndProc_ (HWND h,
			    MSG_T msg, WPARAM_T wParam, LPARAM_T lParam)
{
  switch (msg)
  {
  case WM_SETCURSOR:
  case WM_LBUTTONDOWN:
  case WM_MBUTTONDOWN:
  case WM_RBUTTONDOWN:
  case WM_MOUSEMOVE:
  case WM_KEYDOWN:
  case WM_CHAR:
    {
      return 0;
    }
    
  default:
    break;
  }
  return CallWindowProc((WNDPROC) old_wndproc, h, msg, wParam, lParam);
}
