// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: statdlg.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of StatDialog class for dialog boxes
// where you enter a single number

#include "pword.h"
#include <stdlib.h>
#include "pmenus.h"
#include "document.h"
#include "docconte.h"
#include "dialogs.h"
#include "statdlg.h"

LRESULT_T
StatDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {
      if (!Selected_Document)
      {
	return 1;
      }
      DocumentContent* dc = Selected_Document->GetDocumentContent();
      dc->Format();
      
      Stats stats;
      dc->Count(stats);
      StatusOut("");
      
      typedef char buf[16];
      buf bzen, bhan, bpar, bline, bflow, bpage;
      ltoa(stats.zen, bzen, 10);
      ltoa(stats.han, bhan, 10);
      ltoa(stats.par, bpar, 10);
      ltoa(stats.line, bline, 10);
      ltoa(stats.flow, bflow, 10);
      ltoa(stats.page, bpage, 10);
      
      SendItemMessage(IDD_Stat_Zen, WM_SETTEXT, 0, Ptr2Long(bzen));
      SendItemMessage(IDD_Stat_Han, WM_SETTEXT, 0, Ptr2Long(bhan));
      SendItemMessage(IDD_Stat_Pars, WM_SETTEXT, 0, Ptr2Long(bpar));
      SendItemMessage(IDD_Stat_Lines, WM_SETTEXT, 0, Ptr2Long(bline));
      SendItemMessage(IDD_Stat_Flows, WM_SETTEXT, 0, Ptr2Long(bflow));
      SendItemMessage(IDD_Stat_Pages, WM_SETTEXT, 0, Ptr2Long(bpage));
      char* name = Selected_Document->GetPathName();
      if (!*name)
      {
	name = "--";
      }
      char* c,* brak=0;
      for (c=name; *c; c=::AnsiNext(c))
      {
	if (c-name > 24)
	{
	  if (!brak) // no break found
	  {
	    brak = c; // break right here
	  }
	  break;
	}
	if (*c == '\\' || *c == '/')
	{
	  brak = c;
	}
      }
      if (!*c) // ran off end
      {
	SendItemMessage(IDD_Stat_FullPath, WM_SETTEXT, 0, (LONG)name);
      }
      else
      {
	char store = *++brak;
	*brak = '\0';
	SendItemMessage(IDD_Stat_FullPath, WM_SETTEXT, 0, (LONG)name);
	*brak = store;
	SendItemMessage(IDD_Stat_FullPath2, WM_SETTEXT, 0, (LONG)brak);
      }
    }    
    return 1;
    
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
     case IDOK:
      End(1);
      return 1;

     default:
      break;
    }
   
   case WM_CLOSE:
    End(0);
    return 1;

   default: 
    return 0;
  }
}

StatDialog::StatDialog()
{
  this->class_name = "Stat";
}
