// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: styles.h,v 3.3 2000/05/04 13:44:09 kudou Exp $
// define STable and STEntry classes for style tables

#ifndef STYLES_H
#define STYLES_H

#include "generics.h"

class StyleEntry
  : public GenericEntry
{
  friend class BaseStyleTable;
  friend class StyleTable;
  
public:
  enum
  {
    NAMELEN = 32,
  };
  
private:
  int at_index;			// attribute info
  char name[NAMELEN + 1];
  int type;			// xxxxSTYLE
  int count;                    // of entries with same name, kept on first
  int dead;

public:
  StyleEntry();
  StyleEntry(char* name, int type);

private:
  unsigned char NEAR GetHash();
  void NEAR Init();
public:
  AttsEntry& GetAttsEntry();
  char* get_pure_name();
  int GetType();
  unsigned int Enter();
  unsigned int GetAttsIndex();
  void AddToInterface(unsigned int i, void*);
  void Mark();
  void ReadFromStream(PStream* stream);
  void RemoveFromInterface(unsigned int i);
  void SetAttsIndex(int at_index);
  void WriteToStream(PStream* stream);
#ifndef NDEBUG
  void Dump(unsigned int i, void*);
  static void DumpHeader(FILE* f);
#endif
  
public:
  friend int operator == (StyleEntry&, StyleEntry&);
};

inline unsigned int
StyleEntry::GetAttsIndex()
{
  return(this->at_index);
}

inline void
StyleEntry::SetAttsIndex(int at_index)
{
  this->at_index = at_index;
}

inline int
StyleEntry::GetType()
{
  return(this->type);
}

inline char* 
StyleEntry::get_pure_name()
{
  return(this->name);
}

#define T StyleEntry
#define TABLE BaseStyleTable
#define SEG BaseStyleTableSeg
#define DO_READ_WRITE
#include "tabletem.h"

class StyleTable
  : public BaseStyleTable
{
public:
  unsigned int FindEntry(char* name, int type, int include_dead);
  void Kill(uword i);
  void Resurrect(uword i);

public:
  static void register_static_menus();
};

extern StyleTable STATIC_NEAR GlobalStyleTable;

#endif /* STYLES_H */
