// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: table.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Table class
// \\NXB̃NX͒PageMappB܂A
// TablePanel Ƒ݂Ƀ|CgĂB

#include "pword.h"
#include "tflist.h"
#include "table.h"
#include "fission.h"
#include "frameown.h"
#include "borderli.h"
#include "attribut.h"
#include "textflow.h"
#include "bufnew.h"
#include "pstreams.h"
#include "layoutte.h"
#include "layoutin.h"
#include "uniqltl.h"
#include "frametem.h"
#include "grphobjc.h"
#include "blueprin.h"
#include "panel.h"
#include "metafile.h"
#include "mfobject.h"
#ifndef NDEBUG
#include "docconte.h"
#include "ddisplay.h"
#endif

// default table frame margin
Margin STATIC_NEAR Table::default_margin(0,
					  0,
					  Point_to_iu(DEFAULT_POINT / 2), 
					  Point_to_iu(DEFAULT_POINT / 2));

LayoutTemplate* 
Table::GenerateTemplate(DocumentContent* doc, 
			 Iunit width, Iunit height)
{
  uword border = BorderLine::GetDefaultTableIndex();
  BluePrint* bp = BluePrint::GetTableBluePrint(width, height, border);
  return new LayoutTemplate(doc, bp, LayoutTemplate::TableTemplate);
}

// divide table
void 
Table::Divide(uword column, uword row)
{
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  uword border_index = BorderLine::GetDefaultTableIndex();
  Vector size = ff->GetSize();
  if (column > 1) 
  {
    Fission* top    = ff->GetTop();
    Fission* bottom = ff->GetBottom();
    for (uword n = 1; n < column; n++) 
    {
      Iunit pos = (Iunit) (((Lunit)size.x * n) / (Lunit)column);
      ff->Divide(top, bottom, pos, border_index);
    }
  }
  if (row > 1) 
  {
    Fission* left    = ff->GetLeft();
    Fission* right   = ff->GetRight();
    for (uword n = 1; n < row; n++) 
    {
      Iunit pos = (Iunit) (((Lunit)size.y * n) / (Lunit)row);
      ff->Divide(left, right, pos, border_index);
    }
  }
}

void 
Table::NewFlow(uword column, uword row)
{
  if ((column == 0) && (row == 0)) 
  {
    return;
  }
  
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  CrossPoint* left_top = ff->GetTop()->GetStartCrossPoint();
  CrossPoint* left = left_top;
  for (uword r = 1; r <= row; r++) 
  {
    CrossPoint* cp = left;
    for (uword c = 1; c <= column; c++) 
    {
      FrameTemplate* ft = (FrameTemplate*)ff->CreateInitialFlow(cp);
      ft->SetMargin(default_margin);
      PageMap::Add(ft, 0);	// set dummy flow
      cp = cp->GetHNext();
    }
    left = left->GetVNext();
  }
}

LayoutTemplate* 
Table::GenerateTemplate2(DocumentContent* doc, 
			  Iunit width, Iunit height)
{
  BluePrint* bp = BluePrint::GetTableBluePrint(width, height, 0);
  return new LayoutTemplate(doc, bp, LayoutTemplate::TableTemplate);
}

// paste picture
void 
Table::PastePicture(Picture* pic)
{
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  CrossPoint* cp = ff->GetTop()->GetStartCrossPoint();
  GraphicObject* gr = new GraphicObject(cp, pic);
  cp->CreateFrameObject(gr);
}

// paste metafile
void 
Table::PasteMetafile(Metafile* mf)
{
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  CrossPoint* cp = ff->GetTop()->GetStartCrossPoint();
  MetafileObject* mo = new MetafileObject(cp, mf);
  cp->CreateFrameObject(mo);
}


// constructor
Table::Table(DocumentContent* doc, Iunit width, Iunit height,
	      uword column, uword row)
  : PageMap(doc, GenerateTemplate(doc, width, height))
{
  panel = 0;
  // create template
  Divide(column, row);
  NewFlow(column, row);
  
  // create flow
  uword gate_size = GetGateSize();
  for (uword i = 1; i <= gate_size; i++) 
  {
    TextFlow* tf = new TextFlow(GetDocumentContent());
    Replace(i, tf);			// textflow - gate map
  }
  SetupFlow();
  
  // create page
  layout = GenerateNPage(1);
}

// constructor as picture table
Table::Table(DocumentContent* doc, Iunit width, Iunit height, Picture* pic)
  : PageMap(doc, GenerateTemplate2(doc, width, height))
{
  panel = 0;
  PastePicture(pic);
  layout = GenerateNPage(1);
}

// constructor as picture table
Table::Table(DocumentContent* doc, Iunit width, Iunit height, Metafile* mf)
  : PageMap(doc, GenerateTemplate2(doc, width, height))
{
  panel = 0;
  PasteMetafile(mf);
  layout = GenerateNPage(1);
}

// constructor for file read
Table::Table(LayoutTemplate*)
  : PageMap()
{
  panel = 0;
  layout = 0;
}

// destructor
Table::~Table()
{
  // Page-map destructor is automatically called.
  // The layout-instance and template are deleted 
  // in page-map destructor.
}

// setup flow
void 
Table::SetupFlow()
{
  // initialize textflow
  TFListIterator tfli(GetTFMap());
  TextFlow* tf;
  while ((tf = tfli()) != 0) 
  {
    tf->SeedParagraph();
  }
}

// change panel size
void 
Table::ChangeSize(Iunit width, Iunit height)
{
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  ff->ChangeSize(width, height);
}

// change panel size with no scalling
void 
Table::StretchSize(Iunit top_diff, Iunit bot_diff,
		    Iunit lef_diff, Iunit rig_diff)
{
  FissionFrame* ff = GetLayoutTemplate()->GetFissionFrame();
  ff->StretchSize(top_diff, bot_diff, lef_diff, rig_diff);
}

// set table position
// x, y		: document coordinate position.
void 
Table::SetPosition(Lunit x, Lunit y)
{
  for (LayoutInstance* li = layout;
       li != 0;
       li = li->GetNextPageMapLayout()) 
  {
    li->SetLX(x);
    li->SetLY(y);
  }
}

// get textflow SID 
uword 
Table::GetTextFlowSID(TextFlow* tf)
{
  return GetGateNumber(tf);
}

// get default margin
Margin 
Table::GetDefaultFrameMargin()
{
  return Margin(0, 0, Point_to_iu(DEFAULT_POINT / 2), 
		 Point_to_iu(DEFAULT_POINT / 2));
}
