// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: table.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// Table class
// \\NXB̃NX͒PageMappB܂A
// TablePanel Ƒ݂Ƀ|CgĂB

#ifndef TABLE_H
#define TABLE_H

#include "margin.h"
#include "pagemap.h"

class FrameScriptRep;
class LayoutTemplate;

class Picture;
class Metafile;
class Panel;

// table class
class Table 
  : public PageMap
{
private:
  // layout
  LayoutInstance* layout;
  
  // panel
  Panel* panel;
  
  // default table frame margin
  static Margin STATIC_NEAR default_margin;
  
private:
  // ------------------------------
  // for ordinary table
  
  // create layout-template
  static LayoutTemplate* GenerateTemplate(DocumentContent* doc,
                                           Iunit width, Iunit height);
  
  // setup flow
  void SetupFlow();
  
  // divide table
  void Divide(uword column, uword row);
  
  // new flow
  void NewFlow(uword column, uword row);
  
  // ------------------------------
  // for picture table
  
  // create picture layout-template
  static LayoutTemplate* GenerateTemplate2(DocumentContent* doc,
                                            Iunit width, Iunit height);
  
  // paste picture
  void PastePicture(Picture* pic);
  
  // paste metafile
  void PasteMetafile(Metafile* mf);
  
public:
  // constructor as ordinary table
  Table(DocumentContent* doc, Iunit width, Iunit height, 
         uword column, uword row);
  
  // constructor as picture table
  Table(DocumentContent* doc, Iunit width, Iunit height, Picture* pic);
  
  // constructor for metagile
  Table(DocumentContent* doc, Iunit width, Iunit height, Metafile* mf);
  
  // constructor, for file read
  Table(LayoutTemplate* lt);
  
  // destructor
  ~Table();
  
  // get panel
  Panel* GetPanel() 
  {
    return panel;
  }
  
  // set panel
  void SetPanel(Panel* p) 
  {
    panel = p;
  }
  
  // change panel size with scalling
  void ChangeSize(Iunit width, Iunit height);
  
  // change panel size with no scalling
  void StretchSize(Iunit top_diff, Iunit bot_diff,
                    Iunit lef_diff, Iunit rig_diff);
  
  // set table position
  // x, y		: document coordinate position.
  void SetPosition(Lunit x, Lunit y);
  
  // get layout
  LayoutInstance* GetLayout() 
  {
    return layout;
  }
  
  // set layout
  void SetLayout(LayoutInstance* li) 
  {
    layout = li;
  }
  
  // get textflow SID(Save ID)
  uword GetTextFlowSID(TextFlow*);
  
  // get default margin
  static Margin GetDefaultFrameMargin();
};

#endif /* TABLE_H */
