// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: tabletem.cpp,v 3.4 1999/09/05 04:23:43 kudou Exp $
// table

#ifdef T
// This file is included by other .cpp files with some macro
// definitions.

#include "pstreams.h"
#include "xstr.h"

// ------------------------------------------------------------
// SEG class

#ifdef BW2_NEW_ATTR
DEFINE_SMARTNEW(SEG)
#else /* not BW2_NEW_ATTR */
void* CDECL
#ifndef NDEBUG
SEG::operator new(size_t size)
#else
SEG::operator new(size_t /*size*/)
#endif
{
  assert(size == sizeof(SEG));
  assert(sizeof(SEG) < (1 << LOG2_OF_MAX_ALLOC));
  return(xmalloc_on_log2(ceil_log2(sizeof(SEG))));
}

void CDECL
SEG::operator delete(void* mem)
{
  xfree_on_log2(mem, ceil_log2(sizeof(SEG)));
}
#endif /* not BW2_NEW_ATTR */

// To compact code size, we define empty constructor and destructor in
// nere, because class SEG has a array of class T.

// public constructor
SEG::SEG()
{
#ifdef BW2_NEW_ATTR
  memset(array, 0, sizeof(array));
  array[0] = new T;
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */
}

// public destructor
SEG::~SEG()
{
#ifndef NDEBUG
  syserr("SEG::~SEG called");
#endif
}

#ifdef CHECKIDX
void
SEG::CheckIndex(unsigned int a)
{
  if (256 <= a)
  {
    syserr("CheckIndex : a < 256");
  }
#ifdef BW2_NEW_ATTR
  if (this->array[a] == NULL)
  {
    syserr("CheckIndex: NULL entry on index %d\n", a);
  }
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */
}
#endif /* CHECKIDX */

// ------------------------------------------------------------
// TABLE class

TABLE::TABLE()
{
  assert((1 << 9) == sizeof(SEG *) * 128);
#ifdef BW2_NEW_ATTR
#else /* not BW2_NEW_ATTR */
  this->data = (SEG **) xmalloc_on_log2(9);
#endif /* not BW2_NEW_ATTR */
  memset(this->data, 0, sizeof(SEG *) * 128);
  this->data[0] = new SEG;
}

#ifdef DEADABLE_ENTRY
void
TABLE::RemoveHash(T* e)
{
  unsigned int* place = &this->hash_table[e->GetHash()];
  unsigned int a;
  while ((a = *place) != 0)
  {
    T* entry;
    if ((entry = this->GetEntryPointer(a)) == e)
    {
      *place = e->chain;
      e->chain = 0;
      break;
    }
    place = &entry->chain;
  }
}
#endif

// NextEntry -- find the next spot in the table, extending and
// initializing it if necessary
unsigned int
TABLE::NextEntry()
{
  unsigned int a;
  
#ifdef DEADABLE_ENTRY
  a = this->GetNEntries();
  while (--a)
  {
    if (this->GetEntry(a) .GetDead())
    {
      return(a);
    }
  }
#endif
  
  if ((a = this->nEntries++) == this->nMax)
  {
    assert(this->data[a >> 8] == NULL);
    this->nMax = a + 256;
    this->data[a >> 8] = new SEG;
  }
#ifdef BW2_NEW_ATTR
  else
  {
    (this->data[a >> 8])->Set((unsigned char) a, new T);
  }
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */
  return(a);
}

unsigned int
TABLE::FindEntry(T& entry)
{
  unsigned int a = this->hash_table[entry.GetHash()];
  while (a != 0)
  {
    T& e = this->GetEntry(a);
    if (e == entry)
    {
      break;
    }
    a = e.chain;
  }
  return(a);
}

unsigned int
TABLE::MakeEntry(T& entry)
{
  assert(entry.GetMark() == 0);
  assert(entry.chain == 0);
  
  unsigned int* place = &this->hash_table[entry.GetHash()];
  unsigned int a;
  
  while ((a = *place) != 0)
  {
    T& e = this->GetEntry(a);
    place = &e.chain;
    if (e == entry)
    {
#ifdef FORCE_MAKE_ENTRY
      int old_mark = e.GetMark();
      unsigned int old_chain = e.chain;
      e.Destroy();
      e = entry;
      e.chain = old_chain;
      e.SetMark(old_mark);
#endif
      return(a);
    }
  }
  
  *place = a = this->NextEntry();
  {
    T &e = this->GetEntry(a);
    int old_mark = e.GetMark();
    e.Destroy();
    e = entry;
    e.chain = 0;
    e.SetMark(old_mark);
#ifndef NO_ENTRY_ADD_TO_INTERFACE
    e.AddToInterface(a, 0);
#endif
  }
  return(a);
}

// Routines related to reading and writing tables onto streams
// virtual method
void
TABLE::ClearMarks()
{
  this->cached_index = 0;
  this->marked = 0;
  SEG** data = this->data;
#ifdef BW2_NEW_ATTR
  unsigned int n = this->GetNEntries();
  for (unsigned int i = 0;; ++i)
  {
    SEG* seg = data[i];
    for (unsigned int j = 0; j != 256; ++j)
    {
      seg->Get(j) ->ClearMark();
      if (--n == 0)
      {
	return;
      }
    }
  }
#else /* not BW2_NEW_ATTR */
  unsigned int i = this->nMax >> 8;
  do
  {
    --i;
    SEG* seg = data[i];
    for (unsigned int j = 0; j != 256; ++j)
    {
      seg->Get(j) ->ClearMark();
    }
  } while (i);
#endif /* not BW2_NEW_ATTR */
}

#ifdef DO_READ_WRITE
void
TABLE::WriteEntry(PStream* stream, unsigned int i)
{
  if (!(stream->GetWhat() & PStream::WW_ATTCONTENT))
  {
    stream->OutWord(i);
  }
  else 
  {
    if (i == 0)
    {
      stream->OutByte(ZERO_INDEX);
    }
#ifdef _WIN32
    else if (i == AttsEntry::UNKNOWN)
#else /* _WIN32 */
    else if (i == 0x8000u) 
#endif /* _WIN32 */
    {
      stream->OutByte(UNKNOWN_INDEX);
    }
    else if (i == cached_index)
    {
      stream->OutByte(SAME_INDEX);
    }
    else
    {
      T &e = GetEntry(i);
      int mapped;
      if ((mapped = e.GetMark()) != 0)
      {
	stream->OutByte(NONZERO_INDEX);
	stream->OutWord(mapped);
      }
      else
      {
	stream->OutByte(FULL_ENTRY);
	e.WriteToStream(stream);
	e.SetMark(++marked);
      }
    }
    // set this AFTER we finish writing
    cached_index = i;
  }
}
#endif

#ifdef DO_READ_WRITE
unsigned int
TABLE::ReadEntry(PStream* stream)
{
  if (!(stream->GetWhat() & PStream::WW_ATTCONTENT))
  {
    uword ret = stream->InUWord();
    CHECK 0;
    return ret;
  }
  
  byte indexp = stream->InByte();
  CHECK 0;
  switch (indexp)
  {
   case ZERO_INDEX:
    return(0);

   case UNKNOWN_INDEX:
#ifdef _WIN32
    return AttsEntry::UNKNOWN;
#else /* _WIN32 */
    return(0x8000u);
#endif /* _WIN32 */

   case NONZERO_INDEX:
    {
      int mapped = stream->InWord();
      CHECK 0;
      mapped = GetEntry(mapped).GetMark();
      return(cached_index = mapped);
    }

   case FULL_ENTRY:
    {
      assert(stream->GetWhat() & PStream::WW_ATTCONTENT);
      T e;
      e.ReadFromStream(stream);
      CHECK 0;
      unsigned int ret;
      cached_index = ret = e.Enter();
      GetEntry(++marked) .SetMark(ret);
      return(ret);
    }
    
   default:
#ifndef NDEBUG
    syserr("invalid att index type in file");
#endif
    // no break
    
   case SAME_INDEX:
    return(cached_index);
  }
}
#endif

// applying and dumping
void
TABLE::Apply(void(T::*func)(unsigned int, void*), void* stuff)
{
  unsigned int limit = this->GetNEntries();
  unsigned int a = 0;
  while (++a != limit)
  {
    (this->GetEntry(a) .*func) (a, stuff);
  }
}

#ifdef CHECKIDX
void
TABLE::CheckIndex(unsigned int a)
{
  if (a == 0)
  {
    syserr("zero entry in %s table(%d)", XXSTR(TABLE), a);
  }
#if 1
  if (nEntries == a)
  {
    unsigned int x = TABLE::NextEntry();
    if (x != a)
    {
      syserr("invalid entry in %s table(%d:%d)", XXSTR(TABLE), a, x);
    }
    else
    {
      Issue(S_InvalidTableEntryFix, MB_OK | MB_ICONSTOP);
    }
  }
  else if (nEntries < a)
  {
    syserr("invalid entry in %s table(%d)", XXSTR(TABLE), a);
  }
#else
  if (this->nEntries <= a)
  {
    syserr("invalid entry in %s table(%d)", XXSTR(TABLE), a);
  }
#endif
}
#endif /* CHECKIDX */

#ifndef NDEBUG
void
TABLE::Dump(FILE* f)
{
  T::DumpHeader(f);
  this->Apply(&T::Dump, (void*) f);
}
#endif

#undef DEADABLE_ENTRY
#undef DO_READ_WRITE
#undef FORCE_MAKE_ENTRY
#undef NO_ENTRY_ADD_TO_INTERFACE
#undef SEG
#undef T
#undef TABLE

#endif /* T */
