// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: tabletem.h,v 3.3 1999/09/05 04:23:43 kudou Exp $
// class TABLE

#include "generics.h"

#ifdef BW2_NEW_ATTR
#include "smartnew.h"
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */

//#ifndef NDEBUG
#define CHECKIDX
//#endif

// ------------------------------------------------------------
// SEG class

class SEG
{
#ifdef BW2_NEW_ATTR
  T* array[256];
#else /* not BW2_NEW_ATTR */
  T array[256];
#endif /* not BW2_NEW_ATTR */

public:
  SEG();
  ~SEG();
  
public:
  T* Get(unsigned int a);
#ifdef BW2_NEW_ATTR
  void Set(unsigned int a, T* t);
  REFER_SMARTNEW(SEG)
#else /* not BW2_NEW_ATTR */
  void* CDECL operator new(size_t size);
  void CDECL operator delete(void* mem);
#endif /* not BW2_NEW_ATTR */
#ifdef CHECKIDX
  void CheckIndex(unsigned int a);
#endif /* CHECKIDX */
};

inline T* 
SEG::Get(unsigned int a)
{
#ifdef CHECKIDX
  this->CheckIndex(a);
#endif /* CHECKIDX */
#ifdef BW2_NEW_ATTR
  return(this->array[a]);
#else /* not BW2_NEW_ATTR */
  return(&this->array[a]);
#endif /* not BW2_NEW_ATTR */
}

#ifdef BW2_NEW_ATTR
inline void
SEG::Set(unsigned int a, T* t)
{
  this->array[a] = t;
}
#else /* not BW2_NEW_ATTR */
#endif /* not BW2_NEW_ATTR */

// ------------------------------------------------------------
// TABLE class

class TABLE
  : public GenericTable
{
private:
#ifdef BW2_NEW_ATTR
  SEG* data[128];
#else /* not BW2_NEW_ATTR */
  SEG** data;
#endif /* not BW2_NEW_ATTR */
  
public:
  TABLE();
  
public:
  virtual void ClearMarks();
  
public:
  T& GetEntry(unsigned int a);
  T* GetEntryPointer(unsigned int a);
  unsigned int FindEntry(T&);
  unsigned int MakeEntry(T&);
  unsigned int NextEntry();
  void Apply(void(T::*)(unsigned int, void*), void*);
  
#ifdef DEADABLE_ENTRY
  void RemoveHash(T* e);
#endif
  
#ifdef DO_READ_WRITE
  unsigned int ReadEntry(PStream*);
  void WriteEntry(PStream* , unsigned int);
#endif
  
public:
#ifndef NDEBUG
  virtual void Dump(FILE* f);
#endif
#ifdef CHECKIDX
  void CheckIndex(unsigned int a);
#endif /* CHECKIDX */
};

inline T*
TABLE::GetEntryPointer(unsigned int a)
{
#ifdef CHECKIDX
  this->CheckIndex(a);
#endif /* CHECKIDX */
  return(this->data[a >> 8]->Get((unsigned char) a));
}

inline T&
TABLE::GetEntry(unsigned int a)
{
  return(*(this->GetEntryPointer(a)));
}

#undef DEADABLE_ENTRY
#undef DO_READ_WRITE
#undef SEG
#undef T
#undef TABLE

