// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: twonumdl.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of TwoNumDialog class for dialog boxes
// where you enter a single number

#include "pword.h"
#include "dialogs.h"
#include "pmenus.h"
#include "twonumdl.h"

TwoNumDialog::TwoNumDialog(int initial_set, 
                                       int initial, int initial2)
  : value(initial)
  , value2(initial2)
  , value_set(initial_set)
  , good(False)
{
}

LRESULT_T
TwoNumDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    if (!value_set) 
    {
      SetItemText(IDD_Value, "");
      SetItemText(IDD_Value2, "");
    }
    else 
    {
      SetItemInt(IDD_Value, value);
      SetItemInt(IDD_Value2, value2);
    }
    return 1;
			
   case WM_COMMAND:
#ifdef _WIN32
    switch (LOWORD(wParam))
#else /* _WIN32 */
    switch (wParam)
#endif /* _WIN32 */
    {
      // for a WM_COMMAND message on IDD_Value,
      // we arbitrarily assume we are being told something changed.
      // We look at the string, then enable or disable the OK
      // button depending on whether it contains a valid size.
     case IDD_Value:
      {
	int translated;
	value = GetItemInt(IDD_Value, &translated);
	// at this point, translated tells us whether or not
	// the thing was a valid integer, so we can use it
	// as the argument to EnableWindow
	good = translated && CheckValue(value, 1);
	EnableWindow(GetItem(IDOK), good);
	break;
      }
     
     case IDD_Value2:
      {
    	int translated;
	value2 = GetItemInt(IDD_Value2, &translated);
	// at this point, translated tells us whether or not
	// the thing was a valid integer, so we can use it
	// as the argument to EnableWindow
	good = translated && CheckValue(value2, 2);
	EnableWindow(GetItem(IDOK), good);
	break;
      }
      
     case IDOK:
      value_set = 1;
      End(1);
      return 1;
     
     case IDCANCEL:
      End(0);
      return 1;
      
     default:
      break;
    }
    break;
    
   case WM_CLOSE:
    End(0);
    return(1);
    
   default: 
    return 0;
  }
  return 0;
}
