// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: unknowno.cpp,v 3.4 2000/05/04 13:44:09 kudou Exp $
// class UnknownObject
// mFrameObjectG[̌ʐ̈𖄂߂FrameObject

#include "pword.h"
#include "unknowno.h"
#include "objectid.h"
#include "vdisplay.h"

// constructor
UnknownObject::UnknownObject(CrossPoint* cp, bool err)
  : FillObject(cp, FillObject::LtGray)
{
  UnknownObject::err = err;
}

// destructor
UnknownObject::~UnknownObject()
{
}

// display object
void 
UnknownObject::DisplayObject(VDisplay* vdsp)
{
  FillObject::DisplayObject(vdsp);
  
  Rect ir = GetInternalRect();
  RECT r = vdsp->ItoWR(ir);
  HDC hDC = vdsp->GetDC();
  
  HPEN pen = err ? 
  ::CreatePen(PS_SOLID, 1, RGB(0xff, 0, 0)) :  // red(error) 
  ::CreatePen(PS_SOLID, 1, RGB(0, 0xff, 0));   // green
  
  HPEN old = (HPEN)::SelectObject(hDC, pen);

#ifdef _WIN32
  ::MoveToEx(hDC, r.left, r.top, NULL);
#else /* _WIN32 */ 
  ::MoveTo(hDC, r.left, r.top);
#endif /* _WIN32 */ 
  ::LineTo(hDC, r.right, r.bottom);
#ifdef _WIN32
  ::MoveToEx(hDC, r.right, r.top, NULL);
#else /* _WIN32 */
  ::MoveTo(hDC, r.right, r.top);
#endif /* _WIN32 */
  ::LineTo(hDC, r.left, r.bottom);
  
  ::SelectObject(hDC, old);
  ::DeleteObject(pen);
}

// get object id
uword 
UnknownObject::GetObjectID()
{
  return IDUnknownObject;
}

// dumplicate object
FrameObject* 
UnknownObject::Duplicator(CrossPoint* cp)
{
  return new UnknownObject(cp, err);
}
