// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: view.cpp,v 3.2 1999/05/12 00:22:16 kudou Exp $
// view

#include "pword.h"
#include "view.h"
#include "rect.h"

// DEFAULT_VIEW keeps Windows screen DC.
View Default_View[1];

// PRINTER_VIEW keeps Windows printer DC.
View Printer_View[1];

View::View()
{
  this->dc = 0;
  SET_POINT(this->view_point, 0, 0);
  this->internal_dpi = IUNITS_PER_INCH;
  this->device_type = SCREEN;
}

// virtual method
// This method never called on exact program.
HDC
View::GetTrueDC()
{
#ifndef NDEBUG
  syserr("View::GetTrueDC is called");
#endif
  return((HDC) 0);
}

// virtual method
// This method never called on exact program.
void
View::ReleaseTrueDC(HDC /*dc*/)
{
#ifndef NDEBUG
  syserr("View::ReleaseTrueDC is called");
#endif
}

// virtual method
HWND
View::MaybeGetWindowHandle()
{
  // It means no window handle.
  return(0);
}

// ------------------------------------------------------------
// basic dc management

// This method adjust scaling factor and some cached values.
void NEAR
View::SetupNewDC()
{
  assert(this->dc);
  SET_POINT(this->device_dpi,
	     GetDeviceCaps(this->dc, LOGPIXELSX),
	     GetDeviceCaps(this->dc, LOGPIXELSY));
}

void
View::ResetDC()
{
  assert(this->dc == 0 || !this->dc_is_mine);
  this->dc = 0;
}

void
View::SetDC(HDC dc)
{
  this->dc = dc;
  this->dc_is_mine = False;
  this->SetupNewDC();
}

void
View::ReleaseDC()
{
  if (this->dc != 0 && this->dc_is_mine)
  {
    this->ReleaseTrueDC(this->dc);
    this->dc = 0;
  }
}

HDC
View::GetDC()
{
  if (this->dc == 0)
  {
    this->dc = this->GetTrueDC();
    this->dc_is_mine = True;
    this->SetupNewDC();
  }
  return(this->dc);
}

// ------------------------------------------------------------
// geometry control

// This method is old interface, new is `SetInternalDPI'.
void
View::SetScaling(int scaling)
{
  assert(0 < scaling);
  
  static struct
  {
    int scaling;
    int internal_dpi;
  } scaling_table[] =
  {
    {25, IUNITS_PER_INCH * 4 / 1,},
    {33, IUNITS_PER_INCH * 3 / 1,},
    {50, IUNITS_PER_INCH * 2 / 1,},
    {67, IUNITS_PER_INCH * 3 / 2,},
    {100, IUNITS_PER_INCH * 1 / 1,},
    {150, IUNITS_PER_INCH * 2 / 3,},
    {200, IUNITS_PER_INCH * 1 / 2,},
    {300, IUNITS_PER_INCH * 1 / 3,},
    {0, 0,},
  };
  
  for (int i = 0;; ++i)
  {
    int internal_dpi = scaling_table[i].internal_dpi;
    if (internal_dpi == 0)
    {
      internal_dpi = (int) ((IUNITS_PER_INCH * 100L) / scaling);
    }
    else if (scaling_table[i].scaling != scaling)
    {
      continue;
    }
    
    this->SetInternalDPI(internal_dpi);
    break;
  }
}

// Convert VAL based on SRC_DPI to based on TARGET_DPI. (funny english ?)
static long NEAR
convert_scaling(int target_dpi, int src_dpi, long val)
{
  return(val < 0
	  ? (val * target_dpi - ((src_dpi - 1) >> 1)) / src_dpi
	  : (val * target_dpi + (src_dpi >> 1)) / src_dpi);
}

// Convert device size DXY to logical size.
Lunit
View::du_to_lu(Dunit dxy, int index_xy)
{
  return((Lunit) convert_scaling(this->internal_dpi,
				   POINT_UNIT(this->device_dpi, index_xy),
				   dxy));
}

// Convert device position DXY to logical position.
Lunit
View::dpos_to_lpos(Dunit dxy, int index_xy)
{
  return(this->du_to_lu(dxy, index_xy)
	  + POINT_UNIT(this->view_point, index_xy));
}

// Convert logical size LXY to long device size.
long
View::lu_to_long_du(Lunit lxy, int index_xy)
{
  return(convert_scaling(POINT_UNIT(this->device_dpi, index_xy),
			   this->internal_dpi, lxy));
}

// Convert logical position LXY to long device position.
long
View::lpos_to_long_dpos(Lunit lxy, int index_xy)
{
  return(this->lu_to_long_du(lxy - POINT_UNIT(this->view_point, index_xy),
			       index_xy));
}

// Convert device size DX to logical size.
Lunit
View::ScaleLunitX(Dunit dx)
{
  return(this->du_to_lu(dx, INDEX_X));
}

// Convert device size DY to logical size.
Lunit
View::ScaleLunitY(Dunit dy)
{
  return(this->du_to_lu(dy, INDEX_Y));
}

// Convert device position DX to logical position.
Lunit
View::LunitX(Dunit dx)
{
  return(this->dpos_to_lpos(dx, INDEX_X));
}

// Convert device position DY to logical position.
Lunit
View::LunitY(Dunit dy)
{
  return(this->dpos_to_lpos(dy, INDEX_Y));
}

// Convert logical size LX to long device size.
long
View::ScaleLongDunitX(Lunit lx)
{
  return(this->lu_to_long_du(lx, INDEX_X));
}

// Convert logical size LY to long device size.
long
View::ScaleLongDunitY(Lunit ly)
{
  return(this->lu_to_long_du(ly, INDEX_Y));
}

// Convert logical position LX to long device position.
long
View::LongDunitX(Lunit lx)
{
  return(this->lpos_to_long_dpos(lx, INDEX_X));
}

// Convert logical position LY to long device position.
long
View::LongDunitY(Lunit ly)
{
  return(this->lpos_to_long_dpos(ly, INDEX_Y));
}

// Convert device point DP to logical point LP.
void
View::dpoint_to_lpoint(Dpoint* dp, Lpoint* lp)
{
  SET_POINT(lp, this->LunitX(POINT_X(dp)), this->LunitY(POINT_Y(dp)));
}

// Convert logical point LP to device point DP.
void
View::lpoint_to_dpoint(Lpoint* lp, Dpoint* dp)
{
  SET_POINT(dp, this->DunitX(POINT_X(lp)), this->DunitY(POINT_Y(lp)));
}

// Convert logical rectangle LR to device rectangle DR.
void
View::lrect_to_drect(Lrect* lr, Drect* dr)
{
  this->lpoint_to_dpoint(RECT_TOP(lr), RECT_TOP(dr));
  this->lpoint_to_dpoint(RECT_BOT(lr), RECT_BOT(dr));
}

int
View::LXUnit()
{
  return(this->internal_dpi / gcd(this->internal_dpi, POINT_X(this->device_dpi)));
}

int
View::LYUnit()
{
  return(this->internal_dpi / gcd(this->internal_dpi, POINT_Y(this->device_dpi)));
}

int
View::WXUnit()
{
  return(POINT_X(this->device_dpi) / gcd(this->internal_dpi, POINT_X(this->device_dpi)));
}

int
View::WYUnit()
{
  return(POINT_Y(this->device_dpi) / gcd(this->internal_dpi, POINT_Y(this->device_dpi)));
}

// drawing

void
View::set_brush_org(Drect* dr, HBRUSH brush)
{
  POINT p;
  p.x = RECT_TOP_X(dr);
  p.y = RECT_TOP_Y(dr);
  HWND window = this->MaybeGetWindowHandle();
  if (window != 0)
  {
    ClientToScreen(window, &p);
  }
  UnrealizeObject(brush);
  HDC dc = this->GetDC();
#ifdef _WIN32
  SetBrushOrgEx(dc, p.x, p.y, NULL);
#else /* _WIN32 */
  SetBrushOrg(dc, p.x, p.y);
#endif /* _WIN32 */
}
