// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vmem.h,v 3.2 1999/05/12 00:22:16 kudou Exp $
// implement VMem class, to hide difference between new type allocations
// under 64K and larger ones using GlobalAlloc

#ifndef VMEM_H
#define VMEM_H

class VMemSmall;
class VMemBig;

class VMem
{
  friend class VMemSmall;
  friend class VMemBig;
protected:
  void* stuff;
  udword size;
  bool force_big;
  int l;
  
public:
  static VMem* Make(int l, bool force_big = False);
  static VMem* Make(udword size);
  
  // next 3 functions returns NULL, in case of less memory.
  static VMem* CopyHandle(HANDLE h);
  static VMem* Duplicate(VMem* vm);
  HANDLE CopyToHandle();

  virtual ~VMem();
  virtual VMem* Remake(int l) = 0;
  VMem* Double(udword min_size);
  virtual bool IsHuge() = 0;
  operator void*()
  {
    return stuff;
  }
  void* GetStuff()
  {
    return stuff;
  }
  udword GetSize()
  {
    return size;
  }
  VMemSmall* CastToVMemSmall()
  {
    return(VMemSmall*)this;
  }
  VMemBig* CastToVMemBig()
  {
    return(VMemBig*)this;
  }
};

class VMemSmall
  : public VMem
{
  friend class VMem;
  friend class VMemBig;
  
  VMemSmall(int l);
  ~VMemSmall();
  virtual VMem* Remake(int l);
  virtual bool IsHuge();
};

class VMemBig
  : public VMem
{
  friend class VMem;
  friend class VMemSmall;
  
  HANDLE h;
  bool read_only;
  
  VMemBig(void* mem);
  VMemBig(int l);
  virtual ~VMemBig();
  virtual VMem* Remake(int l);
  virtual bool IsHuge();
public:
  VMemBig(HANDLE h, bool read_only);
  HANDLE GrabHandle();
  HANDLE GetHandle()
  {
    return h;
  }
};

#endif /* VMEM_H */
