// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: vttime.cpp,v 3.3 1999/05/12 00:22:16 kudou Exp $
// implementation of VTTime class

#include "pword.h"
#include "vttime.h"
#include "pmenus.h"
#include "dialogs.h"
#include "pwordpre.h"	
#include "mwindow.h"	
#include "pref.h"
#include "document.h"
#include "docedit.h"
#include "docwindo.h"
#include "screen.h"
#include "xstr.h"

VTTimeDialog::VTTimeDialog()
{
  this->class_name = "VTTime";
  cur_how = IDD_VTTime_Hankaku;
}

void
VTTimeDialog::Go()
{
  if (this->GetHandle() == 0)
  {
    PModelessDialog::Go();
  }
  this->BringToTop();
  this->Show();
}

LRESULT_T
VTTimeDialog::WndProc(MSG_T Msg, WPARAM_T wParam, LPARAM_T /*lParam*/)
{
  switch (Msg)
  {
   case WM_INITDIALOG:
    {			
      // set format to default
      set_item_check(cur_how);
      
      // fix text for gengo
      {
	char* gengolab = new char [strlen(Pref_gengo) + 16];
	wsprintf(gengolab, "'%s'%s", Pref_gengo, S_GengoAccelerator);
	SetItemText(IDD_VTTime_HeiseiYearT, gengolab);
	delete gengolab;
      }
      return 1;
    }
			
   case WM_CLOSE:
    Hide();
    return 0;
    
   case WM_COMMAND:
    {
#ifdef _WIN32
      if (LOWORD(wParam) == IDOK)
#else /* _WIN32 */
      if (wParam == IDOK)
#endif /* _WIN32 */
      {
	Hide();
	return 0;
      }
#ifdef _WIN32
      int group = LOWORD(wParam) >>8;
#else /* _WIN32 */
      int group = wParam >> 8;
#endif /* _WIN32 */
      switch (group)
      {
       case 0x01:
	if (Selected_Window) 
	{
#ifdef _WIN32
	  Selected_Window->GetEditor()->VariableTextTime(LOWORD(wParam), cur_how);
#else /* _WIN32 */
	  Selected_Window->GetEditor()->VariableTextTime(wParam, cur_how);
#endif /* _WIN32 */
	}
	else MessageBeep(0);
	return 1;
	
       case 0x02:
#ifdef _WIN32
	cur_how = LOWORD(wParam);
#else /* _WIN32 */
	cur_how = wParam;
#endif /* _WIN32 */
	break;
       
       case 0x03:
	if (Selected_Window) {
	  const int buflen = 64;
	  char* buf = new char [ buflen+1 ];
	  if (buf)
	  {
#ifdef _WIN32
	    GetItemText(LOWORD(wParam), buf, buflen);
#else /* _WIN32 */
	    GetItemText(wParam, buf, buflen);
#endif /* _WIN32 */
	    char* start = buf;
	    if (*start == '\'') start++;
	    if (*start == '&') start++;
	    for (char* c=start; *c; c=::AnsiNext(c))
	    {
	      if (*c == '\'')
	      {
		*c = '\0';
		break;
	      }
	    }
	    int stuff_len;
	    sjis* stuff = jisz_spread(start, &stuff_len);
	    (Selected_Window->GetEditor()
	     ->InsertStuff(stuff, stuff_len, PUndo::UD_Input));
	    delete stuff;
	    delete buf;
	  }
	}
	else MessageBeep(0);
	return 1;
      }
    }
  }
  return 0;
}
