// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: window.h,v 3.4 2000/05/04 13:44:10 kudou Exp $
// definitions for class window

#ifndef WINDOW_H
#define WINDOW_H

typedef LRESULT_T CALLBACK _export WND_PROC(HANDLE, MSG_T, WPARAM_T, LPARAM_T);

class Window
{
public:
  HWND	hWnd;
  void SetHandle(HWND hWnd);
  
public:
  Window();
  ~Window();
  
public:
  virtual LRESULT_T WndProc(MSG_T, WPARAM_T, LPARAM_T);

  // lexical method
public:
  BOOL Enable(BOOL b);
  HDC BeginPaint(PAINTSTRUCT* ps);
  HWND GetHandle();
  HWND SetFocus();
  LRESULT SendMessage(UINT msg);
  LRESULT SendMessage(UINT msg, WPARAM_T wparam);
  LRESULT SendMessage(UINT msg, WPARAM_T wparam, LPARAM_T lparam);
  int Hide();
  int IsWindow();
  int Show();
  int Show(int command);
  LRESULT DefWindowProc(MSG_T iMessage, WPARAM_T wParam, LPARAM_T lParam);
  void BringToTop();
  void Check();
  void ClientToScreen(POINT* pt);
  void Destroy();
  void EndPaint(PAINTSTRUCT* ps);
  void GetClientRect(RECT* rect);
  void GetRect(RECT* rect);
  void InvalidateAll();
  void InvalidateRect(RECT* r);
  void Move(int x, int y, int width, int height, BOOL repaint = True);
  void ScreenToClient(POINT* pt);
  void SetPos(HWND after, int x, int y, int cx, int cy, WORD flags);
  void SetText(char* text);
  void Update();
  void center_window();
#ifndef NDEBUG
  void CheckAtDebugTime();
#endif
};

inline void
Window::Check()
{
#ifndef NDEBUG
  this->CheckAtDebugTime();
#endif
}

inline HWND
Window::GetHandle()
{
  return(this->hWnd);
}

inline void
Window::SetHandle(HWND hWnd)
{
  this->hWnd = hWnd;
}

inline HWND
Window::SetFocus()
{
  this->Check();
  return(::SetFocus(this->hWnd));
}

inline void
Window::BringToTop()
{
  this->Check();
  ::BringWindowToTop(this->hWnd);
}

inline void
Window::SetPos(HWND after, int x, int y, int cx, int cy, WORD flags)
{
  this->Check();
  ::SetWindowPos(this->hWnd, after, x, y, cx, cy, flags);
}

inline void
Window::Move(int x, int y, int width, int height, BOOL repaint)
{
  this->Check();
  ::MoveWindow(this->hWnd, x, y, width, height, repaint);
}

inline void
Window::SetText(char* text)
{
  this->Check();
  ::SetWindowText(this->hWnd, text);
}

inline void
Window::GetRect(RECT* rect)
{
  this->Check();
  ::GetWindowRect(this->hWnd, rect);
}

inline void
Window::GetClientRect(RECT* rect)
{
  this->Check();
  ::GetClientRect(this->hWnd, rect);
}

inline void
Window::ClientToScreen(POINT* pt)
{
  this->Check();
  ::ClientToScreen(hWnd, pt);
}

inline void
Window::ScreenToClient(POINT* pt)
{
  this->Check();
  ::ScreenToClient(hWnd, pt);
}

inline HDC
Window::BeginPaint(PAINTSTRUCT* ps)
{
  this->Check();
  return(::BeginPaint(this->hWnd, ps));
}

inline void
Window::EndPaint(PAINTSTRUCT* ps)
{
  this->Check();
  ::EndPaint(this->hWnd, ps);
}

inline BOOL
Window::Enable(BOOL b)
{
  this->Check();
  return(::EnableWindow(this->hWnd, b));
}

// prototypes for the generic wndproc, and that for MDI children

extern "C"
{
  LRESULT_T CALLBACK _export xWndProc(HWND, MSG_T, WPARAM_T, LPARAM_T);
  LRESULT_T CALLBACK _export mWndProc(HWND, MSG_T, WPARAM_T, LPARAM_T);
  LRESULT_T CALLBACK _export fWndProc(HWND, MSG_T, WPARAM_T, LPARAM_T);
  LRESULT_T xWndProc_ (HWND, MSG_T, WPARAM_T, LPARAM_T);
  LRESULT_T mWndProc_ (HWND, MSG_T, WPARAM_T, LPARAM_T);
  LRESULT_T fWndProc_ (HWND, MSG_T, WPARAM_T, LPARAM_T);
}

// pointer manipulation functions which do SetWindowWord and SetWindowLong
// kinds of things to plug in or retrieve the this pointer we hide in the
// window structure.

Window* GetPointer(HWND, int offset = 0);
void SetPointer(HWND, Window* , int offset = 0);

inline Window* 
GetPointer(HWND hWnd, int offset)
{
  return((Window*) GetWindowLong(hWnd, offset));
}

inline void
SetPointer(HWND hWnd, Window* pWindow, int offset)
{
  SetWindowLong(hWnd, offset, (LONG) pWindow);
}

#endif /* WINDOW_H */
