// BeatWord Version 3.0

// BeatWord is a trademark of MSA Co.,LTD.
// Copyright (C) 1992, 1993 Pacifitech Corp.
// Copyright (C) 1999-2000 CYPAC Co.,Inc.

// This file is a free software. CYPAC gives you unlimited
// permission to copy and/or distribute it, as long as this 
// notice is preserved.

// $Id: wstdio.cpp,v 3.4 2000/05/13 16:29:07 kudou Exp $
// getchar, putchar, printf  Windows Ŏg悤ɂB

#ifndef NDEBUG

#include "pword.h"
#include <windows.h>
#include "wstdio.h"
#ifndef _WIN32
#  include <memory.h>
#endif
#include <stdarg.h>
#include <string.h>

//	#include "wstdio.h"
// ĂƁB
//
// bcc -WS -DSELF_MAIN wstdio.cpp

// FOR, END_FOR - for ̊gB
// C++ ł for ƓlɁA ŕϐ錾\ɂ܂B
// gp͎̒ʂB
//
//	FOR(int i = 0, i != LIMIT, ++i)
//	{
//	  func(i);
//	}
//	END_FOR;
#define FOR(inits, test, step) \
{ \
  inits; \
  for (; test; step) \
  { \
    
#define END_FOR \
  } \
} \

// REPEAT, END_REPEAT - Vvȃ[vB
// 錈܂񐔂[vJԂꍇɎg܂B A [v
// ł̐ϐ̒lǂȂĂ邩͕ۏ؂܂B gp͎̒ʂB
//
//	int *p = &int_array[0];
//	REPEAT(n, number_of(int_array))
//	{
//	  *p++ = DEFAULT_VALUE;
//	} END_REPEAT;
#define REPEAT(var, count) FOR(unsigned int var = (count), var != 0, --var)
#define END_REPEAT END_FOR

// wstdio ŎgtHgB Œ蕝tHgɂ邱ƁB
#define STDIO_FONT SYSTEM_FIXED_FONT

// wstdio ̃XN[̃TCYB
#define STDIO_WIDTH 80
#define STDIO_HEIGHT 24

// XN[̓eobt@B Xy[XŏB
// (x, y) ̕ `screen[y][x]' ŎQƂB
static char far screen[STDIO_HEIGHT][STDIO_WIDTH];

// |Cg̈ʒuB ʍ̋ (point_x, point_y) == (0, 0) B
// ʉE̋ (STDIO_WIDTH - 1, STDIO_HEIGHT - 1) B
static int point_x;
static int point_y;

// STDIO_FONT ̕ƍB
static int font_width;
static int font_height;

// wstdio ŐEBhEB ̂ƂA  1 ̃EBhE
// Ȃ̂ŁA ̂悤ȃX^C̗p邱ƂłB
static HWND window;

// `window' ɑ΂`̂߂̃fBXvCReLXgB
static HDC dc;

// ̃EBhEɕ`悷FB
static DWORD background;
static DWORD foreground;

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

static int offset_y;
#define POS_X(x) (font_width * (x))
#define POS_Y(y) (font_height * (y) + offset_y)

long far pascal _export stdio_window_proc(HWND win, WORD type, WORD param16, LONG param32);

static void near
get_system_colors(void)
{
  background = GetSysColor(COLOR_WINDOW);
  foreground = GetSysColor(COLOR_WINDOWTEXT);
}

static void near
drawing_prologue(void)
{
  RECT rect;
  GetClientRect(window, &rect);
  offset_y = rect.bottom - font_height * STDIO_HEIGHT;
  SetBkMode(dc, OPAQUE);
  SetBkColor(dc, background);
  SetTextColor(dc, foreground);
  SelectObject(dc, GetStockObject(STDIO_FONT));
}

static void near
drawing_epilogue(void)
{
}

static void near
newline(void)
{
  point_x = 0;
  if (++point_y == STDIO_HEIGHT)
  {
    point_y = STDIO_HEIGHT - 1;
    memmove(screen[0], screen[1], sizeof(screen) - sizeof(screen[0]));
    memset(screen[STDIO_HEIGHT - 1], ' ', sizeof(screen[0]));
    ScrollWindow(window, 0, -font_height, NULL, NULL);
  }
}

static void near
draw_char(int c)
{
  screen[point_y][point_x] = c;
  TextOut(dc, POS_X(point_x), POS_Y(point_y), screen[point_y] + point_x, 1);
  if (++point_x == STDIO_WIDTH)
  {
    newline();
  }
}

static void near
draw_point(void)
{
  RECT rect;
  
  rect.top = POS_Y(point_y);
  rect.bottom = POS_Y(point_y + 1);
  rect.left = POS_X(point_x);
  rect.right = POS_X(point_x + 1);
  InvertRect(dc, &rect);
}

static void near
redisplay(void)
{
  PAINTSTRUCT ps;
  dc = BeginPaint(window, &ps);
  drawing_prologue();
  FOR(int y = 0, y != STDIO_HEIGHT, ++y)
  {
    TextOut(dc, 0, POS_Y(y), screen[y], STDIO_WIDTH);
  } END_FOR;
  draw_point();
  drawing_epilogue();
  EndPaint(window, &ps);
}

static void near
putchar0(int c)
{
  c = (unsigned char) c;
  if (c == '\n')
  {
    newline();
  }
  else if (c == '\b')
  {
    if (--point_x < 0)
    {
      point_x = STDIO_WIDTH - 1;
      if (--point_y < 0)
      {
	point_y = 0;
      }
    }
  }
  else if (c == '\t')
  {
    do
    {
      draw_char(' ');
    } while (point_x % 8 != 0);
  }
  else if (c < ' ')
  {
    draw_char('^');
    draw_char('@' + c);
  }
  else if (c == 0x7f)
  {
    draw_char('^');
    draw_char('?');
  }
  else
  {
    draw_char(c);
  }
}

static void near
putchar_prologue(void)
{
  dc = GetDC(window);
  drawing_prologue();
  draw_point();
}

static void near
putchar_epilogue(void)
{
  draw_point();
  drawing_epilogue();
  ReleaseDC(window, dc);
}

static int near
getchar0(void)
{
  MSG msg;
  while (GetMessage(&msg, NULL, NULL, NULL))
  {
    if (msg.message == WM_CHAR)
    {
      int c = (unsigned char) msg.wParam;
      switch (c)
      {
       case '\n':
	c = '\r';
	break;

       case '\r':
	c = '\n';
	break;
      }
      return(c);
    }
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return(-1);
}

static unsigned char far getchar_buffer[READLINE_BUFFER_SIZE];
static char far getchar_bs_count[READLINE_BUFFER_SIZE];
static int getchar_buffer_count;
static int getchar_buffer_index;

static void near
beep(void)
{
  MessageBeep(0);
}

static BOOL near
fill_getchar_buffer(void)
{
  if (getchar_buffer_count < 0)
  {
    return(FALSE);
  }

  if (getchar_buffer_index == getchar_buffer_count)
  {
    getchar_buffer_index = 0;
    getchar_buffer_count = 0;
    for (;;)
    {
      int c = getchar0();
      if (c == -1)
      {
	if (getchar_buffer_count == 0)
	{
	  getchar_buffer_count = -1;
	  return(FALSE);
	}
	break;
      }
      if (c == '\b')
      {
	if (getchar_buffer_count == 0)
	{
	  beep();
	}
	else
	{
	  putchar_prologue();
	  --getchar_buffer_count;
	  REPEAT(n, getchar_bs_count[getchar_buffer_count])
	  {
	    putchar0('\b');
	  } END_REPEAT;
	  REPEAT(n, getchar_bs_count[getchar_buffer_count])
	  {
	    putchar0(' ');
	  } END_REPEAT;
	  REPEAT(n, getchar_bs_count[getchar_buffer_count])
	  {
	    putchar0('\b');
	  } END_REPEAT;
	  putchar_epilogue();
	}
      }
      else
      {
	if (c != '\n' && READLINE_BUFFER_SIZE - 1 <= getchar_buffer_count)
	{
	  beep();
	}
	else
	{
	  int n;
	  
	  int old_x = point_x;
	  putchar(c);
	  n = point_x - old_x;
	  if (n <= 0)
	  {
	    n += STDIO_WIDTH;
	  }
	  getchar_buffer[getchar_buffer_count] = c;
	  getchar_bs_count[getchar_buffer_count] = n;
	  ++getchar_buffer_count;
	}
      }
      if (c == '\n')
      {
	break;
      }
    }
  }
  
  return(TRUE);
}

long far pascal _export
stdio_window_proc(HWND win, WORD type, WORD param16, LONG param32)
{
  window = win;
  switch (type)
  {
   default:
    return(DefWindowProc(window, type, param16, param32));

   case WM_DESTROY:
    return(0);
    
   case WM_SYSCOLORCHANGE:
     // Rg[plŐFύXꂽꍇB
    get_system_colors();
    InvalidateRect(window, NULL, TRUE);
    break;
    
   case WM_PAINT:
    redisplay();
    break;
  }
  return(0L);
}

// ------------------------------------------------------------
// initialize

static HINSTANCE instance;

static void
initialize0()
{
  static int initialized = FALSE;
  if (!initialized)
  {
    initialized = TRUE;
    
    char name_buf[100];
    WNDCLASS window_class;
    
    window_class.style = CS_HREDRAW | CS_VREDRAW;
    // Ignore type checking
    //   HACK HACK HACK HACK HACK
    *((void **) &window_class.lpfnWndProc) = (void *) stdio_window_proc;
//    window_class.lpfnWndProc = stdio_window_proc;
    window_class.cbClsExtra = 0;
    window_class.cbWndExtra = 0;
    window_class.hInstance = instance;
    window_class.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    window_class.hCursor = (HICON)LoadCursor(NULL, IDC_ARROW);
#ifdef _WIN32
    window_class.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
#else /* _WIN32 */
    window_class.hbrBackground = COLOR_WINDOW + 1,
#endif /* _WIN32 */ 
    window_class.lpszMenuName = NULL;
    window_class.lpszClassName = name_buf;
    for (int i = 0;; ++i)
    {
      wsprintf(name_buf, "StdioWindowClass<%d>", i);
      if (RegisterClass(&window_class))
      {
	break;
      }
    }
    
    window = CreateWindow(name_buf,
			   "Stdio Window",
			   WS_OVERLAPPEDWINDOW,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT,
			   CW_USEDEFAULT, NULL, NULL, instance, NULL);
    if (window == NULL)
    {
      return;
    }
    
    // tHg̃TCY𓾂B
    {
      TEXTMETRIC metric;
      
      dc = GetDC(window);
      SelectObject(dc, GetStockObject(STDIO_FONT));
      
      if (!GetTextMetrics(dc, &metric))
      {
	return;
      }
      
      font_width = metric.tmAveCharWidth;
      font_height = metric.tmHeight;
      ReleaseDC(window, dc);
    }
    
    get_system_colors();
    
    memset(screen, ' ', sizeof(screen));
    point_x = 0;
    point_y = STDIO_HEIGHT - 1;
    
    ShowWindow(window, TRUE);
    UpdateWindow(window);
  }
}

// ------------------------------------------------------------
// public interface

int
getchar(void)
{
  initialize0();
  return(fill_getchar_buffer() ? getchar_buffer[getchar_buffer_index++]
	  : -1);
}

int
putchar(int c)
{
  initialize0();
  putchar_prologue();
  putchar0(c);
  putchar_epilogue();
  return(c);
}

// `line'  1 sǂݍ݁A ǂݍ񂾕ԂB -1 Ȃ 0 ԂB 
// `line'  `READLINE_BUFFER_SIZE' mۂĂƁB
int
read_line(char* line)
{
  initialize0();
  if (!fill_getchar_buffer())
  {
    return(0);
  }
  else
  {
    int count = getchar_buffer_count - getchar_buffer_index;
    memcpy(line, getchar_buffer + getchar_buffer_index, count);
    getchar_buffer_index = getchar_buffer_count;
    return(count);
  }
}

void
write_line(char* p, int n)
{
  initialize0();
  if (0 < n)
  {
    putchar_prologue();
    do
    {
      putchar0(*p++);
    } while (--n != 0);
    putchar_epilogue();
  }
}

#ifdef __CYGWIN32__
int
printf(char* format, ...)
#else /* __CYGWIN32__ */
int cdecl
printf(char* format, ...)
#endif /* __CYGWIN32__ */
{
  initialize0();
  char buffer[READLINE_BUFFER_SIZE * 2]; // temporary buffer, ad hoc
  va_list ap;
  
  va_start(ap, format);

#if 0
// These values are defined in "pword.h"
#ifdef __BORLANDC__
#define VA_LIST char* 
#else /* not __BORLANDC__ */
#define VA_LIST void* 
#endif /* not __BORLANDC__ */
#endif  

  int num_chars = wvsprintf(buffer, format, (VA_LIST) ap);
  va_end(ap);
  
  putchar_prologue();
  FOR(int i = 0, i != num_chars, ++i)
  {
    putchar0(buffer[i]);
  } END_FOR;
  putchar_epilogue();
  
  return(num_chars);
}

void
initialize_wstdio(HINSTANCE h_instance)
{
  instance = h_instance;
}

#if (defined(SELF_MAIN))
int PASCAL
WinMain(HANDLE hInstance,
	 HANDLE /* hPrevInstance */,
	 LPSTR /* lpszCmdLine */, int /* nCmdShow */)
{
  initialize_wstdio(hInstance);
  int c;
  while ((c = getchar()) != 4)
  {
    putchar(c);
  }
  return(0);
}
#endif
#endif /* NDEBUG */
