/* BeatWord Version 3.0
 *
 * BeatWord is a trademark of MSA Co.,LTD.
 * Copyright (C) 1992, 1993 Pacifitech Corp.
 * Copyright (C) 1999-2000 CYPAC Co.,Inc.
 *
 * This file is a free software. CYPAC gives you unlimited
 * permission to copy and/or distribute it, as long as this 
 * notice is preserved.
 *
 */
/* $Id: kana-decode.c,v 3.2 1999/05/12 00:24:48 kudou Exp $
 * @SpL@𔼊pJ^JiɃRo[g
 * X Version 2 ł͂̃t@C EUC ŃZ[u
 * AR[hOƂĂAWin32 ɂ
 * rhł悤 SJIS pɏB
 * : ̃t@C SJIS ŃZ[ûƁB
 */

#include <stdio.h>
#include <stdlib.h>

#include "kana.h"

#define nil 0
#define t 1

#define kana_ten 0xde
#define kana_maru 0xdf

#define kana_table_start 0xa0
#define kana_table_size 0x40
#define zkana_table_start (unsigned int) 0x8100
#define zkana_table_size (256 * 3)

struct zkana_table
{
  unsigned char ch0;
  unsigned char ch1;
};

static void
bad_kana_code (high, low)
int high;
int low;
{
  fprintf (stderr, "Bad zenkaku kana code 0x%02x, 0x%02x\n", high, low);
  exit (1);
}

static struct zkana_table *
zkana_entry (high, low)
int high;
int low;
{
  static struct zkana_table zkana_table[zkana_table_size];
  unsigned int code = ((unsigned int) high << 8) + (unsigned int) low;
  if (zkana_table_start <= code)
  {
    code -= zkana_table_start;
    if (code < zkana_table_size)
    {
      return (&zkana_table[code]);
    }
  }
  bad_kana_code (high, low);
  return 0;	/* dummy */
}

static void
define_kana (s, ch0, ch1)
char *s;
int ch0;
int ch1;
{
  unsigned int high = (unsigned int)((unsigned char)s[0]);
  unsigned int low = (unsigned int)((unsigned char)s[1]);
  struct zkana_table *zkana = zkana_entry (high, low);
  zkana->ch0 = ch0;
  zkana->ch1 = ch1;
}

static void
initialize_table ()
{
  define_kana ("A", 0xb1, 0);
  define_kana ("C", 0xb2, 0);
  define_kana ("E", 0xb3, 0);
  define_kana ("G", 0xb4, 0);
  define_kana ("I", 0xb5, 0);
  define_kana ("J", 0xb6, 0);
  define_kana ("L", 0xb7, 0);
  define_kana ("N", 0xb8, 0);
  define_kana ("P", 0xb9, 0);
  define_kana ("R", 0xba, 0);
  define_kana ("T", 0xbb, 0);
  define_kana ("V", 0xbc, 0);
  define_kana ("X", 0xbd, 0);
  define_kana ("Z", 0xbe, 0);
  define_kana ("\", 0xbf, 0);
  define_kana ("^", 0xc0, 0);
  define_kana ("`", 0xc1, 0);
  define_kana ("c", 0xc2, 0);
  define_kana ("e", 0xc3, 0);
  define_kana ("g", 0xc4, 0);
  define_kana ("i", 0xc5, 0);
  define_kana ("j", 0xc6, 0);
  define_kana ("k", 0xc7, 0);
  define_kana ("l", 0xc8, 0);
  define_kana ("m", 0xc9, 0);
  define_kana ("n", 0xca, 0);
  define_kana ("q", 0xcb, 0);
  define_kana ("t", 0xcc, 0);
  define_kana ("w", 0xcd, 0);
  define_kana ("z", 0xce, 0);
  define_kana ("}", 0xcf, 0);
  define_kana ("~", 0xd0, 0);
  define_kana ("", 0xd1, 0);
  define_kana ("", 0xd2, 0);
  define_kana ("", 0xd3, 0);
  define_kana ("", 0xd4, 0);
  define_kana ("", 0xd5, 0);
  define_kana ("", 0xd6, 0);
  define_kana ("", 0xd7, 0);
  define_kana ("", 0xd8, 0);
  define_kana ("", 0xd9, 0);
  define_kana ("", 0xda, 0);
  define_kana ("", 0xdb, 0);
  define_kana ("", 0xdc, 0);
  define_kana ("", 0xa6, 0);
  define_kana ("", 0xdd, 0);
  define_kana ("@", 0xa7, 0);
  define_kana ("B", 0xa8, 0);
  define_kana ("D", 0xa9, 0);
  define_kana ("F", 0xaa, 0);
  define_kana ("H", 0xab, 0);
  define_kana ("b", 0xaf, 0);
  define_kana ("", 0xac, 0);
  define_kana ("", 0xad, 0);
  define_kana ("", 0xae, 0);
  define_kana ("", 0xb3, kana_ten);
  define_kana ("K", 0xb6, kana_ten);
  define_kana ("M", 0xb7, kana_ten);
  define_kana ("O", 0xb8, kana_ten);
  define_kana ("Q", 0xb9, kana_ten);
  define_kana ("S", 0xba, kana_ten);
  define_kana ("U", 0xbb, kana_ten);
  define_kana ("W", 0xbc, kana_ten);
  define_kana ("Y", 0xbd, kana_ten);
  define_kana ("[", 0xbe, kana_ten);
  define_kana ("]", 0xbf, kana_ten);
  define_kana ("_", 0xc0, kana_ten);
  define_kana ("a", 0xc1, kana_ten);
  define_kana ("d", 0xc2, kana_ten);
  define_kana ("f", 0xc3, kana_ten);
  define_kana ("h", 0xc4, kana_ten);
  define_kana ("o", 0xca, kana_ten);
  define_kana ("r", 0xcb, kana_ten);
  define_kana ("u", 0xcc, kana_ten);
  define_kana ("x", 0xcd, kana_ten);
  define_kana ("{", 0xce, kana_ten);
  define_kana ("p", 0xca, kana_maru);
  define_kana ("s", 0xcb, kana_maru);
  define_kana ("v", 0xcc, kana_maru);
  define_kana ("y", 0xcd, kana_maru);
  define_kana ("|", 0xce, kana_maru);
  define_kana ("[", 0xb0, 0);
}

static void
putchar_octal (c)
int c;
{
#ifdef OCTAL_DECODE
  printf ("\\%03o", (unsigned char) c);
#else /* OCTAL_DECODE */
  putchar (c);
#endif /* OCTAL_DECODE */
}

int
main ()
{
  initialize_table ();
  {
    int quotedp = nil;
    int ch0;
    int ch1;
    while ((ch0 = getchar ()) != EOF)
    {
      if (quotedp)
      {
	quotedp = nil;
	if (ch0 == '@')
	{
	  putchar (ch0);
	}
	else
	{
	  struct zkana_table *zkana;
	  ch1 = getchar ();
	  zkana = zkana_entry (ch0, ch1);
	  if (zkana->ch0 == '\0')
	  {
	    bad_kana_code (ch0, ch1);
	  }
	  putchar_octal (zkana->ch0);
	  if (zkana->ch1)
	  {
	    putchar_octal (zkana->ch1);
	  }
	}
      }
      else if (ch0 == '@')
      {
	quotedp = t;
      }
      else
      {
	if (kanji_first_p (ch0))
	{
	  ch1 = getchar ();
	  if (ch0 == '\"'
	      || ch1 == '\"'
	      || ch0 == '\'' || ch1 == '\'' || ch0 == '\\' || ch1 == '\\')
	  {
	    putchar_octal (ch0);
	    putchar_octal (ch1);
	  }
	  else
	  {
	    putchar (ch0);
	    putchar (ch1);
	  }
	}
	else
	{
	  putchar (ch0);
	}
      }
    }
  }
  return (0);
}
