/* BeatWord Version 3.0
 *
 * BeatWord is a trademark of MSA Co.,LTD.
 * Copyright (C) 1992, 1993 Pacifitech Corp.
 * Copyright (C) 1999-2000 CYPAC Co.,Inc.
 *
 * This file is a free software. CYPAC gives you unlimited
 * permission to copy and/or distribute it, as long as this 
 * notice is preserved.
 *
 */
/* $Id: kana-encode.c,v 3.2 1999/05/12 00:24:56 kudou Exp $
 * pȕSpȂɃRo[g
 */

#include <stdio.h>
#include <stdlib.h>

#define ANSI 1

#ifndef ANSI
#   define void char
#endif
#define CR 0x0d
#define LF 0x0a

#define issjis(c) ((((c) >= 0x81) && ((c) <= 0x9f)) || (((c) >= 0xe0) && ((c) <= 0xfc)))

/*


Âł
΂тԂׂ
ς҂Ղ؂
*/

/* 
KMOQS
UWY[]
_adfh
orux{
psvy|
*/

/*
 ACEGIKM

ÓŔǕɖ˗
ϙњӛ՜םٞ۟
*/

#define MARU   0xa1	/*  */
#define UEMARU 0xdf	/*  */
#define DAKU   0xde	/*  */
#define KA     0xb6	/*  */
#define TO     0xc4	/*  */
#define HA     0xca	/*  */
#define HO     0xce	/*  */

unsigned char ZenkakuHira[] = "BuvAE[ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂JK";
unsigned char DakuHira[]  = "Âł";
unsigned char DakuHira2[] = "΂тԂׂ";
unsigned char DakuHira3[] = "ς҂Ղ؂";

unsigned char ZenkakuKata[] = "BuvAE@BDFHb[ACEGIJLNPRTVXZ\^`cegijklmnqtwz}~JK";
unsigned char DakuKata[]  = "KMOQSUWY[]_adfh";
unsigned char DakuKata2[] = "orux{";
unsigned char DakuKata3[] = "psvy|";

unsigned char* Zenkaku = ZenkakuKata;
unsigned char* Daku = DakuKata;
unsigned char* Daku2 = DakuKata2;
unsigned char* Daku3 = DakuKata3;

/* -------------------------------------------------------------------- */
/*	convert Hankaku Kana to Zenkaku Kana				*/
/*									*/
/* void convert(source, dest)						*/
/* char* source;		source file name			*/
/* char* dest;			destnation file name			*/
/* -------------------------------------------------------------------- */
void convert(source, dest)
char* source;
char* dest;
{
   FILE* s;
   FILE* d;
   unsigned int c;
   unsigned int index;
   unsigned int next;
   unsigned char* out1;
   unsigned char* out2;
   
   if ((s = fopen(source, "r+b")) == NULL) {
      fprintf(stderr, "Can't open %s!!\n", source);
      exit(1);
   }
   if ((d = fopen(dest, "w+b")) == NULL) {
      fprintf(stderr, "Can't open %s!!\n", dest);
      exit(1);
   }
   /* main loop */
   while ((c = fgetc(s)) != (unsigned int)EOF) {
      if (issjis(c)) {				/* Shift Jis */
         fputc(c, d);
         fputc(fgetc(s), d);
      }
      else if (c >= MARU && c <= UEMARU) {	/* Hankaku Kana */
	 fputc ('@', d);
         index = (c - MARU) * 2;
         if (c >= KA && c <= TO) {		/*  ~  */
            if ((next = fgetc(s)) == (unsigned int)EOF) {
               /* End of file */
               fputc((unsigned int)Zenkaku[index++], d);
               fputc((unsigned int)Zenkaku[index], d);
               break;
            }
            if (next == DAKU) {
               index = (c - KA) * 2;
               out1 = &Daku[index++];
               out2 = &Daku[index];
            }
            else {
               ungetc(next, s);
               out1 = &Zenkaku[index++];
               out2 = &Zenkaku[index];
            }
         }
         else if (c >= HA && c <= HO) {		/*  ~  */
            if ((next = fgetc(s)) == (unsigned int)EOF) {
               /* End of file */
               fputc((unsigned int)Zenkaku[index++], d);
               fputc((unsigned int)Zenkaku[index], d);
               break;
            }
            if (next == DAKU) {
               index = (c - HA) * 2;
               out1 = &Daku2[index++];
               out2 = &Daku2[index];
            }
            else if (next == UEMARU) {
               index = (c - HA) * 2;
               out1 = &Daku3[index++];
               out2 = &Daku3[index];
            }
            else {
               ungetc(next, s);
               out1 = &Zenkaku[index++];
               out2 = &Zenkaku[index];
            }
         }
         else {					/* the other */
            out1 = &Zenkaku[index++];
            out2 = &Zenkaku[index];
         }
         fputc((unsigned int)*out1, d);
         fputc((unsigned int)*out2, d);
      }
      else {					/* ASCI */
	 if (c == '@')
	 {
	   fputc(c, d);
	 }
	 fputc(c, d);
      }
   }
   fclose(s);
   fclose(d);
}

/* -------------------------------------------------------------------- */
/*	main								*/
/* -------------------------------------------------------------------- */
int main(argc, argv)
int argc;
char** argv;
{
   if (argc < 3) {
      fprintf(stderr, "convert Hankaku Kana to Zenkaku Kana\n");
      fprintf(stderr, "USAGE:\n%s sourcefile destnationfile\n", argv[0]);
      return 1;
   }
   convert(argv[1], argv[2]);
   return 0;
}

