// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// generic.h:
//
// definition of generic macro
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/generic.h,v 1.2 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_generic_h
#define _leaf_generic_h

#ifdef DONT_HAVE_GENERIC_H
#  if defined(__TURBOC__) || defined(__BORLANDC__)
     // only Turbo/Borland C++
#    include <generic.h>
#    ifndef name2
#      define name2(a,b)   _Paste2(a,b)
#    endif
#    ifndef name3
#      define name3(a,b,c) _Paste3(a,b,c)
#    endif
#  else
#    if defined(__STDC__) || defined(_MSC_VER)
       // ANSI C preprocessor
#      define name2(a,b)	a##b
#      define name3(a,b,c)	a##b##c
#      define name4(a,b,c,d)	a##b##c##d
#    else
       // OLD C preprocessor
#      define name2(a,b)	a/**/b
#      define name3(a,b,c)	a/**/b/**/c
#      define name4(a,b,c,d)	a/**/b/**/c/**/d
#    endif
#  endif
#else
#  include <generic.h>
#endif

#endif /* _leaf_generic_h */
